/*
 * Decompiled with CFR 0.152.
 */
package org.hbase.async;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

final class SingletonList<E>
implements List<E> {
    private final E element;

    public SingletonList(E element) {
        if (element == null) {
            throw new NullPointerException("element");
        }
        this.element = element;
    }

    public String toString() {
        return "[" + this.element + ']';
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean contains(Object o) {
        return this.element.equals(o);
    }

    @Override
    public Iterator<E> iterator() {
        return new Iter<E>(this.element);
    }

    @Override
    public Object[] toArray() {
        Object[] array = new Object[]{this.element};
        return array;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        if (a.length < 1) {
            return this.toArray();
        }
        a[0] = this.element;
        if (a.length > 1) {
            a[1] = null;
        }
        return a;
    }

    @Override
    public boolean add(E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        if (c.size() != 1) {
            return false;
        }
        return c.contains(this.element);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean equals(Object other) {
        if (other == null || !(other instanceof SingletonList)) {
            return false;
        }
        return this.element.equals(((SingletonList)other).element);
    }

    @Override
    public int hashCode() {
        return 31 + this.element.hashCode();
    }

    @Override
    public E get(int index) {
        if (index != 0) {
            throw new IndexOutOfBoundsException("only 1 element but index=" + index);
        }
        return this.element;
    }

    @Override
    public E set(int index, E element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int index, E element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public E remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int indexOf(Object o) {
        return o.equals(this.element) ? 0 : -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        return o.equals(this.element) ? 0 : -1;
    }

    @Override
    public ListIterator<E> listIterator() {
        return new Iter<E>(this.element);
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        if (index != 0) {
            throw new IndexOutOfBoundsException("only 1 element but index=" + index);
        }
        return new Iter<E>(this.element);
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        if (fromIndex == 0 && toIndex == 1) {
            return this;
        }
        throw new IndexOutOfBoundsException("only 1 element but requested [" + fromIndex + "; " + toIndex + ']');
    }

    private static final class Iter<E>
    implements ListIterator<E> {
        private final E element;
        private boolean returned = false;

        public Iter(E element) {
            this.element = element;
        }

        @Override
        public boolean hasNext() {
            return !this.returned;
        }

        @Override
        public E next() {
            if (this.returned) {
                throw new NoSuchElementException();
            }
            this.returned = true;
            return this.element;
        }

        @Override
        public boolean hasPrevious() {
            return this.returned;
        }

        @Override
        public E previous() {
            if (!this.returned) {
                throw new NoSuchElementException();
            }
            this.returned = false;
            return this.element;
        }

        @Override
        public int nextIndex() {
            return this.returned ? 0 : 1;
        }

        @Override
        public int previousIndex() {
            return this.returned ? -1 : 0;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(E e) {
            throw new UnsupportedOperationException();
        }
    }
}

