/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.metrics.prometheus;

import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.Counter;
import io.prometheus.client.Gauge;
import io.prometheus.client.Summary;
import io.prometheus.client.exporter.MetricsServlet;
import io.prometheus.client.hotspot.DefaultExports;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Enumeration;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.zookeeper.metrics.Counter;
import org.apache.zookeeper.metrics.CounterSet;
import org.apache.zookeeper.metrics.Gauge;
import org.apache.zookeeper.metrics.GaugeSet;
import org.apache.zookeeper.metrics.MetricsContext;
import org.apache.zookeeper.metrics.MetricsProvider;
import org.apache.zookeeper.metrics.MetricsProviderLifeCycleException;
import org.apache.zookeeper.metrics.Summary;
import org.apache.zookeeper.metrics.SummarySet;
import org.apache.zookeeper.server.RateLogger;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrometheusMetricsProvider
implements MetricsProvider {
    private static final Logger LOG = LoggerFactory.getLogger(PrometheusMetricsProvider.class);
    private static final String LABEL = "key";
    private static final String[] LABELS = new String[]{"key"};
    static final String NUM_WORKER_THREADS = "numWorkerThreads";
    static final String MAX_QUEUE_SIZE = "maxQueueSize";
    static final String WORKER_SHUTDOWN_TIMEOUT_MS = "workerShutdownTimeoutMs";
    private final CollectorRegistry collectorRegistry = CollectorRegistry.defaultRegistry;
    private final RateLogger rateLogger = new RateLogger(LOG, 60000L);
    private String host = "0.0.0.0";
    private int port = 7000;
    private boolean exportJvmInfo = true;
    private Server server;
    private final MetricsServletImpl servlet = new MetricsServletImpl();
    private final Context rootContext = new Context();
    private int numWorkerThreads = 1;
    private int maxQueueSize = 1000000;
    private long workerShutdownTimeoutMs = 1000L;
    private Optional<ExecutorService> executorOptional = Optional.empty();

    public void configure(Properties configuration) throws MetricsProviderLifeCycleException {
        LOG.info("Initializing metrics, configuration: {}", (Object)configuration);
        this.host = configuration.getProperty("httpHost", "0.0.0.0");
        this.port = Integer.parseInt(configuration.getProperty("httpPort", "7000"));
        this.exportJvmInfo = Boolean.parseBoolean(configuration.getProperty("exportJvmInfo", "true"));
        this.numWorkerThreads = Integer.parseInt(configuration.getProperty(NUM_WORKER_THREADS, "1"));
        this.maxQueueSize = Integer.parseInt(configuration.getProperty(MAX_QUEUE_SIZE, "1000000"));
        this.workerShutdownTimeoutMs = Long.parseLong(configuration.getProperty(WORKER_SHUTDOWN_TIMEOUT_MS, "1000"));
    }

    public void start() throws MetricsProviderLifeCycleException {
        this.executorOptional = this.createExecutor();
        try {
            LOG.info("Starting /metrics HTTP endpoint at host: {}, port: {}, exportJvmInfo: {}", new Object[]{this.host, this.port, this.exportJvmInfo});
            if (this.exportJvmInfo) {
                DefaultExports.initialize();
            }
            this.server = new Server(new InetSocketAddress(this.host, this.port));
            ServletContextHandler context = new ServletContextHandler();
            context.setContextPath("/");
            this.server.setHandler((Handler)context);
            context.addServlet(new ServletHolder((Servlet)this.servlet), "/metrics");
            this.server.start();
        }
        catch (Exception err) {
            LOG.error("Cannot start /metrics server", (Throwable)err);
            if (this.server != null) {
                try {
                    this.server.stop();
                }
                catch (Exception suppressed) {
                    err.addSuppressed(suppressed);
                }
                finally {
                    this.server = null;
                }
            }
            throw new MetricsProviderLifeCycleException((Throwable)err);
        }
    }

    MetricsServletImpl getServlet() {
        return this.servlet;
    }

    public MetricsContext getRootContext() {
        return this.rootContext;
    }

    public void stop() {
        this.shutdownExecutor();
        if (this.server != null) {
            try {
                this.server.stop();
            }
            catch (Exception err) {
                LOG.error("Cannot safely stop Jetty server", (Throwable)err);
            }
            finally {
                this.server = null;
            }
        }
    }

    public void dump(BiConsumer<String, Object> sink) {
        this.sampleGauges();
        Enumeration samplesFamilies = this.collectorRegistry.metricFamilySamples();
        while (samplesFamilies.hasMoreElements()) {
            Collector.MetricFamilySamples samples = (Collector.MetricFamilySamples)samplesFamilies.nextElement();
            samples.samples.forEach(sample -> {
                String key = PrometheusMetricsProvider.buildKeyForDump(sample);
                sink.accept(key, sample.value);
            });
        }
    }

    private static String buildKeyForDump(Collector.MetricFamilySamples.Sample sample) {
        StringBuilder keyBuilder = new StringBuilder();
        keyBuilder.append(sample.name);
        if (sample.labelNames.size() > 0) {
            keyBuilder.append('{');
            for (int i = 0; i < sample.labelNames.size(); ++i) {
                if (i > 0) {
                    keyBuilder.append(',');
                }
                keyBuilder.append((String)sample.labelNames.get(i));
                keyBuilder.append("=\"");
                keyBuilder.append((String)sample.labelValues.get(i));
                keyBuilder.append('\"');
            }
            keyBuilder.append('}');
        }
        return keyBuilder.toString();
    }

    private void sampleGauges() {
        this.rootContext.gauges.values().forEach(rec$ -> ((PrometheusGaugeWrapper)rec$).sample());
        this.rootContext.gaugeSets.values().forEach(rec$ -> ((PrometheusLabelledGaugeWrapper)rec$).sample());
    }

    public void resetAllValues() {
    }

    private Optional<ExecutorService> createExecutor() {
        if (this.numWorkerThreads < 1) {
            LOG.info("Executor service was not created as numWorkerThreads {} is less than 1", (Object)this.numWorkerThreads);
            return Optional.empty();
        }
        LinkedBlockingQueue<Runnable> queue = new LinkedBlockingQueue<Runnable>(this.maxQueueSize);
        ThreadPoolExecutor executor = new ThreadPoolExecutor(this.numWorkerThreads, this.numWorkerThreads, 0L, TimeUnit.MILLISECONDS, queue, new PrometheusWorkerThreadFactory());
        LOG.info("Executor service was created with numWorkerThreads {} and maxQueueSize {}", (Object)this.numWorkerThreads, (Object)this.maxQueueSize);
        return Optional.of(executor);
    }

    private void shutdownExecutor() {
        if (this.executorOptional.isPresent()) {
            LOG.info("Shutdown executor service with timeout {}", (Object)this.workerShutdownTimeoutMs);
            ExecutorService executor = this.executorOptional.get();
            executor.shutdown();
            try {
                if (!executor.awaitTermination(this.workerShutdownTimeoutMs, TimeUnit.MILLISECONDS)) {
                    LOG.error("Not all the Prometheus worker threads terminated properly after {} timeout", (Object)this.workerShutdownTimeoutMs);
                    executor.shutdownNow();
                }
            }
            catch (Exception e) {
                LOG.error("Error occurred while terminating Prometheus worker threads", (Throwable)e);
                executor.shutdownNow();
            }
        }
    }

    private void reportMetrics(Runnable task) {
        if (this.executorOptional.isPresent()) {
            try {
                this.executorOptional.get().submit(task);
            }
            catch (RejectedExecutionException e) {
                this.rateLogger.rateLimitLog("Prometheus metrics reporting task queue size exceeded the max", String.valueOf(this.maxQueueSize));
            }
        } else {
            task.run();
        }
    }

    class MetricsServletImpl
    extends MetricsServlet {
        MetricsServletImpl() {
        }

        protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            PrometheusMetricsProvider.this.sampleGauges();
            super.doGet(req, resp);
        }
    }

    private class Context
    implements MetricsContext {
        private final ConcurrentMap<String, PrometheusGaugeWrapper> gauges = new ConcurrentHashMap<String, PrometheusGaugeWrapper>();
        private final ConcurrentMap<String, PrometheusLabelledGaugeWrapper> gaugeSets = new ConcurrentHashMap<String, PrometheusLabelledGaugeWrapper>();
        private final ConcurrentMap<String, PrometheusCounter> counters = new ConcurrentHashMap<String, PrometheusCounter>();
        private final ConcurrentMap<String, PrometheusLabelledCounter> counterSets = new ConcurrentHashMap<String, PrometheusLabelledCounter>();
        private final ConcurrentMap<String, PrometheusSummary> basicSummaries = new ConcurrentHashMap<String, PrometheusSummary>();
        private final ConcurrentMap<String, PrometheusSummary> summaries = new ConcurrentHashMap<String, PrometheusSummary>();
        private final ConcurrentMap<String, PrometheusLabelledSummary> basicSummarySets = new ConcurrentHashMap<String, PrometheusLabelledSummary>();
        private final ConcurrentMap<String, PrometheusLabelledSummary> summarySets = new ConcurrentHashMap<String, PrometheusLabelledSummary>();

        private Context() {
        }

        public MetricsContext getContext(String name) {
            return this;
        }

        public Counter getCounter(String name) {
            return this.counters.computeIfAbsent(name, x$0 -> new PrometheusCounter((String)x$0));
        }

        public CounterSet getCounterSet(String name) {
            Objects.requireNonNull(name, "Cannot register a CounterSet with null name");
            return this.counterSets.computeIfAbsent(name, x$0 -> new PrometheusLabelledCounter((String)x$0));
        }

        public void registerGauge(String name, Gauge gauge) {
            Objects.requireNonNull(name);
            this.gauges.compute(name, (id, prev) -> new PrometheusGaugeWrapper((String)id, gauge, prev != null ? prev.inner : null));
        }

        public void unregisterGauge(String name) {
            PrometheusGaugeWrapper existing = (PrometheusGaugeWrapper)this.gauges.remove(name);
            if (existing != null) {
                existing.unregister();
            }
        }

        public void registerGaugeSet(String name, GaugeSet gaugeSet) {
            Objects.requireNonNull(name, "Cannot register a GaugeSet with null name");
            Objects.requireNonNull(gaugeSet, "Cannot register a null GaugeSet for " + name);
            this.gaugeSets.compute(name, (id, prev) -> new PrometheusLabelledGaugeWrapper(name, gaugeSet, prev != null ? prev.inner : null));
        }

        public void unregisterGaugeSet(String name) {
            Objects.requireNonNull(name, "Cannot unregister GaugeSet with null name");
            PrometheusLabelledGaugeWrapper existing = (PrometheusLabelledGaugeWrapper)this.gaugeSets.remove(name);
            if (existing != null) {
                existing.unregister();
            }
        }

        public Summary getSummary(String name, MetricsContext.DetailLevel detailLevel) {
            if (detailLevel == MetricsContext.DetailLevel.BASIC) {
                return this.basicSummaries.computeIfAbsent(name, n -> {
                    if (this.summaries.containsKey(n)) {
                        throw new IllegalArgumentException("Already registered a non basic summary as " + n);
                    }
                    return new PrometheusSummary(name, detailLevel);
                });
            }
            return this.summaries.computeIfAbsent(name, n -> {
                if (this.basicSummaries.containsKey(n)) {
                    throw new IllegalArgumentException("Already registered a basic summary as " + n);
                }
                return new PrometheusSummary(name, detailLevel);
            });
        }

        public SummarySet getSummarySet(String name, MetricsContext.DetailLevel detailLevel) {
            if (detailLevel == MetricsContext.DetailLevel.BASIC) {
                return this.basicSummarySets.computeIfAbsent(name, n -> {
                    if (this.summarySets.containsKey(n)) {
                        throw new IllegalArgumentException("Already registered a non basic summary set as " + n);
                    }
                    return new PrometheusLabelledSummary(name, detailLevel);
                });
            }
            return this.summarySets.computeIfAbsent(name, n -> {
                if (this.basicSummarySets.containsKey(n)) {
                    throw new IllegalArgumentException("Already registered a basic summary set as " + n);
                }
                return new PrometheusLabelledSummary(name, detailLevel);
            });
        }
    }

    private static class PrometheusWorkerThreadFactory
    implements ThreadFactory {
        private static final AtomicInteger workerCounter = new AtomicInteger(1);

        private PrometheusWorkerThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable runnable) {
            String threadName = "PrometheusMetricsProviderWorker-" + workerCounter.getAndIncrement();
            Thread thread = new Thread(runnable, threadName);
            thread.setDaemon(true);
            return thread;
        }
    }

    private class PrometheusLabelledGaugeWrapper {
        private final GaugeSet gaugeSet;
        private final io.prometheus.client.Gauge inner;

        private PrometheusLabelledGaugeWrapper(String name, GaugeSet gaugeSet, io.prometheus.client.Gauge prev) {
            this.gaugeSet = gaugeSet;
            this.inner = prev != null ? prev : (io.prometheus.client.Gauge)((Gauge.Builder)io.prometheus.client.Gauge.build((String)name, (String)name).labelNames(LABELS)).register(PrometheusMetricsProvider.this.collectorRegistry);
        }

        private void sample() {
            this.gaugeSet.values().forEach((key, value) -> ((Gauge.Child)this.inner.labels(new String[]{key})).set(value != null ? value.doubleValue() : 0.0));
        }

        private void unregister() {
            PrometheusMetricsProvider.this.collectorRegistry.unregister((Collector)this.inner);
        }
    }

    private class PrometheusGaugeWrapper {
        private final io.prometheus.client.Gauge inner;
        private final Gauge gauge;
        private final String name;

        public PrometheusGaugeWrapper(String name, Gauge gauge, io.prometheus.client.Gauge prev) {
            this.name = name;
            this.gauge = gauge;
            this.inner = prev != null ? prev : (io.prometheus.client.Gauge)io.prometheus.client.Gauge.build((String)name, (String)name).register(PrometheusMetricsProvider.this.collectorRegistry);
        }

        private void sample() {
            Number value = this.gauge.get();
            this.inner.set(value != null ? value.doubleValue() : 0.0);
        }

        private void unregister() {
            PrometheusMetricsProvider.this.collectorRegistry.unregister((Collector)this.inner);
        }
    }

    private class PrometheusLabelledSummary
    implements SummarySet {
        private final io.prometheus.client.Summary inner;
        private final String name;

        public PrometheusLabelledSummary(String name, MetricsContext.DetailLevel level) {
            this.name = name;
            this.inner = level == MetricsContext.DetailLevel.ADVANCED ? (io.prometheus.client.Summary)((Summary.Builder)io.prometheus.client.Summary.build((String)name, (String)name).labelNames(LABELS)).quantile(0.5, 0.05).quantile(0.9, 0.01).quantile(0.99, 0.001).register(PrometheusMetricsProvider.this.collectorRegistry) : (io.prometheus.client.Summary)((Summary.Builder)io.prometheus.client.Summary.build((String)name, (String)name).labelNames(LABELS)).quantile(0.5, 0.05).register(PrometheusMetricsProvider.this.collectorRegistry);
        }

        public void add(String key, long value) {
            PrometheusMetricsProvider.this.reportMetrics(() -> this.observe(key, value));
        }

        private void observe(String key, long value) {
            try {
                ((Summary.Child)this.inner.labels(new String[]{key})).observe((double)value);
            }
            catch (IllegalArgumentException err) {
                LOG.error("invalid value {} for metric {} with key {}", new Object[]{value, this.name, key, err});
            }
        }
    }

    private class PrometheusSummary
    implements Summary {
        private final io.prometheus.client.Summary inner;
        private final String name;

        public PrometheusSummary(String name, MetricsContext.DetailLevel level) {
            this.name = name;
            this.inner = level == MetricsContext.DetailLevel.ADVANCED ? (io.prometheus.client.Summary)io.prometheus.client.Summary.build((String)name, (String)name).quantile(0.5, 0.05).quantile(0.9, 0.01).quantile(0.99, 0.001).register(PrometheusMetricsProvider.this.collectorRegistry) : (io.prometheus.client.Summary)io.prometheus.client.Summary.build((String)name, (String)name).quantile(0.5, 0.05).register(PrometheusMetricsProvider.this.collectorRegistry);
        }

        public void add(long delta) {
            PrometheusMetricsProvider.this.reportMetrics(() -> this.observe(delta));
        }

        private void observe(long delta) {
            try {
                this.inner.observe((double)delta);
            }
            catch (IllegalArgumentException err) {
                LOG.error("invalid delta {} for metric {}", new Object[]{delta, this.name, err});
            }
        }
    }

    private class PrometheusLabelledCounter
    implements CounterSet {
        private final String name;
        private final io.prometheus.client.Counter inner;

        public PrometheusLabelledCounter(String name) {
            this.name = name;
            this.inner = (io.prometheus.client.Counter)((Counter.Builder)io.prometheus.client.Counter.build((String)name, (String)name).labelNames(LABELS)).register(PrometheusMetricsProvider.this.collectorRegistry);
        }

        public void add(String key, long delta) {
            try {
                ((Counter.Child)this.inner.labels(new String[]{key})).inc((double)delta);
            }
            catch (IllegalArgumentException e) {
                LOG.error("invalid delta {} for metric {} with key {}", new Object[]{delta, this.name, key, e});
            }
        }
    }

    private class PrometheusCounter
    implements Counter {
        private final io.prometheus.client.Counter inner;
        private final String name;

        public PrometheusCounter(String name) {
            this.name = name;
            this.inner = (io.prometheus.client.Counter)io.prometheus.client.Counter.build((String)name, (String)name).register(PrometheusMetricsProvider.this.collectorRegistry);
        }

        public void add(long delta) {
            try {
                this.inner.inc((double)delta);
            }
            catch (IllegalArgumentException err) {
                LOG.error("invalid delta {} for metric {}", new Object[]{delta, this.name, err});
            }
        }

        public long get() {
            return (long)this.inner.get();
        }
    }
}

