/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.metrics.prometheus;

import io.prometheus.client.CollectorRegistry;
import java.util.Properties;
import org.apache.zookeeper.metrics.prometheus.PrometheusMetricsProvider;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ExportJvmInfoTest {
    @Test
    public void exportInfo() throws Exception {
        this.runTest(true);
    }

    @Test
    public void doNotExportInfo() throws Exception {
        this.runTest(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTest(boolean exportJvmInfo) throws Exception {
        CollectorRegistry.defaultRegistry.clear();
        PrometheusMetricsProvider provider = new PrometheusMetricsProvider();
        try {
            Properties configuration = new Properties();
            configuration.setProperty("httpPort", "0");
            configuration.setProperty("exportJvmInfo", "" + exportJvmInfo);
            provider.configure(configuration);
            provider.start();
            boolean[] found = new boolean[]{false};
            provider.dump((k, v) -> {
                found[0] = found[0] || k.contains("heap");
            });
            Assertions.assertEquals((Object)exportJvmInfo, (Object)found[0]);
        }
        finally {
            provider.stop();
        }
    }
}

