/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.ui.filter;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.io.FileUtils;
import org.apache.tez.ui.filter.CustomHeadersFilter;
import org.apache.tez.ui.filter.TestConfToolUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.xml.sax.SAXException;

public class TestCustomHeadersFilter {
    private ServletRequest servletRequest;
    private HttpServletResponse httpServletResponse;
    private FilterChain filterChain;
    private ArgumentCaptor<String> value = ArgumentCaptor.forClass(String.class);
    private ArgumentCaptor<String> key = ArgumentCaptor.forClass(String.class);

    public TestCustomHeadersFilter() {
        this.servletRequest = (ServletRequest)Mockito.mock(ServletRequest.class);
        this.httpServletResponse = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        this.filterChain = (FilterChain)Mockito.mock(FilterChain.class);
        ((HttpServletResponse)Mockito.doNothing().when((Object)this.httpServletResponse)).setHeader((String)this.key.capture(), (String)this.value.capture());
    }

    private void init(String tezSite, String testHeaders) throws IOException {
        TestConfToolUtil.copyFromResources(TestConfToolUtil.asPath("tez-files", "tezversion"), TestConfToolUtil.asPath(TestConfToolUtil.getMaprHome(), "tez", "tezversion"));
        String tezConfPath = TestConfToolUtil.getTezConfDirPath();
        TestConfToolUtil.mkdir(tezConfPath);
        TestConfToolUtil.copyFromResources(TestConfToolUtil.asPath("tez-files", tezSite), TestConfToolUtil.asPath(tezConfPath, "tez-site.xml"));
        TestConfToolUtil.copyFromResources(TestConfToolUtil.asPath("tez-files", testHeaders), TestConfToolUtil.asPath(tezConfPath, "test-headers.xml"));
    }

    private void initTezSiteWithAbsoluteHeadersPath(String tezSite, String headers) throws IOException, TransformerException, SAXException, ParserConfigurationException {
        this.init(tezSite, headers);
        String tezConfPath = TestConfToolUtil.getTezConfDirPath();
        String absoluteHeadersPath = TestConfToolUtil.asPath(tezConfPath, "test-headers.xml");
        TestConfToolUtil.addProperty(TestConfToolUtil.asPath(tezConfPath, "tez-site.xml"), "tez.ui.tomcat.response.headers.file", absoluteHeadersPath);
    }

    @Test
    public void testCustomFilterWithHeadersRelativePath() throws ServletException, IOException {
        this.init("tez-site01.xml", "test-headers.xml");
        CustomHeadersFilter filter = new CustomHeadersFilter();
        filter.init(null);
        filter.doFilter(this.servletRequest, (ServletResponse)this.httpServletResponse, this.filterChain);
        filter.destroy();
        List actualKeys = this.key.getAllValues();
        List actualValues = this.value.getAllValues();
        Assert.assertTrue((boolean)actualKeys.containsAll(Arrays.asList("X-Content-Type-Options", "X-XSS-Protection", "Strict-Transport-Security", "Content-Security-Policy")));
        Assert.assertTrue((boolean)actualValues.containsAll(Arrays.asList("nosniff", "1; mode=block", "max-age=31536000;includeSubDomains", "default-src https:")));
    }

    @Test
    public void testCustomFilterWithHeadersAbsolutePath() throws SAXException, TransformerException, ParserConfigurationException, IOException, ServletException {
        this.initTezSiteWithAbsoluteHeadersPath("tez-site02.xml", "test-headers.xml");
        CustomHeadersFilter filter = new CustomHeadersFilter();
        filter.init(null);
        filter.doFilter(this.servletRequest, (ServletResponse)this.httpServletResponse, this.filterChain);
        filter.destroy();
        List actualKeys = this.key.getAllValues();
        List actualValues = this.value.getAllValues();
        Assert.assertTrue((boolean)actualKeys.containsAll(Arrays.asList("X-Content-Type-Options", "X-XSS-Protection", "Strict-Transport-Security", "Content-Security-Policy")));
        Assert.assertTrue((boolean)actualValues.containsAll(Arrays.asList("nosniff", "1; mode=block", "max-age=31536000;includeSubDomains", "default-src https:")));
    }

    @Test
    public void testCustomFilterWithNoHeadersPath() throws ServletException, IOException {
        this.init("tez-site02.xml", "test-headers.xml");
        CustomHeadersFilter filter = new CustomHeadersFilter();
        filter.init(null);
        filter.doFilter(this.servletRequest, (ServletResponse)this.httpServletResponse, this.filterChain);
        filter.destroy();
        Assert.assertTrue((boolean)this.key.getAllValues().isEmpty());
        Assert.assertTrue((boolean)this.value.getAllValues().isEmpty());
    }

    @Test
    public void testCustomFilterWithDuplicateHeaders() throws IOException, ServletException {
        this.init("tez-site01.xml", "test-headers.xml");
        ((HttpServletResponse)Mockito.doReturn(Arrays.asList("X-Content-Type-Options", "X-XSS-Protection", "Strict-Transport-Security", "Content-Security-Policy")).when((Object)this.httpServletResponse)).getHeaderNames();
        ((HttpServletResponse)Mockito.doReturn((Object)"test-value1").when((Object)this.httpServletResponse)).getHeader("X-Content-Type-Options");
        ((HttpServletResponse)Mockito.doReturn((Object)"test-value2").when((Object)this.httpServletResponse)).getHeader("X-XSS-Protection");
        ((HttpServletResponse)Mockito.doReturn((Object)"test-value3").when((Object)this.httpServletResponse)).getHeader("Strict-Transport-Security");
        ((HttpServletResponse)Mockito.doReturn((Object)"test-value4").when((Object)this.httpServletResponse)).getHeader("Content-Security-Policy");
        CustomHeadersFilter filter = new CustomHeadersFilter();
        filter.init(null);
        filter.doFilter(this.servletRequest, (ServletResponse)this.httpServletResponse, this.filterChain);
        filter.destroy();
        List actualKeys = this.key.getAllValues();
        List actualValues = this.value.getAllValues();
        Assert.assertEquals((long)actualKeys.size(), (long)new HashSet(actualKeys).size());
        Assert.assertEquals((long)actualValues.size(), (long)new HashSet(actualValues).size());
        Assert.assertTrue((boolean)actualKeys.containsAll(Arrays.asList("X-Content-Type-Options", "X-XSS-Protection", "Strict-Transport-Security", "Content-Security-Policy")));
        Assert.assertTrue((boolean)actualValues.containsAll(Arrays.asList("nosniff", "1; mode=block", "max-age=31536000;includeSubDomains", "default-src https:")));
    }

    @After
    public void cleanUp() throws IOException {
        String mapRHome = System.getenv("MAPR_HOME");
        File mapRHomeDir = new File(mapRHome);
        if (mapRHomeDir.exists()) {
            FileUtils.deleteDirectory((File)mapRHomeDir);
        }
    }
}

