/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.ui.filter;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.FileUtils;
import org.apache.tez.ui.util.TezSiteReaderUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public final class TestConfToolUtil {
    public static final String I = File.separator;

    private TestConfToolUtil() {
    }

    public static String getPath(String fileName) {
        URL url = Thread.currentThread().getContextClassLoader().getResource(fileName);
        return url.getPath();
    }

    public static void copyFromResources(String pathInResources, String target) throws IOException {
        File src = new File(TestConfToolUtil.getPath(pathInResources));
        File tgt = new File(target);
        FileUtils.copyFile((File)src, (File)tgt);
    }

    public static void mkdir(String path) throws IOException {
        File file = new File(path);
        if (file.exists()) {
            FileUtils.deleteDirectory((File)file);
        }
        if (!file.mkdirs()) {
            throw new RuntimeException(String.format("Error creating test dir %s", path));
        }
    }

    public static String asPath(String ... dirs) {
        if (dirs == null || dirs.length == 0) {
            return "";
        }
        boolean first = true;
        StringBuilder sb = new StringBuilder();
        for (String dir : dirs) {
            if (first) {
                first = false;
                sb.append(dir);
                continue;
            }
            sb.append(I);
            sb.append(dir);
        }
        return sb.toString();
    }

    public static String getMaprHome() {
        return System.getenv("MAPR_HOME");
    }

    public static String getTezConfDirPath() throws IOException {
        return TestConfToolUtil.asPath(TestConfToolUtil.getTezHome(), "conf");
    }

    private static String getTezHome() throws IOException {
        String mapRHome = TestConfToolUtil.getMaprHome();
        String tezVersion = TestConfToolUtil.getTezVersion();
        return TestConfToolUtil.asPath(mapRHome, "tez", "tez-" + tezVersion);
    }

    public static String getTezVersion() throws IOException {
        byte[] encoded = Files.readAllBytes(Paths.get(TestConfToolUtil.getMaprHome() + "/tez/tezversion", new String[0]));
        return new String(encoded, Charset.defaultCharset()).replace("\n", "").replace("\r", "");
    }

    public static void addProperty(String pathToXml, String property, String value) throws IOException, SAXException, ParserConfigurationException, TransformerException {
        Document doc = TezSiteReaderUtil.readDocument((String)pathToXml);
        TestConfToolUtil.addProperty(doc, property, value);
        TestConfToolUtil.saveToFile(doc, pathToXml);
    }

    private static void addProperty(Document doc, String property, String value) {
        Element element = doc.createElement("property");
        TestConfToolUtil.addName(doc, element, property);
        TestConfToolUtil.addValue(doc, element, value);
        TezSiteReaderUtil.getConfigurationNode((Document)doc).appendChild(element);
    }

    private static void addName(Document doc, Node node, String property) {
        Element element = doc.createElement("name");
        element.appendChild(doc.createTextNode(property));
        node.appendChild(element);
    }

    private static void addValue(Document doc, Node property, String value) {
        Element name = doc.createElement("value");
        name.appendChild(doc.createTextNode(value));
        property.appendChild(name);
    }

    private static void saveToFile(Document doc, String filepath) throws TransformerException {
        TestConfToolUtil.removeEmptyText(doc.getDocumentElement());
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult(new File(filepath));
        transformer.transform(source, result);
    }

    private static void removeEmptyText(Node node) {
        Node child = node.getFirstChild();
        while (child != null) {
            Node sibling = child.getNextSibling();
            if (child.getNodeType() == 3) {
                if (child.getTextContent().trim().isEmpty()) {
                    node.removeChild(child);
                }
            } else {
                TestConfToolUtil.removeEmptyText(child);
            }
            child = sibling;
        }
    }
}

