/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.test;

import java.util.ArrayList;
import java.util.List;
import org.apache.tez.dag.app.AppContext;
import org.apache.tez.dag.history.DAGHistoryEvent;
import org.apache.tez.dag.history.recovery.RecoveryService;

public abstract class AMShutdownController {
    private List<DAGHistoryEvent> historyEvents = new ArrayList<DAGHistoryEvent>();
    protected AppContext appContext;
    protected RecoveryService recoveryService;

    public AMShutdownController(AppContext appContext, RecoveryService recoveryService) {
        this.appContext = appContext;
        this.recoveryService = recoveryService;
    }

    public void preHandleHistoryEvent(DAGHistoryEvent event) {
        this.historyEvents.add(event);
        if (this.shouldShutdownPreEvent(event, this.historyEvents)) {
            System.exit(1);
        }
    }

    public void postHandleHistoryEvent(DAGHistoryEvent event) {
        if (this.shouldShutdownPostEvent(event, this.historyEvents)) {
            System.exit(1);
        }
    }

    protected abstract boolean shouldShutdownPreEvent(DAGHistoryEvent var1, List<DAGHistoryEvent> var2);

    protected abstract boolean shouldShutdownPostEvent(DAGHistoryEvent var1, List<DAGHistoryEvent> var2);
}

