/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.common;

import java.io.DataInput;
import java.io.DataOutput;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;
import org.apache.tez.runtime.library.common.ConfigUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestConfigUtils {
    @Test
    public void getIntermediateOutputKeyComparator() {
        Configuration conf = new Configuration();
        String testKey = "test_flag_name";
        String testValue = "tez";
        conf.set(testKey, testValue);
        conf.set("tez.runtime.key.class", CustomKey.class.getName());
        WritableComparator rawComparator = (WritableComparator)ConfigUtils.getIntermediateOutputKeyComparator((Configuration)conf);
        CustomKey customKey = (CustomKey)rawComparator.newKey();
        Assert.assertEquals((Object)testValue, (Object)customKey.getConf().get(testKey));
    }

    @Test
    public void getIntermediateInputKeyComparator() {
        Configuration conf = new Configuration();
        String testKey = "test_flag_name";
        String testValue = "tez";
        conf.set(testKey, testValue);
        conf.set("tez.runtime.key.class", CustomKey.class.getName());
        WritableComparator rawComparator = (WritableComparator)ConfigUtils.getIntermediateInputKeyComparator((Configuration)conf);
        CustomKey customKey = (CustomKey)rawComparator.newKey();
        Assert.assertEquals((Object)testValue, (Object)customKey.getConf().get(testKey));
    }

    private static class CustomKey
    implements WritableComparable<CustomKey>,
    Configurable {
        private Configuration conf;

        private CustomKey() {
        }

        public int compareTo(CustomKey o) {
            return 0;
        }

        public void write(DataOutput out) {
        }

        public void readFields(DataInput in) {
        }

        public void setConf(Configuration conf) {
            this.conf = conf;
        }

        public Configuration getConf() {
            return this.conf;
        }
    }
}

