/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.cartesianproduct;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.tez.dag.api.EdgeManagerPluginDescriptor;
import org.apache.tez.dag.api.EdgeProperty;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.dag.api.VertexManagerPluginContext;
import org.apache.tez.runtime.library.cartesianproduct.CartesianProductConfig;
import org.apache.tez.runtime.library.cartesianproduct.CartesianProductEdgeManager;
import org.apache.tez.runtime.library.cartesianproduct.CartesianProductVertexManager;
import org.apache.tez.runtime.library.cartesianproduct.CartesianProductVertexManagerPartitioned;
import org.apache.tez.runtime.library.cartesianproduct.FairCartesianProductVertexManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class TestCartesianProductVertexManager {
    private CartesianProductVertexManager vertexManager;
    private VertexManagerPluginContext context;
    private String vertexName = "cp";
    private TezConfiguration conf;
    private CartesianProductConfig config;
    private Map<String, EdgeProperty> edgePropertyMap;
    private EdgeProperty cpEdge = EdgeProperty.create((EdgeManagerPluginDescriptor)EdgeManagerPluginDescriptor.create((String)CartesianProductEdgeManager.class.getName()), null, null, null, null);
    private EdgeProperty customEdge = EdgeProperty.create((EdgeManagerPluginDescriptor)EdgeManagerPluginDescriptor.create((String)"OTHER_EDGE"), null, null, null, null);
    private EdgeProperty broadcastEdge = EdgeProperty.create((EdgeProperty.DataMovementType)EdgeProperty.DataMovementType.BROADCAST, null, null, null, null);

    @Before
    public void setup() {
        this.context = (VertexManagerPluginContext)Mockito.mock(VertexManagerPluginContext.class);
        this.conf = new TezConfiguration();
        this.edgePropertyMap = new HashMap<String, EdgeProperty>();
        this.edgePropertyMap.put("v0", this.cpEdge);
        this.edgePropertyMap.put("v1", this.cpEdge);
        Mockito.when((Object)this.context.getVertexName()).thenReturn((Object)this.vertexName);
        Mockito.when((Object)this.context.getVertexNumTasks(this.vertexName)).thenReturn((Object)-1);
        Mockito.when((Object)this.context.getInputVertexEdgeProperties()).thenReturn(this.edgePropertyMap);
        Mockito.when((Object)this.context.getUserPayload()).thenAnswer((Answer)new Answer<UserPayload>(){

            public UserPayload answer(InvocationOnMock invocation) throws Throwable {
                return TestCartesianProductVertexManager.this.config.toUserPayload(TestCartesianProductVertexManager.this.conf);
            }
        });
        this.vertexManager = new CartesianProductVertexManager(this.context);
    }

    @Test(timeout=5000L)
    public void testRejectPredefinedParallelism() throws Exception {
        Mockito.when((Object)this.context.getVertexNumTasks(this.vertexName)).thenReturn((Object)10);
        try {
            this.vertexManager = new CartesianProductVertexManager(this.context);
            Assert.assertTrue((boolean)false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test(timeout=5000L)
    public void testChooseRealVertexManager() throws Exception {
        this.config = new CartesianProductConfig(new int[]{2, 3}, new String[]{"v0", "v1"}, null);
        this.vertexManager.initialize();
        Assert.assertTrue((boolean)(this.vertexManager.getVertexManagerReal() instanceof CartesianProductVertexManagerPartitioned));
        ArrayList<String> sourceVertices = new ArrayList<String>();
        sourceVertices.add("v0");
        sourceVertices.add("v1");
        this.config = new CartesianProductConfig(sourceVertices);
        this.vertexManager.initialize();
        Assert.assertTrue((boolean)(this.vertexManager.getVertexManagerReal() instanceof FairCartesianProductVertexManager));
    }

    @Test(timeout=5000L)
    public void testCheckDAGConfigConsistent() throws Exception {
        this.edgePropertyMap.put("v2", this.broadcastEdge);
        this.config = new CartesianProductConfig(new int[]{2, 3}, new String[]{"v0", "v1"}, null);
        this.vertexManager.initialize();
        this.edgePropertyMap.put("v2", this.cpEdge);
        try {
            this.vertexManager.initialize();
            Assert.assertTrue((boolean)false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.edgePropertyMap.put("v2", this.broadcastEdge);
        this.config = new CartesianProductConfig(new int[]{2, 3, 4}, new String[]{"v0", "v1", "v2"}, null);
        try {
            this.vertexManager.initialize();
            Assert.assertTrue((boolean)false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.edgePropertyMap.put("v2", this.customEdge);
        try {
            this.vertexManager.initialize();
            Assert.assertTrue((boolean)false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.edgePropertyMap.remove("v2");
        try {
            this.vertexManager.initialize();
            Assert.assertTrue((boolean)false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test(timeout=5000L)
    public void testCheckDAGConfigConsistentWithVertexGroup() throws Exception {
        this.edgePropertyMap.put("v2", this.cpEdge);
        this.config = new CartesianProductConfig(new int[]{2, 3}, new String[]{"v0", "g0"}, null);
        HashMap<String, List<String>> vertexGroups = new HashMap<String, List<String>>();
        vertexGroups.put("g0", Arrays.asList("v1", "v2"));
        Mockito.when((Object)this.context.getInputVertexGroups()).thenReturn(vertexGroups);
        this.vertexManager.initialize();
        this.edgePropertyMap.put("v2", this.broadcastEdge);
        try {
            this.vertexManager.initialize();
            Assert.assertTrue((boolean)false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test(timeout=5000L)
    public void testOtherEdgeType() throws Exception {
        this.edgePropertyMap.put("v2", this.customEdge);
        this.config = new CartesianProductConfig(new int[]{2, 3}, new String[]{"v0", "v1"}, null);
        try {
            this.vertexManager.initialize();
            Assert.assertTrue((boolean)false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (EdgeProperty.DataMovementType type : EdgeProperty.DataMovementType.values()) {
            if (type == EdgeProperty.DataMovementType.CUSTOM) continue;
            this.edgePropertyMap.put("v2", EdgeProperty.create((EdgeProperty.DataMovementType)type, null, null, null, null));
            try {
                this.vertexManager.initialize();
                Assert.assertTrue((type == EdgeProperty.DataMovementType.BROADCAST ? 1 : 0) != 0);
            }
            catch (Exception e) {
                Assert.assertTrue((type != EdgeProperty.DataMovementType.BROADCAST ? 1 : 0) != 0);
            }
        }
    }
}

