/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.library.vertexmanager;

import com.google.protobuf.ByteString;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.tez.common.ReflectionUtils;
import org.apache.tez.common.TezCommonUtils;
import org.apache.tez.common.TezUtils;
import org.apache.tez.dag.api.EdgeManagerPlugin;
import org.apache.tez.dag.api.EdgeManagerPluginContext;
import org.apache.tez.dag.api.EdgeManagerPluginDescriptor;
import org.apache.tez.dag.api.EdgeProperty;
import org.apache.tez.dag.api.InputDescriptor;
import org.apache.tez.dag.api.OutputDescriptor;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.dag.api.VertexLocationHint;
import org.apache.tez.dag.api.VertexManagerPluginContext;
import org.apache.tez.dag.library.vertexmanager.FairShuffleVertexManager;
import org.apache.tez.dag.library.vertexmanager.ShuffleVertexManager;
import org.apache.tez.dag.library.vertexmanager.ShuffleVertexManagerBase;
import org.apache.tez.dag.records.TaskAttemptIdentifierImpl;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.dag.records.TezTaskID;
import org.apache.tez.dag.records.TezVertexID;
import org.apache.tez.runtime.api.TaskAttemptIdentifier;
import org.apache.tez.runtime.api.TaskIdentifier;
import org.apache.tez.runtime.api.VertexIdentifier;
import org.apache.tez.runtime.api.events.VertexManagerEvent;
import org.apache.tez.runtime.library.common.shuffle.ShuffleUtils;
import org.apache.tez.runtime.library.shuffle.impl.ShuffleUserPayloads;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.roaringbitmap.RoaringBitmap;

public class TestShuffleVertexManagerUtils {
    static long MB = 0x100000L;
    TezVertexID vertexId = TezVertexID.fromString((String)"vertex_1436907267600_195589_1_00");
    int taskId = 0;

    VertexManagerPluginContext createVertexManagerContext(String mockSrcVertexId1, int numTasksSrcVertexId1, String mockSrcVertexId2, int numTasksSrcVertexId2, String mockSrcVertexId3, int numTasksSrcVertexId3, String mockManagedVertexId, int numTasksmockManagedVertexId, List<Integer> scheduledTasks, Map<String, EdgeManagerPlugin> newEdgeManagers) {
        HashMap<String, EdgeProperty> mockInputVertices = new HashMap<String, EdgeProperty>();
        EdgeProperty eProp1 = EdgeProperty.create((EdgeProperty.DataMovementType)EdgeProperty.DataMovementType.SCATTER_GATHER, (EdgeProperty.DataSourceType)EdgeProperty.DataSourceType.PERSISTED, (EdgeProperty.SchedulingType)EdgeProperty.SchedulingType.SEQUENTIAL, (OutputDescriptor)OutputDescriptor.create((String)"out"), (InputDescriptor)InputDescriptor.create((String)"in"));
        EdgeProperty eProp2 = EdgeProperty.create((EdgeProperty.DataMovementType)EdgeProperty.DataMovementType.SCATTER_GATHER, (EdgeProperty.DataSourceType)EdgeProperty.DataSourceType.PERSISTED, (EdgeProperty.SchedulingType)EdgeProperty.SchedulingType.SEQUENTIAL, (OutputDescriptor)OutputDescriptor.create((String)"out"), (InputDescriptor)InputDescriptor.create((String)"in"));
        EdgeProperty eProp3 = EdgeProperty.create((EdgeProperty.DataMovementType)EdgeProperty.DataMovementType.BROADCAST, (EdgeProperty.DataSourceType)EdgeProperty.DataSourceType.PERSISTED, (EdgeProperty.SchedulingType)EdgeProperty.SchedulingType.SEQUENTIAL, (OutputDescriptor)OutputDescriptor.create((String)"out"), (InputDescriptor)InputDescriptor.create((String)"in"));
        mockInputVertices.put(mockSrcVertexId1, eProp1);
        mockInputVertices.put(mockSrcVertexId2, eProp2);
        mockInputVertices.put(mockSrcVertexId3, eProp3);
        VertexManagerPluginContext mockContext = (VertexManagerPluginContext)Mockito.mock(VertexManagerPluginContext.class);
        Mockito.when((Object)mockContext.getInputVertexEdgeProperties()).thenReturn(mockInputVertices);
        Mockito.when((Object)mockContext.getVertexName()).thenReturn((Object)mockManagedVertexId);
        Mockito.when((Object)mockContext.getVertexNumTasks(mockSrcVertexId1)).thenReturn((Object)numTasksSrcVertexId1);
        Mockito.when((Object)mockContext.getVertexNumTasks(mockSrcVertexId2)).thenReturn((Object)numTasksSrcVertexId2);
        Mockito.when((Object)mockContext.getVertexNumTasks(mockSrcVertexId3)).thenReturn((Object)numTasksSrcVertexId3);
        Mockito.when((Object)mockContext.getVertexNumTasks(mockManagedVertexId)).thenReturn((Object)numTasksmockManagedVertexId);
        ((VertexManagerPluginContext)Mockito.doAnswer((Answer)new ScheduledTasksAnswer(scheduledTasks)).when((Object)mockContext)).scheduleTasks(Mockito.anyList());
        ((VertexManagerPluginContext)Mockito.doAnswer((Answer)new reconfigVertexAnswer(mockContext, mockManagedVertexId, newEdgeManagers)).when((Object)mockContext)).reconfigureVertex(Mockito.anyInt(), (VertexLocationHint)Mockito.any(), Mockito.anyMap());
        return mockContext;
    }

    VertexManagerEvent getVertexManagerEvent(long[] sizes, long inputSize, String vertexName) throws IOException {
        return this.getVertexManagerEvent(sizes, inputSize, vertexName, false);
    }

    VertexManagerEvent getVertexManagerEvent(long[] partitionSizes, long uncompressedTotalSize, String vertexName, boolean reportDetailedStats) throws IOException {
        ByteBuffer payload;
        long totalSize = 0L;
        totalSize = partitionSizes != null ? this.estimatedUncompressedSum(partitionSizes) : uncompressedTotalSize;
        if (partitionSizes != null) {
            RoaringBitmap partitionStats = ShuffleUtils.getPartitionStatsForPhysicalOutput((long[])partitionSizes);
            DataOutputBuffer dout = new DataOutputBuffer();
            partitionStats.serialize((DataOutput)dout);
            ByteString partitionStatsBytes = TezCommonUtils.compressByteArrayToByteString((byte[])dout.getData());
            payload = reportDetailedStats ? ShuffleUserPayloads.VertexManagerEventPayloadProto.newBuilder().setOutputSize(totalSize).setDetailedPartitionStats(ShuffleUtils.getDetailedPartitionStatsForPhysicalOutput((long[])partitionSizes)).build().toByteString().asReadOnlyByteBuffer() : ShuffleUserPayloads.VertexManagerEventPayloadProto.newBuilder().setOutputSize(totalSize).setPartitionStats(partitionStatsBytes).build().toByteString().asReadOnlyByteBuffer();
        } else {
            payload = ShuffleUserPayloads.VertexManagerEventPayloadProto.newBuilder().setOutputSize(totalSize).build().toByteString().asReadOnlyByteBuffer();
        }
        TaskAttemptIdentifierImpl taId = new TaskAttemptIdentifierImpl("dag", vertexName, TezTaskAttemptID.getInstance((TezTaskID)TezTaskID.getInstance((TezVertexID)this.vertexId, (int)this.taskId++), (int)0));
        VertexManagerEvent vmEvent = VertexManagerEvent.create((String)vertexName, (ByteBuffer)payload);
        vmEvent.setProducerAttemptIdentifier((TaskAttemptIdentifier)taId);
        return vmEvent;
    }

    long estimatedUncompressedSum(long[] partitionStats) {
        long sum = 0L;
        for (long partition : partitionStats) {
            sum += partition;
        }
        return sum * 3L;
    }

    public static TaskAttemptIdentifier createTaskAttemptIdentifier(String vName, int tId) {
        VertexIdentifier mockVertex = (VertexIdentifier)Mockito.mock(VertexIdentifier.class);
        Mockito.when((Object)mockVertex.getName()).thenReturn((Object)vName);
        TaskIdentifier mockTask = (TaskIdentifier)Mockito.mock(TaskIdentifier.class);
        Mockito.when((Object)mockTask.getIdentifier()).thenReturn((Object)tId);
        Mockito.when((Object)mockTask.getVertexIdentifier()).thenReturn((Object)mockVertex);
        TaskAttemptIdentifier mockAttempt = (TaskAttemptIdentifier)Mockito.mock(TaskAttemptIdentifier.class);
        Mockito.when((Object)mockAttempt.getIdentifier()).thenReturn((Object)0);
        Mockito.when((Object)mockAttempt.getTaskIdentifier()).thenReturn((Object)mockTask);
        return mockAttempt;
    }

    public static ShuffleVertexManagerBase createManager(Class<? extends ShuffleVertexManagerBase> shuffleVertexManagerClass, Configuration conf, VertexManagerPluginContext context, Boolean enableAutoParallelism, Long desiredTaskInputSize, Float min, Float max) {
        if (shuffleVertexManagerClass.equals(ShuffleVertexManager.class)) {
            return TestShuffleVertexManagerUtils.createShuffleVertexManager(conf, context, enableAutoParallelism, desiredTaskInputSize, min, max);
        }
        if (shuffleVertexManagerClass.equals(FairShuffleVertexManager.class)) {
            FairShuffleVertexManager.FairRoutingType fairRoutingType = null;
            if (enableAutoParallelism != null) {
                fairRoutingType = enableAutoParallelism != false ? FairShuffleVertexManager.FairRoutingType.REDUCE_PARALLELISM : FairShuffleVertexManager.FairRoutingType.NONE;
            }
            return TestShuffleVertexManagerUtils.createFairShuffleVertexManager(conf, context, fairRoutingType, desiredTaskInputSize, min, max);
        }
        return null;
    }

    static ShuffleVertexManager createShuffleVertexManager(Configuration conf, VertexManagerPluginContext context, Boolean enableAutoParallelism, Long desiredTaskInputSize, Float min, Float max) {
        UserPayload payload;
        if (min != null) {
            conf.setFloat("tez.shuffle-vertex-manager.min-src-fraction", min.floatValue());
        } else {
            conf.unset("tez.shuffle-vertex-manager.min-src-fraction");
        }
        if (max != null) {
            conf.setFloat("tez.shuffle-vertex-manager.max-src-fraction", max.floatValue());
        } else {
            conf.unset("tez.shuffle-vertex-manager.max-src-fraction");
        }
        if (enableAutoParallelism != null) {
            conf.setBoolean("tez.shuffle-vertex-manager.enable.auto-parallel", enableAutoParallelism.booleanValue());
        }
        if (desiredTaskInputSize != null) {
            conf.setLong("tez.shuffle-vertex-manager.desired-task-input-size", desiredTaskInputSize.longValue());
        }
        try {
            payload = TezUtils.createUserPayloadFromConf((Configuration)conf);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Mockito.when((Object)context.getUserPayload()).thenReturn((Object)payload);
        ShuffleVertexManager manager = new ShuffleVertexManager(context);
        manager.initialize();
        return manager;
    }

    static FairShuffleVertexManager createFairShuffleVertexManager(Configuration conf, VertexManagerPluginContext context, FairShuffleVertexManager.FairRoutingType fairRoutingType, Long desiredTaskInputSize, Float min, Float max) {
        FairShuffleVertexManager.FairShuffleVertexManagerConfigBuilder builder = FairShuffleVertexManager.createConfigBuilder((Configuration)conf);
        if (min != null) {
            builder.setSlowStartMinSrcCompletionFraction(min.floatValue());
        } else if (conf != null) {
            conf.unset("tez.fair-shuffle-vertex-manager.min-src-fraction");
        }
        if (max != null) {
            builder.setSlowStartMaxSrcCompletionFraction(max.floatValue());
        } else if (conf != null) {
            conf.unset("tez.fair-shuffle-vertex-manager.max-src-fraction");
        }
        if (fairRoutingType != null) {
            builder.setAutoParallelism(fairRoutingType);
        }
        if (desiredTaskInputSize != null) {
            builder.setDesiredTaskInputSize(desiredTaskInputSize.longValue());
        }
        UserPayload payload = builder.build().getUserPayload();
        Mockito.when((Object)context.getUserPayload()).thenReturn((Object)payload);
        FairShuffleVertexManager manager = new FairShuffleVertexManager(context);
        manager.initialize();
        return manager;
    }

    protected static class reconfigVertexAnswer
    implements Answer<Object> {
        private VertexManagerPluginContext mockContext;
        private String mockManagedVertexId;
        private Map<String, EdgeManagerPlugin> newEdgeManagers;

        public reconfigVertexAnswer(VertexManagerPluginContext mockContext, String mockManagedVertexId, Map<String, EdgeManagerPlugin> newEdgeManagers) {
            this.mockContext = mockContext;
            this.mockManagedVertexId = mockManagedVertexId;
            this.newEdgeManagers = newEdgeManagers;
        }

        public Object answer(InvocationOnMock invocation) throws Exception {
            final int numTasks = (Integer)invocation.getArguments()[0];
            Mockito.when((Object)this.mockContext.getVertexNumTasks(this.mockManagedVertexId)).thenReturn((Object)numTasks);
            if (this.newEdgeManagers != null) {
                this.newEdgeManagers.clear();
            }
            for (Map.Entry entry : ((Map)invocation.getArguments()[2]).entrySet()) {
                EdgeManagerPluginDescriptor pluginDesc = ((EdgeProperty)entry.getValue()).getEdgeManagerDescriptor();
                final UserPayload userPayload = pluginDesc.getUserPayload();
                EdgeManagerPluginContext emContext = new EdgeManagerPluginContext(){

                    public UserPayload getUserPayload() {
                        return userPayload == null ? null : userPayload;
                    }

                    public String getSourceVertexName() {
                        return null;
                    }

                    public String getDestinationVertexName() {
                        return null;
                    }

                    public int getSourceVertexNumTasks() {
                        return 2;
                    }

                    public int getDestinationVertexNumTasks() {
                        return numTasks;
                    }

                    public String getVertexGroupName() {
                        return null;
                    }
                };
                if (this.newEdgeManagers == null) continue;
                EdgeManagerPlugin edgeManager = (EdgeManagerPlugin)ReflectionUtils.createClazzInstance((String)pluginDesc.getClassName(), (Class[])new Class[]{EdgeManagerPluginContext.class}, (Object[])new Object[]{emContext});
                edgeManager.initialize();
                this.newEdgeManagers.put((String)entry.getKey(), edgeManager);
            }
            return null;
        }
    }

    protected static class ScheduledTasksAnswer
    implements Answer<Object> {
        private List<Integer> scheduledTasks;

        public ScheduledTasksAnswer(List<Integer> scheduledTasks) {
            this.scheduledTasks = scheduledTasks;
        }

        public Object answer(InvocationOnMock invocation) throws IOException {
            Object[] args = invocation.getArguments();
            this.scheduledTasks.clear();
            List tasks = (List)args[0];
            for (VertexManagerPluginContext.ScheduleTaskRequest task : tasks) {
                this.scheduledTasks.add(task.getTaskIndex());
            }
            return null;
        }
    }
}

