/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.output;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.tez.common.TezUtils;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.runtime.api.MemoryUpdateCallback;
import org.apache.tez.runtime.api.OutputContext;
import org.apache.tez.runtime.api.OutputStatisticsReporter;
import org.apache.tez.runtime.api.impl.ExecutionContextImpl;
import org.apache.tez.runtime.library.common.MemoryUpdateCallbackHandler;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

class OutputTestHelpers {
    OutputTestHelpers() {
    }

    static OutputContext createOutputContext() throws IOException {
        OutputContext outputContext = (OutputContext)Mockito.mock(OutputContext.class);
        TezConfiguration conf = new TezConfiguration();
        UserPayload payLoad = TezUtils.createUserPayloadFromConf((Configuration)conf);
        String[] workingDirs = new String[]{"workDir1"};
        OutputStatisticsReporter statsReporter = (OutputStatisticsReporter)Mockito.mock(OutputStatisticsReporter.class);
        TezCounters counters = new TezCounters();
        ((OutputContext)Mockito.doReturn((Object)"destinationVertex").when((Object)outputContext)).getDestinationVertexName();
        ((OutputContext)Mockito.doReturn((Object)payLoad).when((Object)outputContext)).getUserPayload();
        ((OutputContext)Mockito.doReturn((Object)workingDirs).when((Object)outputContext)).getWorkDirs();
        ((OutputContext)Mockito.doReturn((Object)0xC800000L).when((Object)outputContext)).getTotalMemoryAvailableToTask();
        ((OutputContext)Mockito.doReturn((Object)counters).when((Object)outputContext)).getCounters();
        ((OutputContext)Mockito.doReturn((Object)statsReporter).when((Object)outputContext)).getStatisticsReporter();
        ((OutputContext)Mockito.doReturn((Object)new Configuration(false)).when((Object)outputContext)).getContainerConfiguration();
        return outputContext;
    }

    static OutputContext createOutputContext(Configuration conf, Configuration userPayloadConf, Path workingDir) throws IOException {
        OutputContext ctx = (OutputContext)Mockito.mock(OutputContext.class);
        ((OutputContext)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                long requestedSize = (Long)invocation.getArguments()[0];
                MemoryUpdateCallbackHandler callback = (MemoryUpdateCallbackHandler)invocation.getArguments()[1];
                callback.memoryAssigned(requestedSize);
                return null;
            }
        }).when((Object)ctx)).requestInitialMemory(Mockito.anyLong(), (MemoryUpdateCallback)Mockito.any());
        ((OutputContext)Mockito.doReturn((Object)conf).when((Object)ctx)).getContainerConfiguration();
        ((OutputContext)Mockito.doReturn((Object)TezUtils.createUserPayloadFromConf((Configuration)userPayloadConf)).when((Object)ctx)).getUserPayload();
        ((OutputContext)Mockito.doReturn((Object)"taskVertex").when((Object)ctx)).getTaskVertexName();
        ((OutputContext)Mockito.doReturn((Object)"destinationVertex").when((Object)ctx)).getDestinationVertexName();
        ((OutputContext)Mockito.doReturn((Object)"UUID").when((Object)ctx)).getUniqueIdentifier();
        ((OutputContext)Mockito.doReturn((Object)new String[]{workingDir.toString()}).when((Object)ctx)).getWorkDirs();
        ((OutputContext)Mockito.doReturn((Object)0xC800000L).when((Object)ctx)).getTotalMemoryAvailableToTask();
        ((OutputContext)Mockito.doReturn((Object)new TezCounters()).when((Object)ctx)).getCounters();
        OutputStatisticsReporter statsReporter = (OutputStatisticsReporter)Mockito.mock(OutputStatisticsReporter.class);
        ((OutputContext)Mockito.doReturn((Object)statsReporter).when((Object)ctx)).getStatisticsReporter();
        ((OutputContext)Mockito.doReturn((Object)new ExecutionContextImpl("localhost")).when((Object)ctx)).getExecutionContext();
        return ctx;
    }
}

