/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.cartesianproduct;

import com.google.common.primitives.Ints;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.tez.dag.api.EdgeManagerPluginContext;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.runtime.library.cartesianproduct.CartesianProductEdgeManager;
import org.apache.tez.runtime.library.cartesianproduct.CartesianProductEdgeManagerPartitioned;
import org.apache.tez.runtime.library.cartesianproduct.CartesianProductUserPayload;
import org.apache.tez.runtime.library.cartesianproduct.FairCartesianProductEdgeManager;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestCartesianProductEdgeManager {
    @Test(timeout=5000L)
    public void testInitialize() throws Exception {
        EdgeManagerPluginContext context = (EdgeManagerPluginContext)Mockito.mock(EdgeManagerPluginContext.class);
        Mockito.when((Object)context.getSourceVertexName()).thenReturn((Object)"v0");
        CartesianProductEdgeManager edgeManager = new CartesianProductEdgeManager(context);
        CartesianProductUserPayload.CartesianProductConfigProto.Builder builder = CartesianProductUserPayload.CartesianProductConfigProto.newBuilder();
        builder.setIsPartitioned(true).addAllSources(Arrays.asList("v0", "v1")).addAllNumPartitions((Iterable)Ints.asList((int[])new int[]{2, 3})).setMaxParallelism(100).setMinOpsPerWorker(1L);
        UserPayload payload = UserPayload.create((ByteBuffer)ByteBuffer.wrap(builder.build().toByteArray()));
        Mockito.when((Object)context.getUserPayload()).thenReturn((Object)payload);
        edgeManager.initialize();
        Assert.assertTrue((boolean)(edgeManager.getEdgeManagerReal() instanceof CartesianProductEdgeManagerPartitioned));
        builder.clear();
        builder.setIsPartitioned(false).addAllSources(Arrays.asList("v0", "v1")).addAllNumChunks((Iterable)Ints.asList((int[])new int[]{2, 3})).setMaxParallelism(100).setMinOpsPerWorker(1L);
        payload = UserPayload.create((ByteBuffer)ByteBuffer.wrap(builder.build().toByteArray()));
        Mockito.when((Object)context.getUserPayload()).thenReturn((Object)payload);
        Mockito.when((Object)context.getSourceVertexNumTasks()).thenReturn((Object)2);
        edgeManager.initialize();
        Assert.assertTrue((boolean)(edgeManager.getEdgeManagerReal() instanceof FairCartesianProductEdgeManager));
    }
}

