/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.api.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.tez.dag.api.InputDescriptor;
import org.apache.tez.dag.api.OutputDescriptor;
import org.apache.tez.dag.api.ProcessorDescriptor;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.dag.records.TezDAGID;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.dag.records.TezTaskID;
import org.apache.tez.dag.records.TezVertexID;
import org.apache.tez.runtime.api.impl.InputSpec;
import org.apache.tez.runtime.api.impl.OutputSpec;
import org.apache.tez.runtime.api.impl.TaskSpec;
import org.junit.Assert;
import org.junit.Test;

public class TestTaskSpec {
    @Test(timeout=5000L)
    public void testSerDe() throws IOException {
        ByteBuffer payload = null;
        ProcessorDescriptor procDesc = (ProcessorDescriptor)((ProcessorDescriptor)ProcessorDescriptor.create((String)"proc").setUserPayload(UserPayload.create(payload))).setHistoryText("historyText");
        ArrayList<InputSpec> inputSpecs = new ArrayList<InputSpec>();
        InputSpec inputSpec = new InputSpec("src1", InputDescriptor.create((String)"inputClass"), 10);
        inputSpecs.add(inputSpec);
        ArrayList<OutputSpec> outputSpecs = new ArrayList<OutputSpec>();
        OutputSpec outputSpec = new OutputSpec("dest1", OutputDescriptor.create((String)"outputClass"), 999);
        outputSpecs.add(outputSpec);
        List groupInputSpecs = null;
        Configuration taskConf = new Configuration(false);
        taskConf.set("foo", "bar");
        TezTaskAttemptID taId = TezTaskAttemptID.getInstance((TezTaskID)TezTaskID.getInstance((TezVertexID)TezVertexID.getInstance((TezDAGID)TezDAGID.getInstance((String)"1234", (int)1, (int)1), (int)1), (int)1), (int)1);
        TaskSpec taskSpec = new TaskSpec(taId, "dagName", "vName", -1, procDesc, inputSpecs, outputSpecs, groupInputSpecs, taskConf);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(bos);
        taskSpec.write((DataOutput)out);
        TaskSpec deSerTaskSpec = new TaskSpec();
        ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
        DataInputStream in = new DataInputStream(bis);
        deSerTaskSpec.readFields((DataInput)in);
        Assert.assertEquals((Object)taskSpec.getDAGName(), (Object)deSerTaskSpec.getDAGName());
        Assert.assertEquals((Object)taskSpec.getVertexName(), (Object)deSerTaskSpec.getVertexName());
        Assert.assertEquals((long)taskSpec.getVertexParallelism(), (long)deSerTaskSpec.getVertexParallelism());
        Assert.assertEquals((long)taskSpec.getInputs().size(), (long)deSerTaskSpec.getInputs().size());
        Assert.assertEquals((long)taskSpec.getOutputs().size(), (long)deSerTaskSpec.getOutputs().size());
        Assert.assertNull((Object)deSerTaskSpec.getGroupInputs());
        Assert.assertEquals((Object)((InputSpec)taskSpec.getInputs().get(0)).getSourceVertexName(), (Object)((InputSpec)deSerTaskSpec.getInputs().get(0)).getSourceVertexName());
        Assert.assertEquals((Object)((OutputSpec)taskSpec.getOutputs().get(0)).getDestinationVertexName(), (Object)((OutputSpec)deSerTaskSpec.getOutputs().get(0)).getDestinationVertexName());
        Assert.assertEquals((Object)taskConf.get("foo"), (Object)deSerTaskSpec.getTaskConf().get("foo"));
    }
}

