/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.common.objectregistry;

import org.apache.tez.runtime.api.ObjectRegistry;
import org.apache.tez.runtime.common.objectregistry.ObjectRegistryImpl;
import org.junit.Assert;
import org.junit.Test;

public class TestObjectRegistry {
    private void testCRUD(ObjectRegistry objectRegistry) {
        Assert.assertNotNull((Object)objectRegistry);
        Assert.assertNull((Object)objectRegistry.get("foo"));
        Assert.assertFalse((boolean)objectRegistry.delete("foo"));
        Integer one = new Integer(1);
        Integer two_1 = new Integer(2);
        Integer two_2 = new Integer(3);
        Assert.assertNull((Object)objectRegistry.cacheForDAG("one", (Object)one));
        Assert.assertEquals((Object)one, (Object)objectRegistry.get("one"));
        Assert.assertNull((Object)objectRegistry.cacheForDAG("two", (Object)two_1));
        Assert.assertNotNull((Object)objectRegistry.cacheForSession("two", (Object)two_2));
        Assert.assertNotEquals((Object)two_1, (Object)objectRegistry.get("two"));
        Assert.assertEquals((Object)two_2, (Object)objectRegistry.get("two"));
        Assert.assertTrue((boolean)objectRegistry.delete("one"));
        Assert.assertFalse((boolean)objectRegistry.delete("one"));
    }

    @Test(timeout=5000L)
    public void testBasicCRUD() {
        ObjectRegistryImpl objectRegistry = new ObjectRegistryImpl();
        this.testCRUD((ObjectRegistry)objectRegistry);
    }

    @Test(timeout=5000L)
    public void testClearCache() {
        ObjectRegistryImpl objectRegistry = new ObjectRegistryImpl();
        this.testCRUD((ObjectRegistry)objectRegistry);
        String one = "one";
        String two = "two";
        objectRegistry.cacheForVertex(one, (Object)one);
        objectRegistry.cacheForDAG(two, (Object)two);
        objectRegistry.clearCache(ObjectRegistryImpl.ObjectLifeCycle.VERTEX);
        Assert.assertNull((Object)objectRegistry.get(one));
        Assert.assertNotNull((Object)objectRegistry.get(two));
        objectRegistry.cacheForVertex(one, (Object)one);
        objectRegistry.clearCache(ObjectRegistryImpl.ObjectLifeCycle.DAG);
        Assert.assertNotNull((Object)objectRegistry.get(one));
        Assert.assertNull((Object)objectRegistry.get(two));
    }
}

