/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.mapreduce.output;

import java.io.File;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileOutputCommitter;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.tez.common.TezUtils;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.dag.api.DataSinkDescriptor;
import org.apache.tez.dag.api.OutputCommitterDescriptor;
import org.apache.tez.dag.api.OutputDescriptor;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.mapreduce.committer.MROutputCommitter;
import org.apache.tez.mapreduce.output.MROutputLegacy;
import org.apache.tez.runtime.api.OutputContext;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestMROutputLegacy {
    private static final File TEST_DIR = new File(System.getProperty("test.build.data"), TestMROutputLegacy.class.getName()).getAbsoluteFile();

    @Test(timeout=5000L)
    public void testOldAPI_MR() throws Exception {
        String outputPath = TEST_DIR.getAbsolutePath();
        JobConf conf = new JobConf();
        conf.set("fs.defaultFS", "file:///");
        conf.setOutputKeyClass(NullWritable.class);
        conf.setOutputValueClass(Text.class);
        conf.setOutputFormat(org.apache.hadoop.mapred.SequenceFileOutputFormat.class);
        org.apache.hadoop.mapred.SequenceFileOutputFormat.setOutputPath((JobConf)conf, (Path)new Path(outputPath));
        conf.setBoolean("tez.mapreduce.is_map_processor", false);
        UserPayload vertexPayload = TezUtils.createUserPayloadFromConf((Configuration)conf);
        OutputDescriptor od = (OutputDescriptor)OutputDescriptor.create((String)MROutputLegacy.class.getName()).setUserPayload(vertexPayload);
        DataSinkDescriptor sink = DataSinkDescriptor.create((OutputDescriptor)od, (OutputCommitterDescriptor)OutputCommitterDescriptor.create((String)MROutputCommitter.class.getName()), null);
        OutputContext outputContext = this.createMockOutputContext(sink.getOutputDescriptor().getUserPayload());
        MROutputLegacy output = new MROutputLegacy(outputContext, 2);
        output.initialize();
        Assert.assertEquals((Object)false, (Object)output.useNewApi);
        Assert.assertEquals(org.apache.hadoop.mapred.SequenceFileOutputFormat.class, output.oldOutputFormat.getClass());
        Assert.assertNull((Object)output.newOutputFormat);
        Assert.assertEquals(NullWritable.class, (Object)output.oldApiTaskAttemptContext.getOutputKeyClass());
        Assert.assertEquals(Text.class, (Object)output.oldApiTaskAttemptContext.getOutputValueClass());
        Assert.assertNull((Object)output.newApiTaskAttemptContext);
        Assert.assertNotNull((Object)output.oldRecordWriter);
        Assert.assertNull((Object)output.newRecordWriter);
        Assert.assertEquals(FileOutputCommitter.class, output.committer.getClass());
    }

    @Test(timeout=5000L)
    public void testNewAPI_MR() throws Exception {
        String outputPath = TEST_DIR.getAbsolutePath();
        Job job = Job.getInstance();
        job.getConfiguration().set("fs.defaultFS", "file:///");
        job.setOutputKeyClass(NullWritable.class);
        job.setOutputValueClass(Text.class);
        job.setOutputFormatClass(SequenceFileOutputFormat.class);
        SequenceFileOutputFormat.setOutputPath((Job)job, (Path)new Path(outputPath));
        job.getConfiguration().setBoolean("mapred.reducer.new-api", true);
        job.getConfiguration().setBoolean("tez.mapreduce.is_map_processor", false);
        UserPayload vertexPayload = TezUtils.createUserPayloadFromConf((Configuration)job.getConfiguration());
        OutputDescriptor od = (OutputDescriptor)OutputDescriptor.create((String)MROutputLegacy.class.getName()).setUserPayload(vertexPayload);
        DataSinkDescriptor sink = DataSinkDescriptor.create((OutputDescriptor)od, (OutputCommitterDescriptor)OutputCommitterDescriptor.create((String)MROutputCommitter.class.getName()), null);
        OutputContext outputContext = this.createMockOutputContext(sink.getOutputDescriptor().getUserPayload());
        MROutputLegacy output = new MROutputLegacy(outputContext, 2);
        output.initialize();
        Assert.assertEquals((Object)true, (Object)output.useNewApi);
        Assert.assertEquals(SequenceFileOutputFormat.class, output.newOutputFormat.getClass());
        Assert.assertNull((Object)output.oldOutputFormat);
        Assert.assertEquals(NullWritable.class, (Object)output.newApiTaskAttemptContext.getOutputKeyClass());
        Assert.assertEquals(Text.class, (Object)output.newApiTaskAttemptContext.getOutputValueClass());
        Assert.assertNull((Object)output.oldApiTaskAttemptContext);
        Assert.assertNotNull((Object)output.newRecordWriter);
        Assert.assertNull((Object)output.oldRecordWriter);
        Assert.assertEquals(org.apache.hadoop.mapreduce.lib.output.FileOutputCommitter.class, output.committer.getClass());
    }

    @Test(timeout=5000L)
    public void testOldAPI_MapperOnly() throws Exception {
        String outputPath = TEST_DIR.getAbsolutePath();
        JobConf conf = new JobConf();
        conf.set("fs.defaultFS", "file:///");
        conf.setOutputKeyClass(NullWritable.class);
        conf.setOutputValueClass(Text.class);
        conf.setOutputFormat(org.apache.hadoop.mapred.SequenceFileOutputFormat.class);
        org.apache.hadoop.mapred.SequenceFileOutputFormat.setOutputPath((JobConf)conf, (Path)new Path(outputPath));
        conf.setBoolean("tez.mapreduce.is_map_processor", true);
        UserPayload vertexPayload = TezUtils.createUserPayloadFromConf((Configuration)conf);
        OutputDescriptor od = (OutputDescriptor)OutputDescriptor.create((String)MROutputLegacy.class.getName()).setUserPayload(vertexPayload);
        DataSinkDescriptor sink = DataSinkDescriptor.create((OutputDescriptor)od, (OutputCommitterDescriptor)OutputCommitterDescriptor.create((String)MROutputCommitter.class.getName()), null);
        OutputContext outputContext = this.createMockOutputContext(sink.getOutputDescriptor().getUserPayload());
        MROutputLegacy output = new MROutputLegacy(outputContext, 2);
        output.initialize();
        Assert.assertEquals((Object)false, (Object)output.useNewApi);
        Assert.assertEquals(org.apache.hadoop.mapred.SequenceFileOutputFormat.class, output.oldOutputFormat.getClass());
        Assert.assertNull((Object)output.newOutputFormat);
        Assert.assertEquals(NullWritable.class, (Object)output.oldApiTaskAttemptContext.getOutputKeyClass());
        Assert.assertEquals(Text.class, (Object)output.oldApiTaskAttemptContext.getOutputValueClass());
        Assert.assertNull((Object)output.newApiTaskAttemptContext);
        Assert.assertNotNull((Object)output.oldRecordWriter);
        Assert.assertNull((Object)output.newRecordWriter);
        Assert.assertEquals(FileOutputCommitter.class, output.committer.getClass());
    }

    @Test(timeout=5000L)
    public void testNewAPI_MapperOnly() throws Exception {
        String outputPath = TEST_DIR.getAbsolutePath();
        Job job = Job.getInstance();
        job.getConfiguration().set("fs.defaultFS", "file:///");
        job.setOutputKeyClass(NullWritable.class);
        job.setOutputValueClass(Text.class);
        job.setOutputFormatClass(SequenceFileOutputFormat.class);
        SequenceFileOutputFormat.setOutputPath((Job)job, (Path)new Path(outputPath));
        job.getConfiguration().setBoolean("mapred.mapper.new-api", true);
        job.getConfiguration().setBoolean("tez.mapreduce.is_map_processor", true);
        UserPayload vertexPayload = TezUtils.createUserPayloadFromConf((Configuration)job.getConfiguration());
        OutputDescriptor od = (OutputDescriptor)OutputDescriptor.create((String)MROutputLegacy.class.getName()).setUserPayload(vertexPayload);
        DataSinkDescriptor sink = DataSinkDescriptor.create((OutputDescriptor)od, (OutputCommitterDescriptor)OutputCommitterDescriptor.create((String)MROutputCommitter.class.getName()), null);
        OutputContext outputContext = this.createMockOutputContext(sink.getOutputDescriptor().getUserPayload());
        MROutputLegacy output = new MROutputLegacy(outputContext, 2);
        output.initialize();
        Assert.assertEquals((Object)true, (Object)output.useNewApi);
        Assert.assertEquals(SequenceFileOutputFormat.class, output.newOutputFormat.getClass());
        Assert.assertNull((Object)output.oldOutputFormat);
        Assert.assertEquals(NullWritable.class, (Object)output.newApiTaskAttemptContext.getOutputKeyClass());
        Assert.assertEquals(Text.class, (Object)output.newApiTaskAttemptContext.getOutputValueClass());
        Assert.assertNull((Object)output.oldApiTaskAttemptContext);
        Assert.assertNotNull((Object)output.newRecordWriter);
        Assert.assertNull((Object)output.oldRecordWriter);
        Assert.assertEquals(org.apache.hadoop.mapreduce.lib.output.FileOutputCommitter.class, output.committer.getClass());
    }

    private OutputContext createMockOutputContext(UserPayload payload) {
        OutputContext outputContext = (OutputContext)Mockito.mock(OutputContext.class);
        ApplicationId appId = ApplicationId.newInstance((long)System.currentTimeMillis(), (int)1);
        Mockito.when((Object)outputContext.getUserPayload()).thenReturn((Object)payload);
        Mockito.when((Object)outputContext.getApplicationId()).thenReturn((Object)appId);
        Mockito.when((Object)outputContext.getTaskVertexIndex()).thenReturn((Object)1);
        Mockito.when((Object)outputContext.getTaskAttemptNumber()).thenReturn((Object)1);
        Mockito.when((Object)outputContext.getCounters()).thenReturn((Object)new TezCounters());
        Mockito.when((Object)outputContext.getContainerConfiguration()).thenReturn((Object)new Configuration(false));
        return outputContext;
    }
}

