/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.mapreduce.hadoop;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.serializer.SerializationFactory;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.security.Credentials;
import org.apache.tez.common.Preconditions;
import org.apache.tez.dag.api.TaskLocationHint;
import org.apache.tez.mapreduce.hadoop.InputSplitInfo;
import org.apache.tez.mapreduce.hadoop.MRInputHelpers;
import org.apache.tez.mapreduce.protos.MRRuntimeProtos;

public class InputSplitInfoMem
implements InputSplitInfo {
    private final boolean isNewSplit;
    private final int numTasks;
    private final Credentials credentials;
    private final Configuration conf;
    private final List<TaskLocationHint> taskLocationHints;
    private InputSplit[] newFormatSplits;
    private org.apache.hadoop.mapred.InputSplit[] oldFormatSplits;

    public InputSplitInfoMem(InputSplit[] newSplits, List<TaskLocationHint> taskLocationHints, int numTasks, Credentials credentials, Configuration conf) {
        this.isNewSplit = true;
        this.newFormatSplits = newSplits;
        this.taskLocationHints = taskLocationHints;
        this.numTasks = numTasks;
        this.credentials = credentials;
        this.conf = conf;
    }

    public InputSplitInfoMem(org.apache.hadoop.mapred.InputSplit[] oldSplits, List<TaskLocationHint> taskLocationHints, int numTasks, Credentials credentials, Configuration conf) {
        this.isNewSplit = false;
        this.oldFormatSplits = oldSplits;
        this.taskLocationHints = taskLocationHints;
        this.numTasks = numTasks;
        this.credentials = credentials;
        this.conf = conf;
    }

    @Override
    public List<TaskLocationHint> getTaskLocationHints() {
        return this.taskLocationHints;
    }

    @Override
    public Path getSplitsMetaInfoFile() {
        throw new UnsupportedOperationException("Not supported for Type: " + this.getType());
    }

    @Override
    public Path getSplitsFile() {
        throw new UnsupportedOperationException("Not supported for Type: " + this.getType());
    }

    @Override
    public int getNumTasks() {
        return this.numTasks;
    }

    @Override
    public InputSplitInfo.Type getType() {
        return InputSplitInfo.Type.MEM;
    }

    @Override
    public MRRuntimeProtos.MRSplitsProto getSplitsProto() {
        if (this.isNewSplit) {
            try {
                return InputSplitInfoMem.createSplitsProto(this.newFormatSplits, new SerializationFactory(this.conf));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            return InputSplitInfoMem.createSplitsProto(this.oldFormatSplits);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Credentials getCredentials() {
        return this.credentials;
    }

    @Override
    public boolean holdsNewFormatSplits() {
        return this.isNewSplit;
    }

    @Override
    public InputSplit[] getNewFormatSplits() {
        Preconditions.checkState((this.isNewSplit ? 1 : 0) != 0, (Object)"Cannot fetch newSplits for an instance handling oldFormatSplits. Use holdsNewFormatSplits() to check type");
        return this.newFormatSplits;
    }

    @Override
    public org.apache.hadoop.mapred.InputSplit[] getOldFormatSplits() {
        Preconditions.checkState((!this.isNewSplit ? 1 : 0) != 0, (Object)"Cannot fetch newSplits for an instance handling newFormatSplits. Use holdsNewFormatSplits() to check type");
        return this.oldFormatSplits;
    }

    private static MRRuntimeProtos.MRSplitsProto createSplitsProto(InputSplit[] newSplits, SerializationFactory serializationFactory) throws IOException, InterruptedException {
        MRRuntimeProtos.MRSplitsProto.Builder splitsBuilder = MRRuntimeProtos.MRSplitsProto.newBuilder();
        for (InputSplit newSplit : newSplits) {
            splitsBuilder.addSplits(MRInputHelpers.createSplitProto(newSplit, serializationFactory));
        }
        return splitsBuilder.build();
    }

    private static MRRuntimeProtos.MRSplitsProto createSplitsProto(org.apache.hadoop.mapred.InputSplit[] oldSplits) throws IOException {
        MRRuntimeProtos.MRSplitsProto.Builder splitsBuilder = MRRuntimeProtos.MRSplitsProto.newBuilder();
        for (org.apache.hadoop.mapred.InputSplit oldSplit : oldSplits) {
            splitsBuilder.addSplits(MRInputHelpers.createSplitProto(oldSplit));
        }
        return splitsBuilder.build();
    }
}

