/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.mapreduce;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.runtime.api.TaskFailureType;
import org.apache.tez.runtime.api.impl.EventMetaData;
import org.apache.tez.runtime.api.impl.TezEvent;
import org.apache.tez.runtime.api.impl.TezUmbilical;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestUmbilical
implements TezUmbilical {
    private static final Logger LOG = LoggerFactory.getLogger(TestUmbilical.class);
    private final List<TezEvent> events = Lists.newLinkedList();

    public void addEvents(Collection<TezEvent> events) {
        if (events != null && events.size() > 0) {
            this.events.addAll(events);
            LOG.info("#Events Received: " + events.size());
            for (TezEvent event : events) {
                LOG.info("Event: " + event);
            }
        }
    }

    public void signalFailure(TezTaskAttemptID taskAttemptID, TaskFailureType taskFailureType, Throwable t, String message, EventMetaData sourceInfo) {
        LOG.info("Received failure from task: " + taskAttemptID + ", Message: " + message + ", taskFailureType=" + taskFailureType);
    }

    public void signalKillSelf(TezTaskAttemptID taskAttemptID, Throwable t, String message, EventMetaData sourceInfo) {
        LOG.info("Received kill from task: " + taskAttemptID + ", Message: " + message);
    }

    public List<TezEvent> getEvents() {
        return this.events;
    }

    public boolean canCommit(TezTaskAttemptID taskAttemptID) throws IOException {
        LOG.info("Got canCommit from task: " + taskAttemptID);
        return true;
    }
}

