/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.analyzer.utils;

import com.google.common.base.Joiner;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.DecimalFormat;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.FileWriterWithEncoding;
import org.apache.tez.analyzer.plugins.CriticalPathAnalyzer;
import org.apache.tez.history.parser.datamodel.DagInfo;
import org.apache.tez.history.parser.datamodel.TaskAttemptInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SVGUtils {
    private static final Logger LOG = LoggerFactory.getLogger(SVGUtils.class);
    private static int MAX_DAG_RUNTIME = 0;
    private static final int SCREEN_WIDTH = 1800;
    private int Y_MAX;
    private int X_MAX;
    private static final DecimalFormat secondFormat = new DecimalFormat("#.##");
    private static final int X_BASE = 100;
    private static final int Y_BASE = 100;
    private static final int TICK = 1;
    private static final int STEP_GAP = 50;
    private static final int TEXT_SIZE = 20;
    private static final String RUNTIME_COLOR = "LightGreen";
    private static final String ALLOCATION_OVERHEAD_COLOR = "GoldenRod";
    private static final String LAUNCH_OVERHEAD_COLOR = "DarkSalmon";
    private static final String BORDER_COLOR = "Sienna";
    private static final String VERTEX_INIT_COMMIT_COLOR = "LightSalmon";
    private static final String CRITICAL_COLOR = "IndianRed";
    private static final float RECT_OPACITY = 1.0f;
    private static final String TITLE_BR = "&#13;";
    List<String> svgLines = new LinkedList<String>();

    public static String getTimeStr(long millis) {
        long minutes = TimeUnit.MILLISECONDS.toMinutes(millis) - TimeUnit.HOURS.toMinutes(TimeUnit.MILLISECONDS.toHours(millis));
        long hours = TimeUnit.MILLISECONDS.toHours(millis);
        StringBuilder b = new StringBuilder();
        b.append((String)(hours == 0L ? "" : String.valueOf(hours) + "h"));
        b.append((String)(minutes == 0L ? "" : String.valueOf(minutes) + "m"));
        long seconds = millis - TimeUnit.MINUTES.toMillis(TimeUnit.MILLISECONDS.toMinutes(millis));
        b.append(secondFormat.format((double)seconds / 1000.0) + "s");
        return b.toString();
    }

    private final int addOffsetX(int x) {
        int xOff = x + 100;
        this.X_MAX = Math.max(this.X_MAX, xOff);
        return xOff;
    }

    private final int addOffsetY(int y) {
        int yOff = y + 100;
        this.Y_MAX = Math.max(this.Y_MAX, yOff);
        return yOff;
    }

    private int scaleDown(int len) {
        return Math.round((float)len * 1.0f / (float)MAX_DAG_RUNTIME * 1800.0f);
    }

    private void addRectStr(int x, int width, int y, int height, String fillColor, String borderColor, float opacity, String title) {
        String rectStyle = "stroke: " + borderColor + "; fill: " + fillColor + "; opacity: " + opacity;
        String rectStr = "<rect x=\"" + this.addOffsetX(this.scaleDown(x)) + "\" y=\"" + this.addOffsetY(y) + "\" width=\"" + this.scaleDown(width) + "\" height=\"" + height + "\" style=\"" + rectStyle + "\" > <title>" + title + "</title> </rect>";
        this.svgLines.add(rectStr);
    }

    private void addTextStr(int x, int y, String text, String anchor, int size, String title, boolean italic) {
        String textStyle = "text-anchor: " + anchor + "; font-style: " + (italic ? "italic" : "normal") + "; font-size: " + size + "px;";
        String textStr = "<text x=\"" + this.addOffsetX(this.scaleDown(x)) + "\" y=\"" + this.addOffsetY(y) + "\" style=\"" + textStyle + "\" transform=\"\">" + text + " <title>" + title + "</title></text>";
        this.svgLines.add(textStr);
    }

    private void addLineStr(int x1, int y1, int x2, int y2, String color, String title, int width) {
        String style = "stroke: " + color + "; stroke-width:" + width;
        String str = "<line x1=\"" + this.addOffsetX(this.scaleDown(x1)) + "\" y1=\"" + this.addOffsetY(y1) + "\" x2=\"" + this.addOffsetX(this.scaleDown(x2)) + "\" y2=\"" + this.addOffsetY(y2) + "\" style=\"" + style + "\" > <title>" + title + "</title> </line>";
        this.svgLines.add(str);
    }

    public void drawStep(CriticalPathAnalyzer.CriticalPathStep step, long dagStartTime, int yOffset) {
        if (step.getType() != CriticalPathAnalyzer.CriticalPathStep.EntityType.ATTEMPT) {
            StringBuilder title = new StringBuilder();
            Object text = null;
            if (step.getType() == CriticalPathAnalyzer.CriticalPathStep.EntityType.VERTEX_INIT) {
                String vertex = step.getAttempt().getTaskInfo().getVertexInfo().getVertexName();
                text = vertex + " : Init";
                title.append((String)text).append(TITLE_BR);
            } else {
                text = "Output Commit";
                title.append((String)text).append(TITLE_BR);
            }
            title.append("Critical Path Dependency: " + step.getReason()).append(TITLE_BR);
            title.append("Critical Time: " + SVGUtils.getTimeStr(step.getStopCriticalTime() - step.getStartCriticalTime())).append("");
            title.append(Joiner.on((String)TITLE_BR).join(step.getNotes()));
            String titleStr = title.toString();
            int stopTimeInterval = (int)(step.getStopCriticalTime() - dagStartTime);
            int startTimeInterval = (int)(step.getStartCriticalTime() - dagStartTime);
            this.addRectStr(startTimeInterval, stopTimeInterval - startTimeInterval, yOffset * 50, 50, VERTEX_INIT_COMMIT_COLOR, BORDER_COLOR, 1.0f, titleStr);
            this.addTextStr((stopTimeInterval + startTimeInterval) / 2, yOffset * 50 + 25, (String)text, "middle", 20, titleStr, false);
        } else {
            TaskAttemptInfo attempt = step.getAttempt();
            int startCriticalTimeInterval = (int)(step.getStartCriticalTime() - dagStartTime);
            int stopCriticalTimeInterval = (int)(step.getStopCriticalTime() - dagStartTime);
            int creationTimeInterval = (int)(attempt.getCreationTime() - dagStartTime);
            int allocationTimeInterval = attempt.getAllocationTime() > 0L ? (int)(attempt.getAllocationTime() - dagStartTime) : 0;
            int launchTimeInterval = attempt.getStartTime() > 0L ? (int)(attempt.getStartTime() - dagStartTime) : 0;
            int finishTimeInterval = (int)(attempt.getFinishTime() - dagStartTime);
            LOG.debug(attempt.getTaskAttemptId() + " " + creationTimeInterval + " " + allocationTimeInterval + " " + launchTimeInterval + " " + finishTimeInterval);
            StringBuilder title = new StringBuilder();
            title.append("Attempt: " + attempt.getTaskAttemptId()).append(TITLE_BR);
            title.append("Critical Path Dependency: " + step.getReason()).append(TITLE_BR);
            title.append("Completion Status: " + attempt.getDetailedStatus()).append(TITLE_BR);
            title.append("Critical Time Contribution: " + SVGUtils.getTimeStr(step.getStopCriticalTime() - step.getStartCriticalTime())).append(TITLE_BR);
            title.append("Critical start at: " + SVGUtils.getTimeStr(startCriticalTimeInterval)).append(TITLE_BR);
            title.append("Critical stop at: " + SVGUtils.getTimeStr(stopCriticalTimeInterval)).append(TITLE_BR);
            title.append("Created at: " + SVGUtils.getTimeStr(creationTimeInterval)).append(TITLE_BR);
            if (allocationTimeInterval > 0) {
                title.append("Allocated at: " + SVGUtils.getTimeStr(allocationTimeInterval)).append(TITLE_BR);
            }
            if (launchTimeInterval > 0) {
                title.append("Launched at: " + SVGUtils.getTimeStr(launchTimeInterval)).append(TITLE_BR);
            }
            title.append("Finished at: " + SVGUtils.getTimeStr(finishTimeInterval)).append(TITLE_BR);
            title.append(Joiner.on((String)TITLE_BR).join(step.getNotes()));
            String titleStr = title.toString();
            if (allocationTimeInterval > 0) {
                this.addRectStr(creationTimeInterval, allocationTimeInterval - creationTimeInterval, yOffset * 50, 50, ALLOCATION_OVERHEAD_COLOR, BORDER_COLOR, 1.0f, titleStr);
                if (launchTimeInterval > 0) {
                    this.addRectStr(allocationTimeInterval, launchTimeInterval - allocationTimeInterval, yOffset * 50, 50, LAUNCH_OVERHEAD_COLOR, BORDER_COLOR, 1.0f, titleStr);
                    this.addRectStr(launchTimeInterval, finishTimeInterval - launchTimeInterval, yOffset * 50, 50, RUNTIME_COLOR, BORDER_COLOR, 1.0f, titleStr);
                } else {
                    this.addRectStr(allocationTimeInterval, finishTimeInterval - allocationTimeInterval, yOffset * 50, 50, LAUNCH_OVERHEAD_COLOR, BORDER_COLOR, 1.0f, titleStr);
                }
            } else {
                this.addRectStr(creationTimeInterval, finishTimeInterval - creationTimeInterval, yOffset * 50, 50, ALLOCATION_OVERHEAD_COLOR, BORDER_COLOR, 1.0f, titleStr);
            }
            this.addTextStr((finishTimeInterval + creationTimeInterval) / 2, yOffset * 50 + 25, attempt.getShortName(), "middle", 20, titleStr, !attempt.isSucceeded());
        }
    }

    private void drawCritical(DagInfo dagInfo, List<CriticalPathAnalyzer.CriticalPathStep> criticalPath) {
        int i;
        long dagStartTime = dagInfo.getStartTime();
        int dagStartTimeInterval = 0;
        int dagFinishTimeInterval = (int)(dagInfo.getFinishTime() - dagStartTime);
        if (dagInfo.getFinishTime() <= 0L) {
            dagFinishTimeInterval = (int)(criticalPath.get(criticalPath.size() - 1).getStopCriticalTime() - dagStartTime);
        }
        MAX_DAG_RUNTIME = dagFinishTimeInterval;
        this.addLineStr(dagStartTimeInterval, 0, dagFinishTimeInterval, 0, BORDER_COLOR, "", 1);
        int yGrid = (criticalPath.size() + 2) * 50;
        for (i = 0; i < 11; ++i) {
            int x = Math.round((float)(dagFinishTimeInterval - dagStartTimeInterval) / 10.0f * (float)i);
            this.addLineStr(x, 0, x, yGrid, BORDER_COLOR, "", 1);
            this.addTextStr(x, 0, SVGUtils.getTimeStr(x), "left", 20, "", false);
        }
        this.addLineStr(dagStartTimeInterval, yGrid, dagFinishTimeInterval, yGrid, BORDER_COLOR, "", 1);
        this.addTextStr((dagFinishTimeInterval + dagStartTimeInterval) / 2, yGrid + 50, "Critical Path for " + dagInfo.getName() + " (" + dagInfo.getDagId() + ")", "middle", 20, "", false);
        for (i = 1; i <= criticalPath.size(); ++i) {
            CriticalPathAnalyzer.CriticalPathStep step = criticalPath.get(i - 1);
            this.drawStep(step, dagStartTime, i);
        }
        for (i = 1; i <= criticalPath.size(); ++i) {
            CriticalPathAnalyzer.CriticalPathStep step = criticalPath.get(i - 1);
            boolean isLast = i == criticalPath.size();
            int startCriticalTimeInterval = (int)(step.getStartCriticalTime() - dagStartTime);
            int stopCriticalTimeInterval = (int)(step.getStopCriticalTime() - dagStartTime);
            this.addLineStr(startCriticalTimeInterval, (i + 1) * 50, stopCriticalTimeInterval, (i + 1) * 50, CRITICAL_COLOR, "Critical Time " + step.getAttempt().getShortName(), 5);
            if (isLast) {
                int stepStopCriticalTimeInterval = (int)(step.getStopCriticalTime() - dagStartTime);
                this.addLineStr(stepStopCriticalTimeInterval, (i + 1) * 50, dagFinishTimeInterval, (i + 1) * 50, CRITICAL_COLOR, "Critical Time " + step.getAttempt().getTaskInfo().getVertexInfo().getVertexName(), 5);
                continue;
            }
            this.addLineStr(stopCriticalTimeInterval, (i + 1) * 50, stopCriticalTimeInterval, (i + 2) * 50, CRITICAL_COLOR, "Critical Time " + step.getAttempt().getShortName(), 5);
        }
        int legendX = 0;
        int legendY = (criticalPath.size() + 2) * 50;
        int legendWidth = dagFinishTimeInterval / 5;
        this.addRectStr(legendX, legendWidth, legendY, 25, VERTEX_INIT_COMMIT_COLOR, BORDER_COLOR, 1.0f, "");
        this.addTextStr(legendX, legendY + 16, "Vertex Init/Commit Overhead", "left", 20, "", false);
        this.addRectStr(legendX, legendWidth, legendY += 25, 25, ALLOCATION_OVERHEAD_COLOR, BORDER_COLOR, 1.0f, "");
        this.addTextStr(legendX, legendY + 16, "Task Allocation Overhead", "left", 20, "", false);
        this.addRectStr(legendX, legendWidth, legendY += 25, 25, LAUNCH_OVERHEAD_COLOR, BORDER_COLOR, 1.0f, "");
        this.addTextStr(legendX, legendY + 16, "Task Launch Overhead", "left", 20, "", false);
        this.addRectStr(legendX, legendWidth, legendY += 25, 25, RUNTIME_COLOR, BORDER_COLOR, 1.0f, "");
        this.addTextStr(legendX, legendY + 16, "Task Execution Time", "left", 20, "", false);
        this.Y_MAX += 200;
        this.X_MAX += 200;
    }

    public void saveCriticalPathAsSVG(DagInfo dagInfo, String fileName, List<CriticalPathAnalyzer.CriticalPathStep> criticalPath) {
        this.drawCritical(dagInfo, criticalPath);
        this.saveFileStr(fileName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void saveFileStr(String fileName) {
        String header = "<?xml version=\"1.0\" standalone=\"no\"?> <!DOCTYPE svg PUBLIC \"-//W3C//DTD SVG 1.1//EN\" \"http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd\"><svg xmlns=\"http://www.w3.org/2000/svg\" version=\"1.1\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" height=\"" + this.Y_MAX + "\" width=\"" + this.X_MAX + "\"> <script type=\"text/ecmascript\" xlink:href=\"http://code.jquery.com/jquery-2.1.1.min.js\" />";
        String footer = "</svg>";
        String newline = System.getProperty("line.separator");
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter((Writer)new FileWriterWithEncoding(fileName, "UTF-8"));
            writer.write(header);
            writer.write(newline);
            for (String str : this.svgLines) {
                writer.write(str);
                writer.write(newline);
            }
            writer.write(footer);
            if (writer == null) return;
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                if (writer == null) throw throwable;
                IOUtils.closeQuietly(writer);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)writer);
        return;
    }
}

