/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.analyzer.plugins;

import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.LinkedList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.tez.analyzer.Analyzer;
import org.apache.tez.analyzer.CSVResult;
import org.apache.tez.analyzer.plugins.TezAnalyzerBase;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.history.parser.datamodel.Container;
import org.apache.tez.history.parser.datamodel.DagInfo;
import org.apache.tez.history.parser.datamodel.VertexInfo;

public class ContainerReuseAnalyzer
extends TezAnalyzerBase
implements Analyzer {
    private static final String[] headers = new String[]{"vertexName", "taskAttempts", "node", "containerId", "reuseCount"};
    private final CSVResult csvResult = new CSVResult(headers);

    public ContainerReuseAnalyzer(Configuration config) {
        super(config);
    }

    @Override
    public void analyze(DagInfo dagInfo) throws TezException {
        for (VertexInfo vertexInfo : dagInfo.getVertices()) {
            Multimap containers = vertexInfo.getContainersMapping();
            for (Container container : containers.keySet()) {
                LinkedList record = Lists.newLinkedList();
                record.add(vertexInfo.getVertexName());
                record.add("" + vertexInfo.getTaskAttempts().size());
                record.add(container.getHost());
                record.add(container.getId());
                record.add(Integer.toString(containers.get((Object)container).size()));
                this.csvResult.addRecord(record.toArray(new String[record.size()]));
            }
        }
    }

    @Override
    public CSVResult getResult() throws TezException {
        return this.csvResult;
    }

    @Override
    public String getName() {
        return "Container Reuse Analyzer";
    }

    @Override
    public String getDescription() {
        return "Get details on container reuse analysis";
    }

    public static void main(String[] args) throws Exception {
        Configuration config = new Configuration();
        ContainerReuseAnalyzer analyzer = new ContainerReuseAnalyzer(config);
        int res = ToolRunner.run((Configuration)config, (Tool)analyzer, (String[])args);
        analyzer.printResults();
        System.exit(res);
    }
}

