/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.analyzer.utils;

import com.sun.istack.Nullable;
import java.io.IOException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tez.dag.utils.Graph;
import org.apache.tez.history.parser.datamodel.AdditionalInputOutputDetails;
import org.apache.tez.history.parser.datamodel.DagInfo;
import org.apache.tez.history.parser.datamodel.EdgeInfo;
import org.apache.tez.history.parser.datamodel.VertexInfo;

public class Utils {
    private static Pattern sanitizeLabelPattern = Pattern.compile("[:\\-\\W]+");

    public static String getShortClassName(String className) {
        int pos = className.lastIndexOf(".");
        if (pos != -1 && pos < className.length() - 1) {
            return className.substring(pos + 1);
        }
        return className;
    }

    public static String sanitizeLabelForViz(String label) {
        Matcher m = sanitizeLabelPattern.matcher(label);
        return m.replaceAll("_");
    }

    public static void generateDAGVizFile(DagInfo dagInfo, String fileName, @Nullable List<String> criticalVertices) throws IOException {
        Graph graph = new Graph(Utils.sanitizeLabelForViz(dagInfo.getName()));
        for (VertexInfo v : dagInfo.getVertices()) {
            boolean criticalVertex;
            String nodeLabel = Utils.sanitizeLabelForViz(v.getVertexName()) + "[" + Utils.getShortClassName(v.getProcessorClassName() + ", tasks=" + v.getTasks().size() + ", time=" + v.getTimeTaken() + " ms]");
            Graph.Node n = graph.newNode(Utils.sanitizeLabelForViz(v.getVertexName()), nodeLabel);
            boolean bl = criticalVertex = criticalVertices != null ? criticalVertices.contains(v.getVertexName()) : false;
            if (criticalVertex) {
                n.setColor("red");
            }
            for (AdditionalInputOutputDetails input : v.getAdditionalInputInfoList()) {
                Graph.Node inputNode = graph.getNode(Utils.sanitizeLabelForViz(v.getVertexName()) + "_" + Utils.sanitizeLabelForViz(input.getName()));
                inputNode.setLabel(Utils.sanitizeLabelForViz(v.getVertexName()) + "[" + Utils.sanitizeLabelForViz(input.getName()) + "]");
                inputNode.setShape("box");
                inputNode.addEdge(n, "Input name=" + input.getName() + " [inputClass=" + Utils.getShortClassName(input.getClazz()) + ", initializer=" + Utils.getShortClassName(input.getInitializer()) + "]");
            }
            for (AdditionalInputOutputDetails output : v.getAdditionalOutputInfoList()) {
                Graph.Node outputNode = graph.getNode(Utils.sanitizeLabelForViz(v.getVertexName()) + "_" + Utils.sanitizeLabelForViz(output.getName()));
                outputNode.setLabel(Utils.sanitizeLabelForViz(v.getVertexName()) + "[" + Utils.sanitizeLabelForViz(output.getName()) + "]");
                outputNode.setShape("box");
                n.addEdge(outputNode, "Output name=" + output.getName() + " [outputClass=" + Utils.getShortClassName(output.getClazz()) + ", committer=" + Utils.getShortClassName(output.getInitializer()) + "]");
            }
        }
        for (EdgeInfo e : dagInfo.getEdges()) {
            Graph.Node n = graph.getNode(Utils.sanitizeLabelForViz(e.getInputVertexName()));
            n.addEdge(graph.getNode(Utils.sanitizeLabelForViz(e.getOutputVertexName())), "[input=" + Utils.getShortClassName(e.getEdgeSourceClass()) + ", output=" + Utils.getShortClassName(e.getEdgeDestinationClass()) + ", dataMovement=" + e.getDataMovementType().trim() + "]");
        }
        graph.save(fileName);
    }
}

