/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.history.events;

import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.MessageLite;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.apache.tez.dag.history.HistoryEvent;
import org.apache.tez.dag.history.HistoryEventType;
import org.apache.tez.dag.history.SummaryEvent;
import org.apache.tez.dag.records.TezVertexID;
import org.apache.tez.dag.recovery.records.RecoveryProtos;

public class VertexCommitStartedEvent
implements HistoryEvent,
SummaryEvent {
    private TezVertexID vertexID;
    private long commitStartTime;
    private final Charset charSet = Charset.forName("UTF-8");

    public VertexCommitStartedEvent() {
    }

    public VertexCommitStartedEvent(TezVertexID vertexId, long commitStartTime) {
        this.vertexID = vertexId;
        this.commitStartTime = commitStartTime;
    }

    @Override
    public HistoryEventType getEventType() {
        return HistoryEventType.VERTEX_COMMIT_STARTED;
    }

    @Override
    public boolean isRecoveryEvent() {
        return true;
    }

    @Override
    public boolean isHistoryEvent() {
        return false;
    }

    public RecoveryProtos.VertexCommitStartedProto toProto() {
        return RecoveryProtos.VertexCommitStartedProto.newBuilder().setVertexId(this.vertexID.toString()).build();
    }

    public void fromProto(RecoveryProtos.VertexCommitStartedProto proto) {
        this.vertexID = TezVertexID.fromString((String)proto.getVertexId());
    }

    @Override
    public void toProtoStream(CodedOutputStream outputStream) throws IOException {
        outputStream.writeMessageNoTag((MessageLite)this.toProto());
    }

    @Override
    public void fromProtoStream(CodedInputStream inputStream) throws IOException {
        RecoveryProtos.VertexCommitStartedProto proto = (RecoveryProtos.VertexCommitStartedProto)inputStream.readMessage(RecoveryProtos.VertexCommitStartedProto.PARSER, ExtensionRegistryLite.getEmptyRegistry());
        if (proto == null) {
            throw new IOException("No data found in stream");
        }
        this.fromProto(proto);
    }

    public String toString() {
        return "vertexId=" + this.vertexID;
    }

    public TezVertexID getVertexID() {
        return this.vertexID;
    }

    @Override
    public void toSummaryProtoStream(OutputStream outputStream) throws IOException {
        RecoveryProtos.SummaryEventProto.Builder builder = RecoveryProtos.SummaryEventProto.newBuilder().setDagId(this.vertexID.getDAGID().toString()).setTimestamp(this.commitStartTime).setEventType(this.getEventType().ordinal()).setEventPayload(ByteString.copyFrom((byte[])this.vertexID.toString().getBytes(this.charSet)));
        builder.build().writeDelimitedTo(outputStream);
    }

    @Override
    public void fromSummaryProtoStream(RecoveryProtos.SummaryEventProto proto) throws IOException {
        this.vertexID = TezVertexID.fromString((String)new String(proto.getEventPayload().toByteArray(), this.charSet));
        this.commitStartTime = proto.getTimestamp();
    }

    @Override
    public boolean writeToRecoveryImmediately() {
        return false;
    }
}

