/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.history.events;

import com.google.common.collect.Lists;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.tez.common.ReflectionUtils;
import org.apache.tez.common.counters.CounterGroup;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.dag.api.EdgeManagerPluginDescriptor;
import org.apache.tez.dag.api.EdgeProperty;
import org.apache.tez.dag.api.InputDescriptor;
import org.apache.tez.dag.api.OutputDescriptor;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.dag.api.VertexLocationHint;
import org.apache.tez.dag.api.oldrecords.TaskAttemptState;
import org.apache.tez.dag.api.oldrecords.TaskState;
import org.apache.tez.dag.api.records.DAGProtos;
import org.apache.tez.dag.app.dag.DAGState;
import org.apache.tez.dag.app.dag.VertexState;
import org.apache.tez.dag.app.dag.impl.TaskAttemptImpl;
import org.apache.tez.dag.app.dag.impl.VertexStats;
import org.apache.tez.dag.history.HistoryEvent;
import org.apache.tez.dag.history.HistoryEventType;
import org.apache.tez.dag.history.SummaryEvent;
import org.apache.tez.dag.history.events.AMLaunchedEvent;
import org.apache.tez.dag.history.events.AMStartedEvent;
import org.apache.tez.dag.history.events.AppLaunchedEvent;
import org.apache.tez.dag.history.events.ContainerLaunchedEvent;
import org.apache.tez.dag.history.events.ContainerStoppedEvent;
import org.apache.tez.dag.history.events.DAGCommitStartedEvent;
import org.apache.tez.dag.history.events.DAGFinishedEvent;
import org.apache.tez.dag.history.events.DAGInitializedEvent;
import org.apache.tez.dag.history.events.DAGKillRequestEvent;
import org.apache.tez.dag.history.events.DAGRecoveredEvent;
import org.apache.tez.dag.history.events.DAGStartedEvent;
import org.apache.tez.dag.history.events.DAGSubmittedEvent;
import org.apache.tez.dag.history.events.TaskAttemptFinishedEvent;
import org.apache.tez.dag.history.events.TaskAttemptStartedEvent;
import org.apache.tez.dag.history.events.TaskFinishedEvent;
import org.apache.tez.dag.history.events.TaskStartedEvent;
import org.apache.tez.dag.history.events.VertexCommitStartedEvent;
import org.apache.tez.dag.history.events.VertexConfigurationDoneEvent;
import org.apache.tez.dag.history.events.VertexFinishedEvent;
import org.apache.tez.dag.history.events.VertexGroupCommitFinishedEvent;
import org.apache.tez.dag.history.events.VertexGroupCommitStartedEvent;
import org.apache.tez.dag.history.events.VertexInitializedEvent;
import org.apache.tez.dag.history.events.VertexStartedEvent;
import org.apache.tez.dag.records.TaskAttemptTerminationCause;
import org.apache.tez.dag.records.TezDAGID;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.dag.records.TezTaskID;
import org.apache.tez.dag.records.TezVertexID;
import org.apache.tez.dag.recovery.records.RecoveryProtos;
import org.apache.tez.runtime.api.Event;
import org.apache.tez.runtime.api.InputSpecUpdate;
import org.apache.tez.runtime.api.TaskFailureType;
import org.apache.tez.runtime.api.events.InputDataInformationEvent;
import org.apache.tez.runtime.api.impl.EventType;
import org.apache.tez.runtime.api.impl.TezEvent;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestHistoryEventsProtoConversion {
    private static final Logger LOG = LoggerFactory.getLogger(TestHistoryEventsProtoConversion.class);
    private final String QUEUE_NAME = "TEST_QUEUE_NAME";

    private HistoryEvent testProtoConversion(HistoryEvent event) throws IOException, TezException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        HistoryEvent deserializedEvent = null;
        CodedOutputStream codedOutputStream = CodedOutputStream.newInstance((OutputStream)os);
        event.toProtoStream(codedOutputStream);
        codedOutputStream.flush();
        os.flush();
        os.close();
        deserializedEvent = (HistoryEvent)ReflectionUtils.createClazzInstance((String)event.getClass().getName());
        LOG.info("Serialized event to byte array, eventType=" + event.getEventType() + ", bufLen=" + os.toByteArray().length);
        deserializedEvent.fromProtoStream(CodedInputStream.newInstance((byte[])os.toByteArray()));
        return deserializedEvent;
    }

    private HistoryEvent testSummaryProtoConversion(HistoryEvent historyEvent) throws IOException, TezException {
        SummaryEvent event = (SummaryEvent)historyEvent;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        HistoryEvent deserializedEvent = null;
        event.toSummaryProtoStream((OutputStream)os);
        os.flush();
        os.close();
        LOG.info("Serialized event to byte array, eventType=" + historyEvent.getEventType() + ", bufLen=" + os.toByteArray().length);
        RecoveryProtos.SummaryEventProto summaryEventProto = RecoveryProtos.SummaryEventProto.parseDelimitedFrom((InputStream)new ByteArrayInputStream(os.toByteArray()));
        deserializedEvent = (HistoryEvent)ReflectionUtils.createClazzInstance((String)event.getClass().getName());
        ((SummaryEvent)deserializedEvent).fromSummaryProtoStream(summaryEventProto);
        return deserializedEvent;
    }

    private void logEvents(HistoryEvent event, HistoryEvent deserializedEvent) {
        LOG.info("Initial Event toString: " + event.toString());
        LOG.info("Deserialized Event toString: " + deserializedEvent.toString());
    }

    private void testAppLaunchedEvent() throws Exception {
        AppLaunchedEvent event = new AppLaunchedEvent(ApplicationId.newInstance((long)0L, (int)1), 100L, 100L, null, new Configuration(false), null);
        try {
            this.testProtoConversion((HistoryEvent)event);
            Assert.fail((String)"Expected to fail on conversion");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        LOG.info("Initial Event toString: " + event.toString());
    }

    private void testAMLaunchedEvent() throws Exception {
        AMLaunchedEvent event = new AMLaunchedEvent(ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1), 100L, 100L, null);
        AMLaunchedEvent deserializedEvent = (AMLaunchedEvent)this.testProtoConversion((HistoryEvent)event);
        Assert.assertEquals((Object)event.getApplicationAttemptId(), (Object)deserializedEvent.getApplicationAttemptId());
        Assert.assertEquals((long)event.getAppSubmitTime(), (long)deserializedEvent.getAppSubmitTime());
        Assert.assertEquals((long)event.getLaunchTime(), (long)deserializedEvent.getLaunchTime());
        this.logEvents((HistoryEvent)event, (HistoryEvent)deserializedEvent);
    }

    private void testAMStartedEvent() throws Exception {
        AMStartedEvent event = new AMStartedEvent(ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1), 100L, "");
        AMStartedEvent deserializedEvent = (AMStartedEvent)this.testProtoConversion((HistoryEvent)event);
        Assert.assertEquals((Object)event.getApplicationAttemptId(), (Object)deserializedEvent.getApplicationAttemptId());
        Assert.assertEquals((long)event.getStartTime(), (long)deserializedEvent.getStartTime());
        this.logEvents((HistoryEvent)event, (HistoryEvent)deserializedEvent);
    }

    private void testDAGSubmittedEvent() throws Exception {
        DAGSubmittedEvent event = new DAGSubmittedEvent(TezDAGID.getInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1), 1001L, DAGProtos.DAGPlan.newBuilder().setName("foo").build(), ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1), null, "", null, null, "TEST_QUEUE_NAME");
        DAGSubmittedEvent deserializedEvent = (DAGSubmittedEvent)this.testProtoConversion((HistoryEvent)event);
        Assert.assertEquals((Object)event.getApplicationAttemptId(), (Object)deserializedEvent.getApplicationAttemptId());
        Assert.assertEquals((Object)event.getDAGID(), (Object)deserializedEvent.getDAGID());
        Assert.assertEquals((Object)event.getDAGName(), (Object)deserializedEvent.getDAGName());
        Assert.assertEquals((long)event.getSubmitTime(), (long)deserializedEvent.getSubmitTime());
        Assert.assertEquals((Object)event.getDAGPlan(), (Object)deserializedEvent.getDAGPlan());
        Assert.assertEquals((Object)event.getQueueName(), (Object)deserializedEvent.getQueueName());
        this.logEvents((HistoryEvent)event, (HistoryEvent)deserializedEvent);
    }

    private void testDAGInitializedEvent() throws Exception {
        DAGInitializedEvent event = new DAGInitializedEvent(TezDAGID.getInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1), 100334L, "user", "dagName", null);
        DAGInitializedEvent deserializedEvent = (DAGInitializedEvent)this.testProtoConversion((HistoryEvent)event);
        Assert.assertEquals((Object)event.getDAGID(), (Object)deserializedEvent.getDAGID());
        Assert.assertEquals((long)event.getInitTime(), (long)deserializedEvent.getInitTime());
        this.logEvents((HistoryEvent)event, (HistoryEvent)deserializedEvent);
    }

    private void testDAGStartedEvent() throws Exception {
        DAGStartedEvent event = new DAGStartedEvent(TezDAGID.getInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1), 100334L, "user", "dagName");
        DAGStartedEvent deserializedEvent = (DAGStartedEvent)this.testProtoConversion((HistoryEvent)event);
        Assert.assertEquals((Object)event.getDAGID(), (Object)deserializedEvent.getDAGID());
        Assert.assertEquals((long)event.getStartTime(), (long)deserializedEvent.getStartTime());
        this.logEvents((HistoryEvent)event, (HistoryEvent)deserializedEvent);
    }

    private void testDAGKillRequestEvent() throws Exception {
        DAGKillRequestEvent event = new DAGKillRequestEvent(TezDAGID.getInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1), 100334L, false);
        DAGKillRequestEvent deserializedEvent = (DAGKillRequestEvent)this.testProtoConversion((HistoryEvent)event);
        Assert.assertEquals((Object)event.getDagID(), (Object)deserializedEvent.getDagID());
        Assert.assertEquals((long)event.getKillRequestTime(), (long)deserializedEvent.getKillRequestTime());
        Assert.assertEquals((Object)event.isSessionStopped(), (Object)deserializedEvent.isSessionStopped());
        this.logEvents((HistoryEvent)event, (HistoryEvent)deserializedEvent);
    }

    private void testDAGFinishedEvent() throws Exception {
        DAGFinishedEvent event = new DAGFinishedEvent(TezDAGID.getInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1), 1000L, 20000L, DAGState.FAILED, null, null, "user", "dagName", null, null, DAGProtos.DAGPlan.newBuilder().setName("dagName").build());
        DAGFinishedEvent deserializedEvent = (DAGFinishedEvent)this.testProtoConversion((HistoryEvent)event);
        Assert.assertEquals((Object)event.getDAGID(), (Object)deserializedEvent.getDAGID());
        Assert.assertEquals((Object)event.getState(), (Object)deserializedEvent.getState());
        Assert.assertNotEquals((long)event.getStartTime(), (long)deserializedEvent.getStartTime());
        Assert.assertEquals((long)event.getFinishTime(), (long)deserializedEvent.getFinishTime());
        Assert.assertEquals((Object)event.getDiagnostics(), (Object)deserializedEvent.getDiagnostics());
        Assert.assertEquals((Object)event.getTezCounters(), (Object)deserializedEvent.getTezCounters());
        this.logEvents((HistoryEvent)event, (HistoryEvent)deserializedEvent);
        TezCounters tezCounters = new TezCounters();
        tezCounters.addGroup("foo", "bar");
        ((CounterGroup)tezCounters.getGroup("foo")).addCounter("c1", "c1", 100L);
        ((CounterGroup)tezCounters.getGroup("foo")).findCounter("c1").increment(1L);
        DAGFinishedEvent event2 = new DAGFinishedEvent(TezDAGID.getInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1), 1000L, 20000L, DAGState.FAILED, "bad diagnostics", tezCounters, "user", "dagName", null, null, DAGProtos.DAGPlan.newBuilder().setName("dagName").build());
        DAGFinishedEvent deserializedEvent2 = (DAGFinishedEvent)this.testProtoConversion((HistoryEvent)event2);
        Assert.assertEquals((Object)event2.getDAGID(), (Object)deserializedEvent2.getDAGID());
        Assert.assertEquals((Object)event2.getState(), (Object)deserializedEvent2.getState());
        Assert.assertNotEquals((long)event2.getStartTime(), (long)deserializedEvent2.getStartTime());
        Assert.assertEquals((long)event2.getFinishTime(), (long)deserializedEvent2.getFinishTime());
        Assert.assertEquals((Object)event2.getDiagnostics(), (Object)deserializedEvent2.getDiagnostics());
        Assert.assertEquals((Object)event2.getTezCounters(), (Object)deserializedEvent2.getTezCounters());
        Assert.assertEquals((long)101L, (long)((CounterGroup)deserializedEvent2.getTezCounters().getGroup("foo")).findCounter("c1").getValue());
        this.logEvents((HistoryEvent)event2, (HistoryEvent)deserializedEvent2);
    }

    private void testVertexInitializedEvent() throws Exception {
        ArrayList initGeneratedEvents = Lists.newArrayList((Object[])new TezEvent[]{new TezEvent((Event)InputDataInformationEvent.createWithSerializedPayload((int)0, (ByteBuffer)ByteBuffer.wrap(new byte[0])), null)});
        VertexInitializedEvent event = new VertexInitializedEvent(TezVertexID.getInstance((TezDAGID)TezDAGID.getInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1), (int)111), "vertex1", 1000L, 15000L, 100, "procName", null, (List)initGeneratedEvents, null);
        VertexInitializedEvent deserializedEvent = (VertexInitializedEvent)this.testProtoConversion((HistoryEvent)event);
        Assert.assertEquals((Object)event.getVertexID(), (Object)deserializedEvent.getVertexID());
        Assert.assertEquals((long)event.getInitRequestedTime(), (long)deserializedEvent.getInitRequestedTime());
        Assert.assertEquals((long)event.getInitedTime(), (long)deserializedEvent.getInitedTime());
        Assert.assertEquals((long)event.getNumTasks(), (long)deserializedEvent.getNumTasks());
        Assert.assertEquals((Object)event.getAdditionalInputs(), (Object)deserializedEvent.getAdditionalInputs());
        Assert.assertNull((Object)deserializedEvent.getProcessorName());
        Assert.assertEquals((long)1L, (long)event.getInitGeneratedEvents().size());
        Assert.assertEquals((Object)EventType.ROOT_INPUT_DATA_INFORMATION_EVENT, (Object)((TezEvent)event.getInitGeneratedEvents().get(0)).getEventType());
        Assert.assertEquals((long)event.getInitGeneratedEvents().size(), (long)deserializedEvent.getInitGeneratedEvents().size());
        this.logEvents((HistoryEvent)event, (HistoryEvent)deserializedEvent);
    }

    private void testVertexStartedEvent() throws Exception {
        VertexStartedEvent event = new VertexStartedEvent(TezVertexID.getInstance((TezDAGID)TezDAGID.getInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1), (int)111), 145553L, 12334455L);
        VertexStartedEvent deserializedEvent = (VertexStartedEvent)this.testProtoConversion((HistoryEvent)event);
        Assert.assertEquals((Object)event.getVertexID(), (Object)deserializedEvent.getVertexID());
        Assert.assertEquals((long)event.getStartRequestedTime(), (long)deserializedEvent.getStartRequestedTime());
        Assert.assertEquals((long)event.getStartTime(), (long)deserializedEvent.getStartTime());
        this.logEvents((HistoryEvent)event, (HistoryEvent)deserializedEvent);
    }

    private void testVertexReconfigureDoneEvent() throws Exception {
        VertexLocationHint vertexLocationHint = VertexLocationHint.create(new ArrayList());
        InputSpecUpdate rootInputSpecUpdateBulk = InputSpecUpdate.createAllTaskInputSpecUpdate((int)2);
        InputSpecUpdate rootInputSpecUpdatePerTask = InputSpecUpdate.createPerTaskInputSpecUpdate((List)Lists.newArrayList((Object[])new Integer[]{1, 2, 3}));
        HashMap<String, InputSpecUpdate> rootInputSpecUpdates = new HashMap<String, InputSpecUpdate>();
        rootInputSpecUpdates.put("input1", rootInputSpecUpdateBulk);
        rootInputSpecUpdates.put("input2", rootInputSpecUpdatePerTask);
        HashMap<String, EdgeProperty> sourceEdgeManagers = new HashMap<String, EdgeProperty>();
        sourceEdgeManagers.put("foo", EdgeProperty.create((EdgeProperty.DataMovementType)EdgeProperty.DataMovementType.SCATTER_GATHER, (EdgeProperty.DataSourceType)EdgeProperty.DataSourceType.PERSISTED, (EdgeProperty.SchedulingType)EdgeProperty.SchedulingType.SEQUENTIAL, (OutputDescriptor)OutputDescriptor.create((String)"Out1"), (InputDescriptor)InputDescriptor.create((String)"in1")));
        sourceEdgeManagers.put("foo1", EdgeProperty.create((EdgeManagerPluginDescriptor)((EdgeManagerPluginDescriptor)EdgeManagerPluginDescriptor.create((String)"bar1").setUserPayload(UserPayload.create((ByteBuffer)ByteBuffer.wrap(new String("payload").getBytes()), (int)100))), (EdgeProperty.DataSourceType)EdgeProperty.DataSourceType.PERSISTED, (EdgeProperty.SchedulingType)EdgeProperty.SchedulingType.SEQUENTIAL, (OutputDescriptor)OutputDescriptor.create((String)"Out1"), (InputDescriptor)InputDescriptor.create((String)"in1")));
        long reconfigureDoneTime = 100L;
        int numTasks = 2;
        VertexConfigurationDoneEvent event = new VertexConfigurationDoneEvent(TezVertexID.getInstance((TezDAGID)TezDAGID.getInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1), (int)111), 100L, 2, vertexLocationHint, sourceEdgeManagers, rootInputSpecUpdates, true);
        Assert.assertEquals((long)2L, (long)event.getNumTasks());
        Assert.assertEquals((long)100L, (long)event.getReconfigureDoneTime());
        VertexConfigurationDoneEvent deserializedEvent = (VertexConfigurationDoneEvent)this.testProtoConversion((HistoryEvent)event);
        Assert.assertEquals((Object)event.getVertexID(), (Object)deserializedEvent.getVertexID());
        Assert.assertEquals((long)event.getNumTasks(), (long)deserializedEvent.getNumTasks());
        Assert.assertEquals((Object)event.isSetParallelismCalled(), (Object)deserializedEvent.isSetParallelismCalled());
        Assert.assertEquals((Object)event.getVertexLocationHint(), (Object)deserializedEvent.getVertexLocationHint());
        Assert.assertEquals((long)event.getRootInputSpecUpdates().size(), (long)deserializedEvent.getRootInputSpecUpdates().size());
        InputSpecUpdate deserializedBulk = (InputSpecUpdate)deserializedEvent.getRootInputSpecUpdates().get("input1");
        InputSpecUpdate deserializedPerTask = (InputSpecUpdate)deserializedEvent.getRootInputSpecUpdates().get("input2");
        Assert.assertEquals((Object)rootInputSpecUpdateBulk.isForAllWorkUnits(), (Object)deserializedBulk.isForAllWorkUnits());
        Assert.assertEquals((Object)rootInputSpecUpdateBulk.getAllNumPhysicalInputs(), (Object)deserializedBulk.getAllNumPhysicalInputs());
        Assert.assertEquals((Object)rootInputSpecUpdatePerTask.isForAllWorkUnits(), (Object)deserializedPerTask.isForAllWorkUnits());
        Assert.assertEquals((Object)rootInputSpecUpdatePerTask.getAllNumPhysicalInputs(), (Object)deserializedPerTask.getAllNumPhysicalInputs());
        Assert.assertEquals((long)event.getSourceEdgeProperties().size(), (long)deserializedEvent.getSourceEdgeProperties().size());
        Assert.assertEquals((Object)((EdgeProperty)event.getSourceEdgeProperties().get("foo")).getDataMovementType(), (Object)((EdgeProperty)deserializedEvent.getSourceEdgeProperties().get("foo")).getDataMovementType());
        Assert.assertNull((Object)((EdgeProperty)deserializedEvent.getSourceEdgeProperties().get("foo")).getEdgeManagerDescriptor());
        Assert.assertEquals((Object)((EdgeProperty)event.getSourceEdgeProperties().get("foo1")).getDataMovementType(), (Object)((EdgeProperty)deserializedEvent.getSourceEdgeProperties().get("foo1")).getDataMovementType());
        Assert.assertEquals((long)((EdgeProperty)event.getSourceEdgeProperties().get("foo1")).getEdgeManagerDescriptor().getUserPayload().getVersion(), (long)((EdgeProperty)deserializedEvent.getSourceEdgeProperties().get("foo1")).getEdgeManagerDescriptor().getUserPayload().getVersion());
        Assert.assertArrayEquals((byte[])((EdgeProperty)event.getSourceEdgeProperties().get("foo1")).getEdgeManagerDescriptor().getUserPayload().deepCopyAsArray(), (byte[])((EdgeProperty)deserializedEvent.getSourceEdgeProperties().get("foo1")).getEdgeManagerDescriptor().getUserPayload().deepCopyAsArray());
        this.logEvents((HistoryEvent)event, (HistoryEvent)deserializedEvent);
    }

    private void testVertexFinishedEvent() throws Exception {
        VertexFinishedEvent event = new VertexFinishedEvent(TezVertexID.getInstance((TezDAGID)TezDAGID.getInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1), (int)111), "vertex1", 1, 1000L, 15000L, 16000L, 20000L, 1344400L, VertexState.ERROR, null, null, null, null, null);
        VertexFinishedEvent deserializedEvent = (VertexFinishedEvent)this.testProtoConversion((HistoryEvent)event);
        Assert.assertEquals((Object)event.getVertexID(), (Object)deserializedEvent.getVertexID());
        Assert.assertEquals((long)event.getFinishTime(), (long)deserializedEvent.getFinishTime());
        Assert.assertEquals((Object)event.getState(), (Object)deserializedEvent.getState());
        Assert.assertEquals((Object)event.getDiagnostics(), (Object)deserializedEvent.getDiagnostics());
        this.logEvents((HistoryEvent)event, (HistoryEvent)deserializedEvent);
        event = new VertexFinishedEvent(TezVertexID.getInstance((TezDAGID)TezDAGID.getInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1), (int)111), "vertex1", 1, 1000L, 15000L, 16000L, 20000L, 1344400L, VertexState.ERROR, "diagnose", new TezCounters(), new VertexStats(), null, null);
        deserializedEvent = (VertexFinishedEvent)this.testProtoConversion((HistoryEvent)event);
        Assert.assertEquals((Object)event.getVertexID(), (Object)deserializedEvent.getVertexID());
        Assert.assertEquals((long)event.getFinishTime(), (long)deserializedEvent.getFinishTime());
        Assert.assertEquals((Object)event.getState(), (Object)deserializedEvent.getState());
        Assert.assertEquals((Object)event.getDiagnostics(), (Object)deserializedEvent.getDiagnostics());
        this.logEvents((HistoryEvent)event, (HistoryEvent)deserializedEvent);
    }

    private void testTaskStartedEvent() throws Exception {
        TaskStartedEvent event = new TaskStartedEvent(TezTaskID.getInstance((TezVertexID)TezVertexID.getInstance((TezDAGID)TezDAGID.getInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1), (int)111), (int)1), "vertex1", 1000L, 100000L);
        TaskStartedEvent deserializedEvent = (TaskStartedEvent)this.testProtoConversion((HistoryEvent)event);
        Assert.assertEquals((Object)event.getTaskID(), (Object)deserializedEvent.getTaskID());
        Assert.assertEquals((long)event.getScheduledTime(), (long)deserializedEvent.getScheduledTime());
        Assert.assertEquals((long)event.getStartTime(), (long)deserializedEvent.getStartTime());
        this.logEvents((HistoryEvent)event, (HistoryEvent)deserializedEvent);
    }

    private void testTaskFinishedEvent() throws Exception {
        TaskFinishedEvent event = new TaskFinishedEvent(TezTaskID.getInstance((TezVertexID)TezVertexID.getInstance((TezDAGID)TezDAGID.getInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1), (int)111), (int)1), "vertex1", 11000L, 1000000L, null, TaskState.FAILED, null, null, 0);
        TaskFinishedEvent deserializedEvent = (TaskFinishedEvent)this.testProtoConversion((HistoryEvent)event);
        Assert.assertEquals((Object)event.getTaskID(), (Object)deserializedEvent.getTaskID());
        Assert.assertEquals((long)event.getFinishTime(), (long)deserializedEvent.getFinishTime());
        Assert.assertEquals((Object)event.getState(), (Object)deserializedEvent.getState());
        Assert.assertEquals((Object)event.getSuccessfulAttemptID(), (Object)deserializedEvent.getSuccessfulAttemptID());
        Assert.assertEquals((Object)event.getDiagnostics(), (Object)deserializedEvent.getDiagnostics());
        this.logEvents((HistoryEvent)event, (HistoryEvent)deserializedEvent);
        event = new TaskFinishedEvent(TezTaskID.getInstance((TezVertexID)TezVertexID.getInstance((TezDAGID)TezDAGID.getInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1), (int)111), (int)1), "vertex1", 11000L, 1000000L, TezTaskAttemptID.getInstance((TezTaskID)TezTaskID.getInstance((TezVertexID)TezVertexID.getInstance((TezDAGID)TezDAGID.getInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1), (int)111), (int)1), (int)1), TaskState.FAILED, "task_diagnostics", new TezCounters(), 0);
        deserializedEvent = (TaskFinishedEvent)this.testProtoConversion((HistoryEvent)event);
        Assert.assertEquals((Object)event.getTaskID(), (Object)deserializedEvent.getTaskID());
        Assert.assertEquals((long)event.getFinishTime(), (long)deserializedEvent.getFinishTime());
        Assert.assertEquals((Object)event.getState(), (Object)deserializedEvent.getState());
        Assert.assertEquals((Object)event.getSuccessfulAttemptID(), (Object)deserializedEvent.getSuccessfulAttemptID());
        Assert.assertEquals((Object)event.getDiagnostics(), (Object)deserializedEvent.getDiagnostics());
        this.logEvents((HistoryEvent)event, (HistoryEvent)deserializedEvent);
    }

    private void testTaskAttemptStartedEvent() throws Exception {
        TaskAttemptStartedEvent event = new TaskAttemptStartedEvent(TezTaskAttemptID.getInstance((TezTaskID)TezTaskID.getInstance((TezVertexID)TezVertexID.getInstance((TezDAGID)TezDAGID.getInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1), (int)111), (int)1), (int)1), "vertex1", 10009L, ContainerId.newInstance((ApplicationAttemptId)ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1), (int)1001), NodeId.newInstance((String)"host1", (int)19999), "inProgress", "Completed", "nodeHttpAddress");
        TaskAttemptStartedEvent deserializedEvent = (TaskAttemptStartedEvent)this.testProtoConversion((HistoryEvent)event);
        Assert.assertEquals((Object)event.getTaskAttemptID(), (Object)deserializedEvent.getTaskAttemptID());
        Assert.assertEquals((Object)event.getContainerId(), (Object)deserializedEvent.getContainerId());
        Assert.assertEquals((Object)event.getNodeId(), (Object)deserializedEvent.getNodeId());
        this.logEvents((HistoryEvent)event, (HistoryEvent)deserializedEvent);
    }

    private void testTaskAttemptFinishedEvent() throws Exception {
        String[] items;
        TaskAttemptFinishedEvent event = new TaskAttemptFinishedEvent(TezTaskAttemptID.getInstance((TezTaskID)TezTaskID.getInstance((TezVertexID)TezVertexID.getInstance((TezDAGID)TezDAGID.getInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1), (int)111), (int)1), (int)1), "vertex1", 10001L, 1000434444L, TaskAttemptState.FAILED, TaskFailureType.FATAL, null, null, null, null, null, 2048L, TezTaskAttemptID.getInstance((TezTaskID)TezTaskID.getInstance((TezVertexID)TezVertexID.getInstance((TezDAGID)TezDAGID.getInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1), (int)111), (int)1), (int)0), 1024L, ContainerId.newInstance((ApplicationAttemptId)ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1), (int)1001), NodeId.newInstance((String)"host1", (int)19999), "inProgress", "Completed", "nodeHttpAddress");
        TaskAttemptFinishedEvent deserializedEvent = (TaskAttemptFinishedEvent)this.testProtoConversion((HistoryEvent)event);
        Assert.assertEquals((Object)event.getTaskAttemptID(), (Object)deserializedEvent.getTaskAttemptID());
        Assert.assertEquals((long)event.getCreationTime(), (long)deserializedEvent.getCreationTime());
        Assert.assertEquals((long)event.getAllocationTime(), (long)deserializedEvent.getAllocationTime());
        Assert.assertEquals((long)event.getStartTime(), (long)deserializedEvent.getStartTime());
        Assert.assertEquals((long)event.getFinishTime(), (long)deserializedEvent.getFinishTime());
        Assert.assertEquals((Object)event.getCreationCausalTA(), (Object)deserializedEvent.getCreationCausalTA());
        Assert.assertEquals((Object)event.getDiagnostics(), (Object)deserializedEvent.getDiagnostics());
        Assert.assertEquals((Object)event.getState(), (Object)deserializedEvent.getState());
        Assert.assertEquals((Object)event.getCounters(), (Object)deserializedEvent.getCounters());
        Assert.assertEquals((Object)event.getContainerId(), (Object)deserializedEvent.getContainerId());
        Assert.assertEquals((Object)event.getNodeId(), (Object)deserializedEvent.getNodeId());
        Assert.assertEquals((Object)event.getNodeHttpAddress(), (Object)deserializedEvent.getNodeHttpAddress());
        Assert.assertEquals((Object)event.getTaskFailureType(), (Object)deserializedEvent.getTaskFailureType());
        this.logEvents((HistoryEvent)event, (HistoryEvent)deserializedEvent);
        TezTaskAttemptID taId = TezTaskAttemptID.getInstance((TezTaskID)TezTaskID.getInstance((TezVertexID)TezVertexID.getInstance((TezDAGID)TezDAGID.getInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1), (int)111), (int)0), (int)0);
        long timestamp = 1024L;
        ArrayList events = Lists.newArrayList();
        events.add(new TaskAttemptImpl.DataEventDependencyInfo(timestamp, taId));
        events.add(new TaskAttemptImpl.DataEventDependencyInfo(timestamp, taId));
        TaskAttemptFinishedEvent event2 = new TaskAttemptFinishedEvent(TezTaskAttemptID.getInstance((TezTaskID)TezTaskID.getInstance((TezVertexID)TezVertexID.getInstance((TezDAGID)TezDAGID.getInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1), (int)111), (int)1), (int)1), "vertex1", 10001L, 1000434444L, TaskAttemptState.FAILED, TaskFailureType.NON_FATAL, TaskAttemptTerminationCause.APPLICATION_ERROR, "diagnose", new TezCounters(), (List)events, null, 0L, null, 0L, ContainerId.newInstance((ApplicationAttemptId)ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1), (int)1001), NodeId.newInstance((String)"host1", (int)19999), "inProgress", "Completed", "nodeHttpAddress");
        TaskAttemptFinishedEvent deserializedEvent2 = (TaskAttemptFinishedEvent)this.testProtoConversion((HistoryEvent)event2);
        Assert.assertEquals((Object)event2.getTaskAttemptID(), (Object)deserializedEvent2.getTaskAttemptID());
        Assert.assertEquals((long)event2.getFinishTime(), (long)deserializedEvent2.getFinishTime());
        Assert.assertEquals((Object)event2.getDiagnostics(), (Object)deserializedEvent2.getDiagnostics());
        Assert.assertEquals((Object)event2.getState(), (Object)deserializedEvent2.getState());
        Assert.assertEquals((Object)event2.getCounters(), (Object)deserializedEvent2.getCounters());
        Assert.assertEquals((Object)event2.getContainerId(), (Object)deserializedEvent2.getContainerId());
        Assert.assertEquals((Object)event2.getNodeId(), (Object)deserializedEvent2.getNodeId());
        Assert.assertEquals((Object)event2.getNodeHttpAddress(), (Object)deserializedEvent2.getNodeHttpAddress());
        Assert.assertEquals((Object)event2.getTaskAttemptError(), (Object)deserializedEvent2.getTaskAttemptError());
        Assert.assertEquals((long)events.size(), (long)event2.getDataEvents().size());
        Assert.assertEquals((long)((TaskAttemptImpl.DataEventDependencyInfo)events.get(0)).getTimestamp(), (long)((TaskAttemptImpl.DataEventDependencyInfo)event2.getDataEvents().get(0)).getTimestamp());
        Assert.assertEquals((Object)((TaskAttemptImpl.DataEventDependencyInfo)events.get(0)).getTaskAttemptId(), (Object)((TaskAttemptImpl.DataEventDependencyInfo)event2.getDataEvents().get(0)).getTaskAttemptId());
        Assert.assertEquals((Object)event2.getTaskFailureType(), (Object)deserializedEvent2.getTaskFailureType());
        this.logEvents((HistoryEvent)event2, (HistoryEvent)deserializedEvent2);
        taId = TezTaskAttemptID.getInstance((TezTaskID)TezTaskID.getInstance((TezVertexID)TezVertexID.getInstance((TezDAGID)TezDAGID.getInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1), (int)111), (int)0), (int)0);
        timestamp = 1024L;
        events = Lists.newArrayList();
        events.add(new TaskAttemptImpl.DataEventDependencyInfo(timestamp, taId));
        events.add(new TaskAttemptImpl.DataEventDependencyInfo(timestamp, taId));
        event2 = new TaskAttemptFinishedEvent(TezTaskAttemptID.getInstance((TezTaskID)TezTaskID.getInstance((TezVertexID)TezVertexID.getInstance((TezDAGID)TezDAGID.getInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1), (int)111), (int)1), (int)1), "vertex1", 10001L, 1000434444L, TaskAttemptState.KILLED, null, TaskAttemptTerminationCause.APPLICATION_ERROR, "diagnose", new TezCounters(), (List)events, null, 0L, null, 0L, ContainerId.newInstance((ApplicationAttemptId)ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1), (int)1001), NodeId.newInstance((String)"host1", (int)19999), "inProgress", "Completed", "nodeHttpAddress");
        deserializedEvent2 = (TaskAttemptFinishedEvent)this.testProtoConversion((HistoryEvent)event2);
        Assert.assertEquals((Object)event2.getTaskAttemptID(), (Object)deserializedEvent2.getTaskAttemptID());
        Assert.assertEquals((long)event2.getFinishTime(), (long)deserializedEvent2.getFinishTime());
        Assert.assertEquals((Object)event2.getDiagnostics(), (Object)deserializedEvent2.getDiagnostics());
        Assert.assertEquals((Object)event2.getState(), (Object)deserializedEvent2.getState());
        Assert.assertEquals((Object)event2.getCounters(), (Object)deserializedEvent2.getCounters());
        Assert.assertEquals((Object)event2.getContainerId(), (Object)deserializedEvent2.getContainerId());
        Assert.assertEquals((Object)event2.getNodeId(), (Object)deserializedEvent2.getNodeId());
        Assert.assertEquals((Object)event2.getNodeHttpAddress(), (Object)deserializedEvent2.getNodeHttpAddress());
        Assert.assertEquals((Object)event2.getTaskAttemptError(), (Object)deserializedEvent2.getTaskAttemptError());
        Assert.assertEquals((long)events.size(), (long)event2.getDataEvents().size());
        Assert.assertEquals((long)((TaskAttemptImpl.DataEventDependencyInfo)events.get(0)).getTimestamp(), (long)((TaskAttemptImpl.DataEventDependencyInfo)event2.getDataEvents().get(0)).getTimestamp());
        Assert.assertEquals((Object)((TaskAttemptImpl.DataEventDependencyInfo)events.get(0)).getTaskAttemptId(), (Object)((TaskAttemptImpl.DataEventDependencyInfo)event2.getDataEvents().get(0)).getTaskAttemptId());
        Assert.assertEquals((Object)event2.getTaskFailureType(), (Object)deserializedEvent2.getTaskFailureType());
        this.logEvents((HistoryEvent)event2, (HistoryEvent)deserializedEvent2);
        taId = TezTaskAttemptID.getInstance((TezTaskID)TezTaskID.getInstance((TezVertexID)TezVertexID.getInstance((TezDAGID)TezDAGID.getInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1), (int)111), (int)0), (int)0);
        timestamp = 1024L;
        events = Lists.newArrayList();
        events.add(new TaskAttemptImpl.DataEventDependencyInfo(timestamp, taId));
        events.add(new TaskAttemptImpl.DataEventDependencyInfo(timestamp, taId));
        event2 = new TaskAttemptFinishedEvent(TezTaskAttemptID.getInstance((TezTaskID)TezTaskID.getInstance((TezVertexID)TezVertexID.getInstance((TezDAGID)TezDAGID.getInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1), (int)111), (int)1), (int)1), "vertex1", 10001L, 1000434444L, TaskAttemptState.SUCCEEDED, null, null, null, new TezCounters(), (List)events, null, 0L, null, 0L, null, null, null, null, null);
        String eventStr = event2.toString();
        for (String item : items = new String[]{"taskFailureType", "errorEnum", "diagnostics", "containerId", "nodeId", "nodeHttpAddress"}) {
            Assert.assertFalse((boolean)eventStr.contains(item));
        }
    }

    private void testContainerLaunchedEvent() throws Exception {
        ContainerLaunchedEvent event = new ContainerLaunchedEvent(ContainerId.newInstance((ApplicationAttemptId)ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1), (int)1001), 100034566L, ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1));
        ContainerLaunchedEvent deserializedEvent = (ContainerLaunchedEvent)this.testProtoConversion((HistoryEvent)event);
        Assert.assertEquals((Object)event.getContainerId(), (Object)deserializedEvent.getContainerId());
        Assert.assertEquals((long)event.getLaunchTime(), (long)deserializedEvent.getLaunchTime());
        Assert.assertEquals((Object)event.getApplicationAttemptId(), (Object)deserializedEvent.getApplicationAttemptId());
        this.logEvents((HistoryEvent)event, (HistoryEvent)deserializedEvent);
    }

    private void testContainerStoppedEvent() throws Exception {
        ContainerStoppedEvent event = new ContainerStoppedEvent(ContainerId.newInstance((ApplicationAttemptId)ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1), (int)1001), 100034566L, 0, ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1));
        ContainerStoppedEvent deserializedEvent = (ContainerStoppedEvent)this.testProtoConversion((HistoryEvent)event);
        Assert.assertEquals((Object)event.getContainerId(), (Object)deserializedEvent.getContainerId());
        Assert.assertEquals((long)event.getStoppedTime(), (long)deserializedEvent.getStoppedTime());
        Assert.assertEquals((Object)event.getApplicationAttemptId(), (Object)deserializedEvent.getApplicationAttemptId());
        this.logEvents((HistoryEvent)event, (HistoryEvent)deserializedEvent);
    }

    private void testDAGCommitStartedEvent() throws Exception {
        DAGCommitStartedEvent event = new DAGCommitStartedEvent(TezDAGID.getInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1), 100L);
        DAGCommitStartedEvent deserializedEvent = (DAGCommitStartedEvent)this.testProtoConversion((HistoryEvent)event);
        Assert.assertEquals((Object)event.getDagID(), (Object)deserializedEvent.getDagID());
        this.logEvents((HistoryEvent)event, (HistoryEvent)deserializedEvent);
    }

    private void testVertexCommitStartedEvent() throws Exception {
        VertexCommitStartedEvent event = new VertexCommitStartedEvent(TezVertexID.getInstance((TezDAGID)TezDAGID.getInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1), (int)1), 100L);
        VertexCommitStartedEvent deserializedEvent = (VertexCommitStartedEvent)this.testProtoConversion((HistoryEvent)event);
        Assert.assertEquals((Object)event.getVertexID(), (Object)deserializedEvent.getVertexID());
        this.logEvents((HistoryEvent)event, (HistoryEvent)deserializedEvent);
    }

    private void testVertexGroupCommitStartedEvent() throws Exception {
        TezVertexID vertexId1 = TezVertexID.getInstance((TezDAGID)TezDAGID.getInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)0), (int)1);
        TezVertexID vertexId2 = TezVertexID.getInstance((TezDAGID)TezDAGID.getInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)0), (int)2);
        ArrayList vertexIds = Lists.newArrayList((Object[])new TezVertexID[]{vertexId1, vertexId2});
        VertexGroupCommitStartedEvent event = new VertexGroupCommitStartedEvent(TezDAGID.getInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1), "fooGroup", (Collection)vertexIds, 1000344L);
        VertexGroupCommitStartedEvent deserializedEvent = (VertexGroupCommitStartedEvent)this.testProtoConversion((HistoryEvent)event);
        Assert.assertEquals((Object)event.getDagID(), (Object)deserializedEvent.getDagID());
        Assert.assertEquals((Object)event.getVertexGroupName(), (Object)deserializedEvent.getVertexGroupName());
        Assert.assertEquals((Object)event.getVertexIds(), (Object)vertexIds);
        this.logEvents((HistoryEvent)event, (HistoryEvent)deserializedEvent);
        deserializedEvent = (VertexGroupCommitStartedEvent)this.testSummaryProtoConversion((HistoryEvent)event);
        Assert.assertEquals((Object)event.getVertexGroupName(), (Object)deserializedEvent.getVertexGroupName());
        this.logEvents((HistoryEvent)event, (HistoryEvent)deserializedEvent);
    }

    private void testVertexGroupCommitFinishedEvent() throws Exception {
        TezVertexID vertexId1 = TezVertexID.getInstance((TezDAGID)TezDAGID.getInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)0), (int)1);
        TezVertexID vertexId2 = TezVertexID.getInstance((TezDAGID)TezDAGID.getInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)0), (int)2);
        ArrayList vertexIds = Lists.newArrayList((Object[])new TezVertexID[]{vertexId1, vertexId2});
        VertexGroupCommitFinishedEvent event = new VertexGroupCommitFinishedEvent(TezDAGID.getInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1), "fooGroup", (Collection)vertexIds, 1000344L);
        VertexGroupCommitFinishedEvent deserializedEvent = (VertexGroupCommitFinishedEvent)this.testProtoConversion((HistoryEvent)event);
        Assert.assertEquals((Object)event.getDagID(), (Object)deserializedEvent.getDagID());
        Assert.assertEquals((Object)event.getVertexGroupName(), (Object)deserializedEvent.getVertexGroupName());
        Assert.assertEquals((Object)event.getVertexIds(), (Object)vertexIds);
        this.logEvents((HistoryEvent)event, (HistoryEvent)deserializedEvent);
        deserializedEvent = (VertexGroupCommitFinishedEvent)this.testSummaryProtoConversion((HistoryEvent)event);
        Assert.assertEquals((Object)event.getVertexGroupName(), (Object)deserializedEvent.getVertexGroupName());
        this.logEvents((HistoryEvent)event, (HistoryEvent)deserializedEvent);
    }

    @Test
    public void testDefaultProtoConversion() throws Exception {
        block25: for (HistoryEventType eventType : HistoryEventType.values()) {
            switch (eventType) {
                case APP_LAUNCHED: {
                    this.testAppLaunchedEvent();
                    continue block25;
                }
                case AM_LAUNCHED: {
                    this.testAMLaunchedEvent();
                    continue block25;
                }
                case AM_STARTED: {
                    this.testAMStartedEvent();
                    continue block25;
                }
                case DAG_SUBMITTED: {
                    this.testDAGSubmittedEvent();
                    continue block25;
                }
                case DAG_INITIALIZED: {
                    this.testDAGInitializedEvent();
                    continue block25;
                }
                case DAG_STARTED: {
                    this.testDAGStartedEvent();
                    continue block25;
                }
                case DAG_FINISHED: {
                    this.testDAGFinishedEvent();
                    continue block25;
                }
                case VERTEX_INITIALIZED: {
                    this.testVertexInitializedEvent();
                    continue block25;
                }
                case VERTEX_STARTED: {
                    this.testVertexStartedEvent();
                    continue block25;
                }
                case VERTEX_CONFIGURE_DONE: {
                    this.testVertexReconfigureDoneEvent();
                    continue block25;
                }
                case VERTEX_FINISHED: {
                    this.testVertexFinishedEvent();
                    continue block25;
                }
                case TASK_STARTED: {
                    this.testTaskStartedEvent();
                    continue block25;
                }
                case TASK_FINISHED: {
                    this.testTaskFinishedEvent();
                    continue block25;
                }
                case TASK_ATTEMPT_STARTED: {
                    this.testTaskAttemptStartedEvent();
                    continue block25;
                }
                case TASK_ATTEMPT_FINISHED: {
                    this.testTaskAttemptFinishedEvent();
                    continue block25;
                }
                case CONTAINER_LAUNCHED: {
                    this.testContainerLaunchedEvent();
                    continue block25;
                }
                case CONTAINER_STOPPED: {
                    this.testContainerStoppedEvent();
                    continue block25;
                }
                case DAG_COMMIT_STARTED: {
                    this.testDAGCommitStartedEvent();
                    continue block25;
                }
                case VERTEX_COMMIT_STARTED: {
                    this.testVertexCommitStartedEvent();
                    continue block25;
                }
                case VERTEX_GROUP_COMMIT_STARTED: {
                    this.testVertexGroupCommitStartedEvent();
                    continue block25;
                }
                case VERTEX_GROUP_COMMIT_FINISHED: {
                    this.testVertexGroupCommitFinishedEvent();
                    continue block25;
                }
                case DAG_RECOVERED: {
                    this.testDAGRecoveredEvent();
                    continue block25;
                }
                case DAG_KILL_REQUEST: {
                    this.testDAGKillRequestEvent();
                    continue block25;
                }
                default: {
                    throw new Exception("Unhandled Event type in Unit tests: " + eventType);
                }
            }
        }
    }

    private void testDAGRecoveredEvent() throws TezException {
        DAGRecoveredEvent dagRecoveredEvent = new DAGRecoveredEvent(ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1), TezDAGID.getInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1), "mockDagname", "mockuser", 100334L, null);
        try {
            this.testProtoConversion((HistoryEvent)dagRecoveredEvent);
            Assert.fail((String)"Proto conversion should have failed");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
        }
        catch (IOException e) {
            Assert.fail((String)"Proto conversion should have failed with Unsupported Exception");
        }
    }
}

