/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.rm;

import java.util.Collection;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.client.api.AMRMClient;
import org.apache.hadoop.yarn.client.api.async.AMRMClientAsync;
import org.apache.hadoop.yarn.client.api.impl.AMRMClientImpl;
import org.apache.hadoop.yarn.util.RackResolver;
import org.apache.tez.common.MockDNSToSwitchMapping;
import org.apache.tez.dag.app.rm.TezAMRMClientAsync;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;

public class TestTezAMRMClient {
    private TezAMRMClientAsync amrmClient;

    @BeforeClass
    public static void beforeClass() {
        MockDNSToSwitchMapping.initializeMockRackResolver();
    }

    @Before
    public void setup() {
        this.amrmClient = new TezAMRMClientAsync((AMRMClient)new AMRMClientImpl(), 1000, (AMRMClientAsync.CallbackHandler)Mockito.mock(AMRMClientAsync.CallbackHandler.class));
        RackResolver.init((Configuration)new Configuration());
    }

    @After
    public void teardown() {
        this.amrmClient = null;
    }

    @Test(timeout=10000L)
    public void testMatchingRequestsForTopPriority() {
        String[] hosts = new String[]{"host1"};
        String[] racks = new String[]{"rack1"};
        AMRMClient.ContainerRequest req1 = new AMRMClient.ContainerRequest(Resource.newInstance((int)2048, (int)1), hosts, racks, Priority.newInstance((int)1));
        AMRMClient.ContainerRequest req2 = new AMRMClient.ContainerRequest(Resource.newInstance((int)1024, (int)1), hosts, racks, Priority.newInstance((int)2));
        AMRMClient.ContainerRequest req3 = new AMRMClient.ContainerRequest(Resource.newInstance((int)1024, (int)1), hosts, racks, Priority.newInstance((int)3));
        this.amrmClient.addContainerRequest(req1);
        this.amrmClient.addContainerRequest(req2);
        this.amrmClient.addContainerRequest(req3);
        Assert.assertTrue((boolean)this.amrmClient.getMatchingRequestsForTopPriority("host1", Resource.newInstance((int)1024, (int)1)).isEmpty());
        List ret = this.amrmClient.getMatchingRequestsForTopPriority("host1", Resource.newInstance((int)2048, (int)1));
        Assert.assertFalse((boolean)ret.isEmpty());
        Assert.assertEquals((Object)req1, ((Collection)ret.get(0)).iterator().next());
        this.amrmClient.removeContainerRequest(req1);
        ret = this.amrmClient.getMatchingRequestsForTopPriority("host1", Resource.newInstance((int)1024, (int)1));
        Assert.assertFalse((boolean)ret.isEmpty());
        Assert.assertEquals((Object)req2, ((Collection)ret.get(0)).iterator().next());
    }
}

