/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.tez.common.ContainerContext;
import org.apache.tez.common.ContainerTask;
import org.apache.tez.common.TezTaskUmbilicalProtocol;
import org.apache.tez.common.TezUtils;
import org.apache.tez.common.security.JobTokenIdentifier;
import org.apache.tez.common.security.JobTokenSecretManager;
import org.apache.tez.common.security.TokenCache;
import org.apache.tez.dag.api.NamedEntityDescriptor;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.dag.api.TezConstants;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.dag.app.AppContext;
import org.apache.tez.dag.app.ContainerHeartbeatHandler;
import org.apache.tez.dag.app.MockClock;
import org.apache.tez.dag.app.TaskAttemptEventInfo;
import org.apache.tez.dag.app.TaskCommunicatorManager;
import org.apache.tez.dag.app.TaskHeartbeatHandler;
import org.apache.tez.dag.app.TezTaskCommunicatorImpl;
import org.apache.tez.dag.app.dag.DAG;
import org.apache.tez.dag.app.dag.Vertex;
import org.apache.tez.dag.app.dag.event.TaskAttemptEvent;
import org.apache.tez.dag.app.dag.event.TaskAttemptEventStatusUpdate;
import org.apache.tez.dag.app.dag.event.TaskAttemptEventTezEventUpdate;
import org.apache.tez.dag.app.dag.event.TaskAttemptEventType;
import org.apache.tez.dag.app.dag.event.VertexEventRouteEvent;
import org.apache.tez.dag.app.dag.event.VertexEventType;
import org.apache.tez.dag.app.rm.container.AMContainer;
import org.apache.tez.dag.app.rm.container.AMContainerMap;
import org.apache.tez.dag.app.rm.container.AMContainerTask;
import org.apache.tez.dag.records.TezDAGID;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.dag.records.TezTaskID;
import org.apache.tez.dag.records.TezVertexID;
import org.apache.tez.runtime.api.events.DataMovementEvent;
import org.apache.tez.runtime.api.events.InputReadErrorEvent;
import org.apache.tez.runtime.api.events.TaskAttemptCompletedEvent;
import org.apache.tez.runtime.api.events.TaskStatusUpdateEvent;
import org.apache.tez.runtime.api.impl.EventMetaData;
import org.apache.tez.runtime.api.impl.EventType;
import org.apache.tez.runtime.api.impl.TaskSpec;
import org.apache.tez.runtime.api.impl.TezEvent;
import org.apache.tez.serviceplugins.api.ContainerEndReason;
import org.apache.tez.serviceplugins.api.TaskAttemptEndReason;
import org.apache.tez.serviceplugins.api.TaskCommunicator;
import org.apache.tez.serviceplugins.api.TaskCommunicatorContext;
import org.apache.tez.serviceplugins.api.TaskHeartbeatRequest;
import org.apache.tez.serviceplugins.api.TaskHeartbeatResponse;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestTaskCommunicatorManager1 {
    private ApplicationId appId;
    private ApplicationAttemptId appAttemptId;
    private AppContext appContext;
    Credentials credentials;
    AMContainerMap amContainerMap;
    EventHandler eventHandler;
    DAG dag;
    TaskCommunicatorManager taskAttemptListener;
    ContainerTask containerTask;
    AMContainerTask amContainerTask;
    TaskSpec taskSpec;
    TezVertexID vertexID;
    TezTaskID taskID;
    TezTaskAttemptID taskAttemptID;

    @Before
    public void setUp() throws TezException {
        UserPayload defaultPayload;
        this.appId = ApplicationId.newInstance((long)1000L, (int)1);
        this.appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)this.appId, (int)1);
        this.dag = (DAG)Mockito.mock(DAG.class);
        TezDAGID dagID = TezDAGID.getInstance((ApplicationId)this.appId, (int)1);
        this.vertexID = TezVertexID.getInstance((TezDAGID)dagID, (int)1);
        this.taskID = TezTaskID.getInstance((TezVertexID)this.vertexID, (int)1);
        this.taskAttemptID = TezTaskAttemptID.getInstance((TezTaskID)this.taskID, (int)1);
        this.credentials = new Credentials();
        this.amContainerMap = (AMContainerMap)Mockito.mock(AMContainerMap.class);
        HashMap appAcls = new HashMap();
        this.eventHandler = (EventHandler)Mockito.mock(EventHandler.class);
        MockClock clock = new MockClock();
        this.appContext = (AppContext)Mockito.mock(AppContext.class);
        ((AppContext)Mockito.doReturn((Object)this.eventHandler).when((Object)this.appContext)).getEventHandler();
        ((AppContext)Mockito.doReturn((Object)this.dag).when((Object)this.appContext)).getCurrentDAG();
        ((AppContext)Mockito.doReturn(appAcls).when((Object)this.appContext)).getApplicationACLs();
        ((AppContext)Mockito.doReturn((Object)this.amContainerMap).when((Object)this.appContext)).getAllContainers();
        ((AppContext)Mockito.doReturn((Object)clock).when((Object)this.appContext)).getClock();
        ((AppContext)Mockito.doReturn((Object)this.appAttemptId).when((Object)this.appContext)).getApplicationAttemptId();
        ((AppContext)Mockito.doReturn((Object)this.credentials).when((Object)this.appContext)).getAppCredentials();
        NodeId nodeId = NodeId.newInstance((String)"localhost", (int)0);
        AMContainer amContainer = (AMContainer)Mockito.mock(AMContainer.class);
        Container container = (Container)Mockito.mock(Container.class);
        ((Container)Mockito.doReturn((Object)nodeId).when((Object)container)).getNodeId();
        ((AMContainerMap)Mockito.doReturn((Object)amContainer).when((Object)this.amContainerMap)).get((ContainerId)Mockito.any());
        ((AMContainer)Mockito.doReturn((Object)container).when((Object)amContainer)).getContainer();
        TezConfiguration conf = new TezConfiguration();
        try {
            defaultPayload = TezUtils.createUserPayloadFromConf((Configuration)conf);
        }
        catch (IOException e) {
            throw new TezUncheckedException((Throwable)e);
        }
        this.taskAttemptListener = new TaskCommunicatorManagerInterfaceImplForTest(this.appContext, (TaskHeartbeatHandler)Mockito.mock(TaskHeartbeatHandler.class), (ContainerHeartbeatHandler)Mockito.mock(ContainerHeartbeatHandler.class), Lists.newArrayList((Object[])new NamedEntityDescriptor[]{new NamedEntityDescriptor(TezConstants.getTezYarnServicePluginName(), null).setUserPayload(defaultPayload)}));
        this.taskSpec = (TaskSpec)Mockito.mock(TaskSpec.class);
        ((TaskSpec)Mockito.doReturn((Object)this.taskAttemptID).when((Object)this.taskSpec)).getTaskAttemptID();
        this.amContainerTask = new AMContainerTask(this.taskSpec, null, null, false, 0);
        this.containerTask = null;
    }

    @Test(timeout=5000L)
    public void testGetTask() throws IOException {
        TezTaskCommunicatorImpl taskCommunicator = (TezTaskCommunicatorImpl)this.taskAttemptListener.getTaskCommunicator(0).getTaskCommunicator();
        TezTaskUmbilicalProtocol tezUmbilical = taskCommunicator.getUmbilical();
        ContainerId containerId1 = this.createContainerId(this.appId, 1);
        ContainerContext containerContext1 = new ContainerContext(containerId1.toString());
        this.containerTask = tezUmbilical.getTask(containerContext1);
        Assert.assertTrue((boolean)this.containerTask.shouldDie());
        ContainerId containerId2 = this.createContainerId(this.appId, 2);
        ContainerContext containerContext2 = new ContainerContext(containerId2.toString());
        this.taskAttemptListener.registerRunningContainer(containerId2, 0);
        this.containerTask = tezUmbilical.getTask(containerContext2);
        Assert.assertNull((Object)this.containerTask);
        this.taskAttemptListener.registerTaskAttempt(this.amContainerTask, containerId2, 0);
        this.containerTask = tezUmbilical.getTask(containerContext2);
        Assert.assertFalse((boolean)this.containerTask.shouldDie());
        Assert.assertEquals((Object)this.taskSpec, (Object)this.containerTask.getTaskSpec());
        this.taskAttemptListener.unregisterTaskAttempt(this.taskAttemptID, 0, TaskAttemptEndReason.OTHER, null);
        this.containerTask = tezUmbilical.getTask(containerContext2);
        Assert.assertNull((Object)this.containerTask);
        this.taskAttemptListener.unregisterRunningContainer(containerId2, 0, ContainerEndReason.OTHER, null);
        this.containerTask = tezUmbilical.getTask(containerContext2);
        Assert.assertTrue((boolean)this.containerTask.shouldDie());
        ContainerId containerId3 = this.createContainerId(this.appId, 3);
        ContainerContext containerContext3 = new ContainerContext(containerId3.toString());
        this.taskAttemptListener.registerRunningContainer(containerId3, 0);
        TaskSpec taskSpec2 = (TaskSpec)Mockito.mock(TaskSpec.class);
        TezTaskAttemptID taskAttemptId2 = (TezTaskAttemptID)Mockito.mock(TezTaskAttemptID.class);
        ((TaskSpec)Mockito.doReturn((Object)taskAttemptId2).when((Object)taskSpec2)).getTaskAttemptID();
        AMContainerTask amContainerTask2 = new AMContainerTask(this.taskSpec, null, null, false, 0);
        this.taskAttemptListener.registerTaskAttempt(amContainerTask2, containerId3, 0);
        this.taskAttemptListener.unregisterRunningContainer(containerId3, 0, ContainerEndReason.OTHER, null);
        this.containerTask = tezUmbilical.getTask(containerContext3);
        Assert.assertTrue((boolean)this.containerTask.shouldDie());
    }

    @Test(timeout=5000L)
    public void testGetTaskMultiplePulls() throws IOException {
        TezTaskCommunicatorImpl taskCommunicator = (TezTaskCommunicatorImpl)this.taskAttemptListener.getTaskCommunicator(0).getTaskCommunicator();
        TezTaskUmbilicalProtocol tezUmbilical = taskCommunicator.getUmbilical();
        ContainerId containerId1 = this.createContainerId(this.appId, 1);
        ContainerContext containerContext1 = new ContainerContext(containerId1.toString());
        this.taskAttemptListener.registerRunningContainer(containerId1, 0);
        this.containerTask = tezUmbilical.getTask(containerContext1);
        Assert.assertNull((Object)this.containerTask);
        this.taskAttemptListener.registerTaskAttempt(this.amContainerTask, containerId1, 0);
        this.containerTask = tezUmbilical.getTask(containerContext1);
        Assert.assertFalse((boolean)this.containerTask.shouldDie());
        Assert.assertEquals((Object)this.taskSpec, (Object)this.containerTask.getTaskSpec());
        this.containerTask = tezUmbilical.getTask(containerContext1);
        Assert.assertNull((Object)this.containerTask);
    }

    @Test(timeout=5000L)
    public void testTaskEventRouting() throws Exception {
        List<TezEvent> events = Arrays.asList(new TezEvent((org.apache.tez.runtime.api.Event)new TaskStatusUpdateEvent(null, 0.0f, null, false), new EventMetaData(EventMetaData.EventProducerConsumerType.PROCESSOR, "v1", "v2", this.taskAttemptID)), new TezEvent((org.apache.tez.runtime.api.Event)DataMovementEvent.create((int)0, (ByteBuffer)ByteBuffer.wrap(new byte[0])), new EventMetaData(EventMetaData.EventProducerConsumerType.OUTPUT, "v1", "v2", this.taskAttemptID)), new TezEvent((org.apache.tez.runtime.api.Event)new TaskAttemptCompletedEvent(), new EventMetaData(EventMetaData.EventProducerConsumerType.SYSTEM, "v1", "v2", this.taskAttemptID)));
        this.generateHeartbeat(events, 0, 1, 0, new ArrayList<TezEvent>());
        ArgumentCaptor arg = ArgumentCaptor.forClass(Event.class);
        ((EventHandler)Mockito.verify((Object)this.eventHandler, (VerificationMode)Mockito.times((int)4))).handle((Event)arg.capture());
        List argAllValues = arg.getAllValues();
        Event statusUpdateEvent = (Event)argAllValues.get(0);
        Assert.assertEquals((String)"First event should be status update", (Object)TaskAttemptEventType.TA_STATUS_UPDATE, (Object)statusUpdateEvent.getType());
        Assert.assertEquals((Object)false, (Object)((TaskAttemptEventStatusUpdate)statusUpdateEvent).getReadErrorReported());
        TaskAttemptEventTezEventUpdate taEvent = (TaskAttemptEventTezEventUpdate)argAllValues.get(1);
        Assert.assertEquals((long)1L, (long)taEvent.getTezEvents().size());
        Assert.assertEquals((Object)EventType.DATA_MOVEMENT_EVENT, (Object)((TezEvent)taEvent.getTezEvents().get(0)).getEventType());
        TaskAttemptEvent taCompleteEvent = (TaskAttemptEvent)argAllValues.get(2);
        Assert.assertEquals((Object)TaskAttemptEventType.TA_DONE, (Object)taCompleteEvent.getType());
        VertexEventRouteEvent vertexRouteEvent = (VertexEventRouteEvent)argAllValues.get(3);
        Assert.assertEquals((long)1L, (long)vertexRouteEvent.getEvents().size());
        Assert.assertEquals((Object)EventType.DATA_MOVEMENT_EVENT, (Object)((TezEvent)vertexRouteEvent.getEvents().get(0)).getEventType());
    }

    @Test(timeout=5000L)
    public void testTaskEventRoutingWithReadError() throws Exception {
        List<TezEvent> events = Arrays.asList(new TezEvent((org.apache.tez.runtime.api.Event)new TaskStatusUpdateEvent(null, 0.0f, null, false), null), new TezEvent((org.apache.tez.runtime.api.Event)InputReadErrorEvent.create((String)"", (int)0, (int)0), new EventMetaData(EventMetaData.EventProducerConsumerType.INPUT, "v2", "v1", this.taskAttemptID)), new TezEvent((org.apache.tez.runtime.api.Event)new TaskAttemptCompletedEvent(), new EventMetaData(EventMetaData.EventProducerConsumerType.SYSTEM, "v1", "v2", this.taskAttemptID)));
        this.generateHeartbeat(events, 0, 1, 0, new ArrayList<TezEvent>());
        ArgumentCaptor arg = ArgumentCaptor.forClass(Event.class);
        ((EventHandler)Mockito.verify((Object)this.eventHandler, (VerificationMode)Mockito.times((int)3))).handle((Event)arg.capture());
        List argAllValues = arg.getAllValues();
        Event statusUpdateEvent = (Event)argAllValues.get(0);
        Assert.assertEquals((String)"First event should be status update", (Object)TaskAttemptEventType.TA_STATUS_UPDATE, (Object)statusUpdateEvent.getType());
        Assert.assertEquals((Object)true, (Object)((TaskAttemptEventStatusUpdate)statusUpdateEvent).getReadErrorReported());
        Event taFinishedEvent = (Event)argAllValues.get(1);
        Assert.assertEquals((String)"Second event should be TA_DONE", (Object)TaskAttemptEventType.TA_DONE, (Object)taFinishedEvent.getType());
        Event vertexEvent = (Event)argAllValues.get(2);
        VertexEventRouteEvent vertexRouteEvent = (VertexEventRouteEvent)vertexEvent;
        Assert.assertEquals((String)"Third event should be routed to vertex", (Object)VertexEventType.V_ROUTE_EVENT, (Object)vertexEvent.getType());
        Assert.assertEquals((Object)EventType.INPUT_READ_ERROR_EVENT, (Object)((TezEvent)vertexRouteEvent.getEvents().get(0)).getEventType());
    }

    @Test(timeout=5000L)
    public void testTaskEventRoutingTaskAttemptOnly() throws Exception {
        List<TezEvent> events = Arrays.asList(new TezEvent((org.apache.tez.runtime.api.Event)new TaskAttemptCompletedEvent(), new EventMetaData(EventMetaData.EventProducerConsumerType.SYSTEM, "v1", "v2", this.taskAttemptID)));
        this.generateHeartbeat(events, 0, 1, 0, new ArrayList<TezEvent>());
        ArgumentCaptor arg = ArgumentCaptor.forClass(Event.class);
        ((EventHandler)Mockito.verify((Object)this.eventHandler, (VerificationMode)Mockito.times((int)1))).handle((Event)arg.capture());
        List argAllValues = arg.getAllValues();
        Event event = (Event)argAllValues.get(0);
        Assert.assertEquals((String)"only event should be route event", (Object)TaskAttemptEventType.TA_DONE, (Object)event.getType());
    }

    @Test(timeout=5000L)
    public void testTaskHeartbeatResponse() throws Exception {
        ArrayList<TezEvent> events = new ArrayList<TezEvent>();
        ArrayList<TezEvent> eventsToSend = new ArrayList<TezEvent>();
        TaskHeartbeatResponse response = this.generateHeartbeat(events, 0, 1, 2, eventsToSend);
        Assert.assertEquals((long)2L, (long)response.getNextFromEventId());
        Assert.assertEquals(eventsToSend, (Object)response.getEvents());
    }

    @Test(timeout=5000L)
    public void testPortRange() {
        boolean succeedToAllocate = false;
        Random rand = new Random();
        for (int i = 0; i < 10; ++i) {
            int nextPort = 1024 + rand.nextInt(64511);
            if (!this.testPortRange(nextPort)) continue;
            succeedToAllocate = true;
            break;
        }
        if (!succeedToAllocate) {
            Assert.fail((String)"Can not allocate free port even in 10 iterations for TaskAttemptListener");
        }
    }

    @Test(timeout=5000L)
    public void testPortRange_NotSpecified() throws IOException, TezException {
        Configuration conf = new Configuration();
        JobTokenIdentifier identifier = new JobTokenIdentifier(new Text("fakeIdentifier"));
        Token sessionToken = new Token((TokenIdentifier)identifier, (SecretManager)new JobTokenSecretManager());
        sessionToken.setService(identifier.getJobId());
        TokenCache.setSessionToken((Token)sessionToken, (Credentials)this.credentials);
        UserPayload userPayload = TezUtils.createUserPayloadFromConf((Configuration)conf);
        this.taskAttemptListener = new TaskCommunicatorManager(this.appContext, (TaskHeartbeatHandler)Mockito.mock(TaskHeartbeatHandler.class), (ContainerHeartbeatHandler)Mockito.mock(ContainerHeartbeatHandler.class), (List)Lists.newArrayList((Object[])new NamedEntityDescriptor[]{new NamedEntityDescriptor(TezConstants.getTezYarnServicePluginName(), null).setUserPayload(userPayload)}));
        this.taskAttemptListener.init(conf);
        this.taskAttemptListener.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean testPortRange(int port) {
        boolean succeedToAllocate = true;
        try {
            Configuration conf = new Configuration();
            JobTokenIdentifier identifier = new JobTokenIdentifier(new Text("fakeIdentifier"));
            Token sessionToken = new Token((TokenIdentifier)identifier, (SecretManager)new JobTokenSecretManager());
            sessionToken.setService(identifier.getJobId());
            TokenCache.setSessionToken((Token)sessionToken, (Credentials)this.credentials);
            conf.set("tez.am.task.am.port-range", port + "-" + port);
            UserPayload userPayload = TezUtils.createUserPayloadFromConf((Configuration)conf);
            this.taskAttemptListener = new TaskCommunicatorManager(this.appContext, (TaskHeartbeatHandler)Mockito.mock(TaskHeartbeatHandler.class), (ContainerHeartbeatHandler)Mockito.mock(ContainerHeartbeatHandler.class), (List)Lists.newArrayList((Object[])new NamedEntityDescriptor[]{new NamedEntityDescriptor(TezConstants.getTezYarnServicePluginName(), null).setUserPayload(userPayload)}));
            this.taskAttemptListener.init(conf);
            this.taskAttemptListener.start();
            int resultedPort = this.taskAttemptListener.getTaskCommunicator(0).getAddress().getPort();
            Assert.assertEquals((long)port, (long)resultedPort);
        }
        catch (Exception e) {
            succeedToAllocate = false;
        }
        finally {
            if (this.taskAttemptListener != null) {
                try {
                    this.taskAttemptListener.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    Assert.fail((String)"fail to stop TaskAttemptListener");
                }
            }
        }
        return succeedToAllocate;
    }

    private TaskHeartbeatResponse generateHeartbeat(List<TezEvent> events, int fromEventId, int maxEvents, int nextFromEventId, List<TezEvent> sendEvents) throws IOException, TezException {
        ContainerId containerId = this.createContainerId(this.appId, 1);
        Vertex vertex = (Vertex)Mockito.mock(Vertex.class);
        ((DAG)Mockito.doReturn((Object)vertex).when((Object)this.dag)).getVertex(this.vertexID);
        ((Vertex)Mockito.doReturn((Object)"test_vertex").when((Object)vertex)).getName();
        TaskAttemptEventInfo eventInfo = new TaskAttemptEventInfo(nextFromEventId, sendEvents, 0);
        ((Vertex)Mockito.doReturn((Object)eventInfo).when((Object)vertex)).getTaskAttemptTezEvents(this.taskAttemptID, fromEventId, 0, maxEvents);
        this.taskAttemptListener.registerRunningContainer(containerId, 0);
        this.taskAttemptListener.registerTaskAttempt(this.amContainerTask, containerId, 0);
        TaskHeartbeatRequest request = (TaskHeartbeatRequest)Mockito.mock(TaskHeartbeatRequest.class);
        ((TaskHeartbeatRequest)Mockito.doReturn((Object)containerId.toString()).when((Object)request)).getContainerIdentifier();
        ((TaskHeartbeatRequest)Mockito.doReturn((Object)containerId.toString()).when((Object)request)).getContainerIdentifier();
        ((TaskHeartbeatRequest)Mockito.doReturn((Object)this.taskAttemptID).when((Object)request)).getTaskAttemptId();
        ((TaskHeartbeatRequest)Mockito.doReturn(events).when((Object)request)).getEvents();
        ((TaskHeartbeatRequest)Mockito.doReturn((Object)maxEvents).when((Object)request)).getMaxEvents();
        ((TaskHeartbeatRequest)Mockito.doReturn((Object)fromEventId).when((Object)request)).getStartIndex();
        return this.taskAttemptListener.heartbeat(request);
    }

    private ContainerId createContainerId(ApplicationId applicationId, int containerIdx) {
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)applicationId, (int)1);
        return ContainerId.newInstance((ApplicationAttemptId)appAttemptId, (int)containerIdx);
    }

    private static class TezTaskCommunicatorImplForTest
    extends TezTaskCommunicatorImpl {
        public TezTaskCommunicatorImplForTest(TaskCommunicatorContext taskCommunicatorContext) {
            super(taskCommunicatorContext);
        }

        protected void startRpcServer() {
        }

        protected void stopRpcServer() {
        }
    }

    private static class TaskCommunicatorManagerInterfaceImplForTest
    extends TaskCommunicatorManager {
        public TaskCommunicatorManagerInterfaceImplForTest(AppContext context, TaskHeartbeatHandler thh, ContainerHeartbeatHandler chh, List<NamedEntityDescriptor> taskCommDescriptors) throws TezException {
            super(context, thh, chh, taskCommDescriptors);
        }

        TaskCommunicator createDefaultTaskCommunicator(TaskCommunicatorContext taskCommunicatorContext) {
            return new TezTaskCommunicatorImplForTest(taskCommunicatorContext);
        }
    }
}

