/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.util.SystemClock;
import org.apache.tez.dag.api.TaskLocationHint;
import org.apache.tez.dag.api.VertexLocationHint;
import org.apache.tez.dag.api.oldrecords.TaskAttemptState;
import org.apache.tez.dag.api.oldrecords.TaskState;
import org.apache.tez.dag.api.records.DAGProtos;
import org.apache.tez.dag.app.AppContext;
import org.apache.tez.dag.app.DAGAppMaster;
import org.apache.tez.dag.app.RecoveryParser;
import org.apache.tez.dag.app.dag.DAGState;
import org.apache.tez.dag.app.dag.VertexState;
import org.apache.tez.dag.app.dag.impl.DAGImpl;
import org.apache.tez.dag.app.dag.impl.TestDAGImpl;
import org.apache.tez.dag.history.DAGHistoryEvent;
import org.apache.tez.dag.history.HistoryEvent;
import org.apache.tez.dag.history.events.DAGCommitStartedEvent;
import org.apache.tez.dag.history.events.DAGFinishedEvent;
import org.apache.tez.dag.history.events.DAGInitializedEvent;
import org.apache.tez.dag.history.events.DAGStartedEvent;
import org.apache.tez.dag.history.events.DAGSubmittedEvent;
import org.apache.tez.dag.history.events.TaskAttemptFinishedEvent;
import org.apache.tez.dag.history.events.TaskAttemptStartedEvent;
import org.apache.tez.dag.history.events.TaskFinishedEvent;
import org.apache.tez.dag.history.events.TaskStartedEvent;
import org.apache.tez.dag.history.events.VertexCommitStartedEvent;
import org.apache.tez.dag.history.events.VertexConfigurationDoneEvent;
import org.apache.tez.dag.history.events.VertexFinishedEvent;
import org.apache.tez.dag.history.events.VertexGroupCommitFinishedEvent;
import org.apache.tez.dag.history.events.VertexGroupCommitStartedEvent;
import org.apache.tez.dag.history.events.VertexInitializedEvent;
import org.apache.tez.dag.history.events.VertexStartedEvent;
import org.apache.tez.dag.history.recovery.RecoveryService;
import org.apache.tez.dag.records.TezDAGID;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.dag.records.TezTaskID;
import org.apache.tez.dag.records.TezVertexID;
import org.apache.tez.hadoop.shim.DefaultHadoopShim;
import org.apache.tez.runtime.api.Event;
import org.apache.tez.runtime.api.events.DataMovementEvent;
import org.apache.tez.runtime.api.impl.TezEvent;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestRecoveryParser {
    private static String TEST_ROOT_DIR = "target/" + TestRecoveryParser.class.getName() + "-tmpDir";
    private ApplicationId appId;
    private RecoveryParser parser;
    private FileSystem localFS;
    private Configuration conf;
    private Path recoveryPath;
    private DAGAppMaster mockAppMaster;
    private DAGImpl mockDAGImpl;
    private static final int PROTOBUF_DEFAULT_SIZE_LIMIT = 0x4000000;

    @Before
    public void setUp() throws IllegalArgumentException, IOException {
        this.conf = new Configuration();
        this.localFS = FileSystem.getLocal((Configuration)this.conf);
        this.appId = ApplicationId.newInstance((long)System.currentTimeMillis(), (int)1);
        this.recoveryPath = new Path(TEST_ROOT_DIR + "/" + this.appId + "/recovery");
        this.localFS.delete(new Path(TEST_ROOT_DIR), true);
        this.mockAppMaster = (DAGAppMaster)Mockito.mock(DAGAppMaster.class);
        this.mockAppMaster.dagIDs = new HashSet();
        Mockito.when((Object)this.mockAppMaster.getConfig()).thenReturn((Object)new Configuration());
        this.mockDAGImpl = (DAGImpl)Mockito.mock(DAGImpl.class);
        Mockito.when((Object)this.mockAppMaster.createDAG((DAGProtos.DAGPlan)Mockito.any(), (TezDAGID)Mockito.any())).thenReturn((Object)this.mockDAGImpl);
        this.parser = new RecoveryParser(this.mockAppMaster, this.localFS, this.recoveryPath, 3);
    }

    private RecoveryParser.DAGSummaryData createDAGSummaryData(TezDAGID dagId, boolean completed) {
        RecoveryParser.DAGSummaryData data = new RecoveryParser.DAGSummaryData(dagId);
        data.completed = completed;
        return data;
    }

    @Test(timeout=5000L)
    public void testGetLastCompletedDAG() {
        HashMap<TezDAGID, RecoveryParser.DAGSummaryData> summaryDataMap = new HashMap<TezDAGID, RecoveryParser.DAGSummaryData>();
        int lastCompletedDAGId = new Random().nextInt(20) + 1;
        for (int i = 1; i <= lastCompletedDAGId; ++i) {
            ApplicationId appId = ApplicationId.newInstance((long)1L, (int)1);
            TezDAGID dagId = TezDAGID.getInstance((ApplicationId)appId, (int)i);
            summaryDataMap.put(dagId, this.createDAGSummaryData(dagId, true));
        }
        RecoveryParser.DAGSummaryData lastCompletedDAG = this.parser.getLastCompletedOrInProgressDAG(summaryDataMap);
        Assert.assertEquals((long)lastCompletedDAGId, (long)lastCompletedDAG.dagId.getId());
    }

    @Test(timeout=5000L)
    public void testGetLastInProgressDAG() {
        HashMap<TezDAGID, RecoveryParser.DAGSummaryData> summaryDataMap = new HashMap<TezDAGID, RecoveryParser.DAGSummaryData>();
        int dagNum = 20;
        int lastInProgressDAGId = new Random().nextInt(dagNum) + 1;
        for (int i = 1; i <= dagNum; ++i) {
            ApplicationId appId = ApplicationId.newInstance((long)1L, (int)1);
            TezDAGID dagId = TezDAGID.getInstance((ApplicationId)appId, (int)i);
            if (i == lastInProgressDAGId) {
                summaryDataMap.put(dagId, this.createDAGSummaryData(dagId, false));
                continue;
            }
            summaryDataMap.put(dagId, this.createDAGSummaryData(dagId, true));
        }
        RecoveryParser.DAGSummaryData lastInProgressDAG = this.parser.getLastCompletedOrInProgressDAG(summaryDataMap);
        Assert.assertEquals((long)lastInProgressDAGId, (long)lastInProgressDAG.dagId.getId());
    }

    @Test(timeout=5000L)
    public void testSkipAllOtherEvents_1() throws IOException {
        ApplicationId appId = ApplicationId.newInstance((long)System.currentTimeMillis(), (int)1);
        TezDAGID dagID = TezDAGID.getInstance((ApplicationId)appId, (int)1);
        AppContext appContext = (AppContext)Mockito.mock(AppContext.class);
        Mockito.when((Object)appContext.getCurrentRecoveryDir()).thenReturn((Object)new Path(this.recoveryPath + "/1"));
        Mockito.when((Object)appContext.getClock()).thenReturn((Object)new SystemClock());
        DAGProtos.DAGPlan dagPlan = TestDAGImpl.createTestDAGPlan();
        RecoveryService rService = new RecoveryService(appContext);
        Configuration conf = new Configuration();
        conf.set("fs.defaultFS", "file:///");
        conf.setBoolean("tez.test.recovery.drain_event", true);
        rService.init(conf);
        rService.start();
        rService.handle(new DAGHistoryEvent(dagID, (HistoryEvent)new DAGSubmittedEvent(dagID, 1L, dagPlan, ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1), null, "user", new Configuration(), null, null)));
        rService.handle(new DAGHistoryEvent(dagID, (HistoryEvent)new DAGInitializedEvent(dagID, 1L, "user", dagPlan.getName(), null)));
        rService.handle(new DAGHistoryEvent(dagID, (HistoryEvent)new DAGCommitStartedEvent(dagID, System.currentTimeMillis())));
        rService.stop();
        Mockito.when((Object)appContext.getCurrentRecoveryDir()).thenReturn((Object)new Path(this.recoveryPath + "/2"));
        rService = new RecoveryService(appContext);
        rService.init(conf);
        rService.start();
        rService.handle(new DAGHistoryEvent(dagID, (HistoryEvent)new DAGStartedEvent(dagID, 1L, "user", "dag1")));
        rService.stop();
        RecoveryParser.DAGRecoveryData dagData = this.parser.parseRecoveryData();
        Assert.assertEquals((Object)true, (Object)dagData.nonRecoverable);
        Assert.assertTrue((boolean)dagData.reason.contains("DAG Commit was in progress, not recoverable,"));
        ((DAGAppMaster)Mockito.verify((Object)this.mockAppMaster)).createDAG((DAGProtos.DAGPlan)Mockito.any(), (TezDAGID)Mockito.any());
        Assert.assertNull((Object)dagData.getDAGInitializedEvent());
        Assert.assertNull((Object)dagData.getDAGStartedEvent());
    }

    @Test(timeout=5000L)
    public void testSkipAllOtherEvents_2() throws IOException {
        ApplicationId appId = ApplicationId.newInstance((long)System.currentTimeMillis(), (int)1);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1);
        TezDAGID dagID = TezDAGID.getInstance((ApplicationId)appId, (int)1);
        AppContext appContext = (AppContext)Mockito.mock(AppContext.class);
        Mockito.when((Object)appContext.getCurrentRecoveryDir()).thenReturn((Object)new Path(this.recoveryPath + "/1"));
        Mockito.when((Object)appContext.getClock()).thenReturn((Object)new SystemClock());
        DAGProtos.DAGPlan dagPlan = TestDAGImpl.createTestDAGPlan();
        RecoveryService rService = new RecoveryService(appContext);
        Configuration conf = new Configuration();
        conf.set("fs.defaultFS", "file:///");
        conf.setBoolean("tez.test.recovery.drain_event", true);
        rService.init(conf);
        rService.start();
        rService.handle(new DAGHistoryEvent(dagID, (HistoryEvent)new DAGSubmittedEvent(dagID, 1L, dagPlan, ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1), null, "user", new Configuration(), null, null)));
        rService.handle(new DAGHistoryEvent(dagID, (HistoryEvent)new DAGInitializedEvent(dagID, 1L, "user", dagPlan.getName(), null)));
        rService.handle(new DAGHistoryEvent(dagID, (HistoryEvent)new DAGFinishedEvent(dagID, 1L, 2L, DAGState.FAILED, "diag", null, "user", "dag1", null, appAttemptId, dagPlan)));
        rService.handle(new DAGHistoryEvent(dagID, (HistoryEvent)new DAGStartedEvent(dagID, 1L, "user", "dag1")));
        rService.stop();
        Mockito.when((Object)appContext.getCurrentRecoveryDir()).thenReturn((Object)new Path(this.recoveryPath + "/2"));
        rService = new RecoveryService(appContext);
        rService.init(conf);
        rService.start();
        rService.handle(new DAGHistoryEvent(dagID, (HistoryEvent)new DAGStartedEvent(dagID, 1L, "user", "dag1")));
        rService.stop();
        RecoveryParser.DAGRecoveryData dagData = this.parser.parseRecoveryData();
        Assert.assertEquals((Object)false, (Object)dagData.nonRecoverable);
        Assert.assertEquals((Object)DAGState.FAILED, (Object)dagData.dagState);
        Assert.assertEquals((Object)true, (Object)dagData.isCompleted);
        ((DAGAppMaster)Mockito.verify((Object)this.mockAppMaster)).createDAG((DAGProtos.DAGPlan)Mockito.any(), (TezDAGID)Mockito.any());
        Assert.assertNotNull((Object)dagData.getDAGFinishedEvent());
        Assert.assertNull((Object)dagData.getDAGStartedEvent());
    }

    @Test(timeout=5000L)
    public void testLastCorruptedRecoveryRecord() throws IOException {
        ApplicationId appId = ApplicationId.newInstance((long)System.currentTimeMillis(), (int)1);
        TezDAGID dagID = TezDAGID.getInstance((ApplicationId)appId, (int)1);
        AppContext appContext = (AppContext)Mockito.mock(AppContext.class);
        Mockito.when((Object)appContext.getCurrentRecoveryDir()).thenReturn((Object)new Path(this.recoveryPath + "/1"));
        Mockito.when((Object)appContext.getClock()).thenReturn((Object)new SystemClock());
        Mockito.when((Object)appContext.getHadoopShim()).thenReturn((Object)new DefaultHadoopShim());
        Mockito.when((Object)appContext.getApplicationID()).thenReturn((Object)appId);
        DAGProtos.DAGPlan dagPlan = TestDAGImpl.createTestDAGPlan();
        RecoveryService rService = new RecoveryService(appContext);
        Configuration conf = new Configuration();
        conf.set("fs.defaultFS", "file:///");
        conf.setBoolean("tez.test.recovery.drain_event", true);
        rService.init(conf);
        rService.start();
        rService.handle(new DAGHistoryEvent(dagID, (HistoryEvent)new DAGSubmittedEvent(dagID, 1L, dagPlan, ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1), null, "user", new Configuration(), null, null)));
        rService.await();
        ((RecoveryService.RecoveryStream)rService.outputStreamMap.get(dagID)).write("INVALID_DATA".getBytes("UTF-8"));
        rService.stop();
        Mockito.when((Object)appContext.getCurrentRecoveryDir()).thenReturn((Object)new Path(this.recoveryPath + "/2"));
        rService = new RecoveryService(appContext);
        rService.init(conf);
        rService.start();
        rService.handle(new DAGHistoryEvent(dagID, (HistoryEvent)new DAGInitializedEvent(dagID, 1L, "user", dagPlan.getName(), null)));
        rService.await();
        ((RecoveryService.RecoveryStream)rService.outputStreamMap.get(dagID)).write("INVALID_DATA".getBytes("UTF-8"));
        rService.stop();
        RecoveryParser.DAGRecoveryData dagData = this.parser.parseRecoveryData();
        Assert.assertEquals((Object)false, (Object)dagData.isCompleted);
        Assert.assertEquals(null, (Object)dagData.reason);
        Assert.assertEquals((Object)false, (Object)dagData.nonRecoverable);
        ((DAGAppMaster)Mockito.verify((Object)this.mockAppMaster)).createDAG((DAGProtos.DAGPlan)Mockito.any(), (TezDAGID)Mockito.any());
        Assert.assertNotNull((Object)dagData.getDAGInitializedEvent());
    }

    @Test(timeout=5000L)
    public void testLastCorruptedSummaryRecord() throws IOException {
        ApplicationId appId = ApplicationId.newInstance((long)System.currentTimeMillis(), (int)1);
        TezDAGID dagID = TezDAGID.getInstance((ApplicationId)appId, (int)1);
        AppContext appContext = (AppContext)Mockito.mock(AppContext.class);
        Mockito.when((Object)appContext.getCurrentRecoveryDir()).thenReturn((Object)new Path(this.recoveryPath + "/1"));
        Mockito.when((Object)appContext.getClock()).thenReturn((Object)new SystemClock());
        RecoveryService rService = new RecoveryService(appContext);
        Configuration conf = new Configuration();
        conf.set("fs.defaultFS", "file:///");
        conf.setBoolean("tez.test.recovery.drain_event", true);
        rService.init(conf);
        rService.start();
        DAGProtos.DAGPlan dagPlan = TestDAGImpl.createTestDAGPlan();
        rService.handle(new DAGHistoryEvent(dagID, (HistoryEvent)new DAGSubmittedEvent(dagID, 1L, dagPlan, ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1), null, "user", new Configuration(), null, null)));
        rService.summaryStream.writeChars("INVALID_DATA");
        rService.stop();
        try {
            this.parser.parseRecoveryData();
            Assert.fail();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Test(timeout=5000L)
    public void testRecoverableSummary_DAGInCommitting() throws IOException {
        ApplicationId appId = ApplicationId.newInstance((long)System.currentTimeMillis(), (int)1);
        TezDAGID dagID = TezDAGID.getInstance((ApplicationId)appId, (int)1);
        AppContext appContext = (AppContext)Mockito.mock(AppContext.class);
        Mockito.when((Object)appContext.getCurrentRecoveryDir()).thenReturn((Object)new Path(this.recoveryPath + "/1"));
        Mockito.when((Object)appContext.getClock()).thenReturn((Object)new SystemClock());
        Mockito.when((Object)this.mockDAGImpl.getID()).thenReturn((Object)dagID);
        RecoveryService rService = new RecoveryService(appContext);
        Configuration conf = new Configuration();
        conf.set("fs.defaultFS", "file:///");
        conf.setBoolean("tez.test.recovery.drain_event", true);
        rService.init(conf);
        rService.start();
        DAGProtos.DAGPlan dagPlan = TestDAGImpl.createTestDAGPlan();
        rService.handle(new DAGHistoryEvent(dagID, (HistoryEvent)new DAGSubmittedEvent(dagID, 1L, dagPlan, ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1), null, "user", new Configuration(), null, null)));
        rService.handle(new DAGHistoryEvent(dagID, (HistoryEvent)new DAGCommitStartedEvent(dagID, 0L)));
        rService.stop();
        RecoveryParser.DAGRecoveryData dagData = this.parser.parseRecoveryData();
        Assert.assertEquals((Object)dagID, (Object)dagData.recoveredDagID);
        Assert.assertTrue((boolean)dagData.nonRecoverable);
        Assert.assertTrue((boolean)dagData.reason.contains("DAG Commit was in progress"));
    }

    @Test(timeout=5000L)
    public void testRecoverableSummary_DAGFinishCommitting() throws IOException {
        ApplicationId appId = ApplicationId.newInstance((long)System.currentTimeMillis(), (int)1);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1);
        TezDAGID dagID = TezDAGID.getInstance((ApplicationId)appId, (int)1);
        AppContext appContext = (AppContext)Mockito.mock(AppContext.class);
        Mockito.when((Object)appContext.getCurrentRecoveryDir()).thenReturn((Object)new Path(this.recoveryPath + "/1"));
        Mockito.when((Object)appContext.getClock()).thenReturn((Object)new SystemClock());
        Mockito.when((Object)this.mockDAGImpl.getID()).thenReturn((Object)dagID);
        RecoveryService rService = new RecoveryService(appContext);
        Configuration conf = new Configuration();
        conf.set("fs.defaultFS", "file:///");
        conf.setBoolean("tez.test.recovery.drain_event", true);
        rService.init(conf);
        rService.start();
        DAGProtos.DAGPlan dagPlan = TestDAGImpl.createTestDAGPlan();
        rService.handle(new DAGHistoryEvent(dagID, (HistoryEvent)new DAGSubmittedEvent(dagID, 1L, dagPlan, ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1), null, "user", new Configuration(), null, null)));
        rService.handle(new DAGHistoryEvent(dagID, (HistoryEvent)new DAGCommitStartedEvent(dagID, 0L)));
        rService.handle(new DAGHistoryEvent(dagID, (HistoryEvent)new DAGFinishedEvent(dagID, 1L, 2L, DAGState.FAILED, "diag", null, "user", "dag1", null, appAttemptId, dagPlan)));
        rService.stop();
        RecoveryParser.DAGRecoveryData dagData = this.parser.parseRecoveryData();
        Assert.assertEquals((Object)dagID, (Object)dagData.recoveredDagID);
        Assert.assertEquals((Object)DAGState.FAILED, (Object)dagData.dagState);
        Assert.assertFalse((boolean)dagData.nonRecoverable);
        Assert.assertNull((Object)dagData.reason);
        Assert.assertTrue((boolean)dagData.isCompleted);
    }

    @Test(timeout=5000L)
    public void testRecoverableSummary_VertexInCommitting() throws IOException {
        ApplicationId appId = ApplicationId.newInstance((long)System.currentTimeMillis(), (int)1);
        TezDAGID dagID = TezDAGID.getInstance((ApplicationId)appId, (int)1);
        AppContext appContext = (AppContext)Mockito.mock(AppContext.class);
        Mockito.when((Object)appContext.getCurrentRecoveryDir()).thenReturn((Object)new Path(this.recoveryPath + "/1"));
        Mockito.when((Object)appContext.getClock()).thenReturn((Object)new SystemClock());
        Mockito.when((Object)this.mockDAGImpl.getID()).thenReturn((Object)dagID);
        RecoveryService rService = new RecoveryService(appContext);
        Configuration conf = new Configuration();
        conf.set("fs.defaultFS", "file:///");
        conf.setBoolean("tez.test.recovery.drain_event", true);
        rService.init(conf);
        rService.start();
        DAGProtos.DAGPlan dagPlan = TestDAGImpl.createTestDAGPlan();
        rService.handle(new DAGHistoryEvent(dagID, (HistoryEvent)new DAGSubmittedEvent(dagID, 1L, dagPlan, ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1), null, "user", new Configuration(), null, null)));
        rService.handle(new DAGHistoryEvent(dagID, (HistoryEvent)new VertexCommitStartedEvent(TezVertexID.getInstance((TezDAGID)dagID, (int)0), 0L)));
        rService.stop();
        RecoveryParser.DAGRecoveryData dagData = this.parser.parseRecoveryData();
        Assert.assertEquals((Object)dagID, (Object)dagData.recoveredDagID);
        Assert.assertTrue((boolean)dagData.nonRecoverable);
        Assert.assertTrue((boolean)dagData.reason.contains("Vertex Commit was in progress"));
    }

    @Test(timeout=5000L)
    public void testRecoverableSummary_VertexFinishCommitting() throws IOException {
        ApplicationId appId = ApplicationId.newInstance((long)System.currentTimeMillis(), (int)1);
        TezDAGID dagID = TezDAGID.getInstance((ApplicationId)appId, (int)1);
        AppContext appContext = (AppContext)Mockito.mock(AppContext.class);
        Mockito.when((Object)appContext.getCurrentRecoveryDir()).thenReturn((Object)new Path(this.recoveryPath + "/1"));
        Mockito.when((Object)appContext.getClock()).thenReturn((Object)new SystemClock());
        Mockito.when((Object)this.mockDAGImpl.getID()).thenReturn((Object)dagID);
        Mockito.when((Object)appContext.getHadoopShim()).thenReturn((Object)new DefaultHadoopShim());
        Mockito.when((Object)appContext.getApplicationID()).thenReturn((Object)appId);
        RecoveryService rService = new RecoveryService(appContext);
        Configuration conf = new Configuration();
        conf.set("fs.defaultFS", "file:///");
        conf.setBoolean("tez.test.recovery.drain_event", true);
        rService.init(conf);
        rService.start();
        DAGProtos.DAGPlan dagPlan = TestDAGImpl.createTestDAGPlan();
        rService.handle(new DAGHistoryEvent(dagID, (HistoryEvent)new DAGSubmittedEvent(dagID, 1L, dagPlan, ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1), null, "user", new Configuration(), null, null)));
        TezVertexID vertexId = TezVertexID.getInstance((TezDAGID)dagID, (int)0);
        rService.handle(new DAGHistoryEvent(dagID, (HistoryEvent)new VertexCommitStartedEvent(vertexId, 0L)));
        rService.handle(new DAGHistoryEvent(dagID, (HistoryEvent)new VertexFinishedEvent(vertexId, "v1", 10, 0L, 0L, 0L, 0L, 0L, VertexState.SUCCEEDED, "", null, null, null, null)));
        rService.stop();
        RecoveryParser.DAGRecoveryData dagData = this.parser.parseRecoveryData();
        Assert.assertEquals((Object)dagID, (Object)dagData.recoveredDagID);
        Assert.assertFalse((boolean)dagData.nonRecoverable);
    }

    @Test(timeout=5000L)
    public void testRecoverableSummary_VertexGroupInCommitting() throws IOException {
        ApplicationId appId = ApplicationId.newInstance((long)System.currentTimeMillis(), (int)1);
        TezDAGID dagID = TezDAGID.getInstance((ApplicationId)appId, (int)1);
        AppContext appContext = (AppContext)Mockito.mock(AppContext.class);
        Mockito.when((Object)appContext.getCurrentRecoveryDir()).thenReturn((Object)new Path(this.recoveryPath + "/1"));
        Mockito.when((Object)appContext.getClock()).thenReturn((Object)new SystemClock());
        Mockito.when((Object)this.mockDAGImpl.getID()).thenReturn((Object)dagID);
        Mockito.when((Object)appContext.getHadoopShim()).thenReturn((Object)new DefaultHadoopShim());
        Mockito.when((Object)appContext.getApplicationID()).thenReturn((Object)appId);
        RecoveryService rService = new RecoveryService(appContext);
        Configuration conf = new Configuration();
        conf.set("fs.defaultFS", "file:///");
        conf.setBoolean("tez.test.recovery.drain_event", true);
        rService.init(conf);
        rService.start();
        DAGProtos.DAGPlan dagPlan = TestDAGImpl.createTestDAGPlan();
        rService.handle(new DAGHistoryEvent(dagID, (HistoryEvent)new DAGSubmittedEvent(dagID, 1L, dagPlan, ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1), null, "user", new Configuration(), null, null)));
        rService.handle(new DAGHistoryEvent(dagID, (HistoryEvent)new VertexGroupCommitStartedEvent(dagID, "group_1", (Collection)Lists.newArrayList((Object[])new TezVertexID[]{TezVertexID.getInstance((TezDAGID)dagID, (int)0), TezVertexID.getInstance((TezDAGID)dagID, (int)1)}), 0L)));
        rService.stop();
        RecoveryParser.DAGRecoveryData dagData = this.parser.parseRecoveryData();
        Assert.assertEquals((Object)dagID, (Object)dagData.recoveredDagID);
        Assert.assertTrue((boolean)dagData.nonRecoverable);
        Assert.assertTrue((boolean)dagData.reason.contains("Vertex Group Commit was in progress"));
    }

    @Test(timeout=5000L)
    public void testRecoverableSummary_VertexGroupFinishCommitting() throws IOException {
        ApplicationId appId = ApplicationId.newInstance((long)System.currentTimeMillis(), (int)1);
        TezDAGID dagID = TezDAGID.getInstance((ApplicationId)appId, (int)1);
        AppContext appContext = (AppContext)Mockito.mock(AppContext.class);
        Mockito.when((Object)appContext.getCurrentRecoveryDir()).thenReturn((Object)new Path(this.recoveryPath + "/1"));
        Mockito.when((Object)appContext.getClock()).thenReturn((Object)new SystemClock());
        Mockito.when((Object)this.mockDAGImpl.getID()).thenReturn((Object)dagID);
        Mockito.when((Object)appContext.getHadoopShim()).thenReturn((Object)new DefaultHadoopShim());
        Mockito.when((Object)appContext.getApplicationID()).thenReturn((Object)appId);
        RecoveryService rService = new RecoveryService(appContext);
        Configuration conf = new Configuration();
        conf.set("fs.defaultFS", "file:///");
        conf.setBoolean("tez.test.recovery.drain_event", true);
        rService.init(conf);
        rService.start();
        DAGProtos.DAGPlan dagPlan = TestDAGImpl.createTestDAGPlan();
        rService.handle(new DAGHistoryEvent(dagID, (HistoryEvent)new DAGSubmittedEvent(dagID, 1L, dagPlan, ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1), null, "user", new Configuration(), null, null)));
        TezVertexID v0 = TezVertexID.getInstance((TezDAGID)dagID, (int)0);
        TezVertexID v1 = TezVertexID.getInstance((TezDAGID)dagID, (int)1);
        rService.handle(new DAGHistoryEvent(dagID, (HistoryEvent)new VertexGroupCommitStartedEvent(dagID, "group_1", (Collection)Lists.newArrayList((Object[])new TezVertexID[]{v0, v1}), 0L)));
        rService.handle(new DAGHistoryEvent(dagID, (HistoryEvent)new VertexGroupCommitFinishedEvent(dagID, "group_1", (Collection)Lists.newArrayList((Object[])new TezVertexID[]{v0, v1}), 0L)));
        rService.handle(new DAGHistoryEvent(dagID, (HistoryEvent)new VertexFinishedEvent(v0, "v1", 10, 0L, 0L, 0L, 0L, 0L, VertexState.SUCCEEDED, "", null, null, null, null)));
        rService.handle(new DAGHistoryEvent(dagID, (HistoryEvent)new VertexFinishedEvent(v1, "v1", 10, 0L, 0L, 0L, 0L, 0L, VertexState.SUCCEEDED, "", null, null, null, null)));
        rService.stop();
        RecoveryParser.DAGRecoveryData dagData = this.parser.parseRecoveryData();
        Assert.assertEquals((Object)dagID, (Object)dagData.recoveredDagID);
        Assert.assertFalse((boolean)dagData.nonRecoverable);
    }

    @Test(timeout=5000L)
    public void testRecoverableNonSummary1() throws IOException {
        ApplicationId appId = ApplicationId.newInstance((long)System.currentTimeMillis(), (int)1);
        TezDAGID dagID = TezDAGID.getInstance((ApplicationId)appId, (int)1);
        AppContext appContext = (AppContext)Mockito.mock(AppContext.class);
        Mockito.when((Object)appContext.getCurrentRecoveryDir()).thenReturn((Object)new Path(this.recoveryPath + "/1"));
        Mockito.when((Object)appContext.getClock()).thenReturn((Object)new SystemClock());
        Mockito.when((Object)this.mockDAGImpl.getID()).thenReturn((Object)dagID);
        Mockito.when((Object)appContext.getHadoopShim()).thenReturn((Object)new DefaultHadoopShim());
        Mockito.when((Object)appContext.getApplicationID()).thenReturn((Object)appId);
        MockRecoveryService rService = new MockRecoveryService(appContext);
        Configuration conf = new Configuration();
        conf.set("fs.defaultFS", "file:///");
        conf.setBoolean("tez.test.recovery.drain_event", true);
        rService.init(conf);
        rService.start();
        DAGProtos.DAGPlan dagPlan = TestDAGImpl.createTestDAGPlan();
        rService.handle(new DAGHistoryEvent(dagID, (HistoryEvent)new DAGSubmittedEvent(dagID, 1L, dagPlan, ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1), null, "user", new Configuration(), null, null)));
        TezVertexID vertexId = TezVertexID.getInstance((TezDAGID)dagID, (int)0);
        rService.handle(new DAGHistoryEvent(dagID, (HistoryEvent)new VertexCommitStartedEvent(vertexId, 0L)));
        rService.handle(new DAGHistoryEvent(dagID, (HistoryEvent)new VertexFinishedEvent(vertexId, "v1", 10, 0L, 0L, 0L, 0L, 0L, VertexState.SUCCEEDED, "", null, null, null, null)));
        rService.stop();
        RecoveryParser.DAGRecoveryData dagData = this.parser.parseRecoveryData();
        Assert.assertTrue((boolean)dagData.nonRecoverable);
        Assert.assertTrue((boolean)dagData.reason.contains("Vertex has been committed, but its full recovery events are not seen"));
    }

    @Test(timeout=5000L)
    public void testRecoverableNonSummary2() throws IOException {
        ApplicationId appId = ApplicationId.newInstance((long)System.currentTimeMillis(), (int)1);
        TezDAGID dagID = TezDAGID.getInstance((ApplicationId)appId, (int)1);
        AppContext appContext = (AppContext)Mockito.mock(AppContext.class);
        Mockito.when((Object)appContext.getCurrentRecoveryDir()).thenReturn((Object)new Path(this.recoveryPath + "/1"));
        Mockito.when((Object)appContext.getClock()).thenReturn((Object)new SystemClock());
        Mockito.when((Object)this.mockDAGImpl.getID()).thenReturn((Object)dagID);
        MockRecoveryService rService = new MockRecoveryService(appContext);
        Configuration conf = new Configuration();
        conf.set("fs.defaultFS", "file:///");
        conf.setBoolean("tez.test.recovery.drain_event", true);
        rService.init(conf);
        rService.start();
        DAGProtos.DAGPlan dagPlan = TestDAGImpl.createTestDAGPlan();
        rService.handle(new DAGHistoryEvent(dagID, (HistoryEvent)new DAGSubmittedEvent(dagID, 1L, dagPlan, ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1), null, "user", new Configuration(), null, null)));
        TezVertexID vertexId = TezVertexID.getInstance((TezDAGID)dagID, (int)0);
        rService.handle(new DAGHistoryEvent(dagID, (HistoryEvent)new VertexGroupCommitStartedEvent(dagID, "group_1", (Collection)Lists.newArrayList((Object[])new TezVertexID[]{TezVertexID.getInstance((TezDAGID)dagID, (int)0), TezVertexID.getInstance((TezDAGID)dagID, (int)1)}), 0L)));
        rService.handle(new DAGHistoryEvent(dagID, (HistoryEvent)new VertexGroupCommitFinishedEvent(dagID, "group_1", (Collection)Lists.newArrayList((Object[])new TezVertexID[]{TezVertexID.getInstance((TezDAGID)dagID, (int)0), TezVertexID.getInstance((TezDAGID)dagID, (int)1)}), 0L)));
        rService.stop();
        RecoveryParser.DAGRecoveryData dagData = this.parser.parseRecoveryData();
        Assert.assertTrue((boolean)dagData.nonRecoverable);
        Assert.assertTrue((boolean)dagData.reason.contains("Vertex has been committed as member of vertex group, but its full recovery events are not seen"));
    }

    @Test(timeout=20000L)
    public void testRecoveryLargeEventData() throws IOException {
        VertexLocationHint vertexLocationHint;
        ApplicationId appId = ApplicationId.newInstance((long)System.currentTimeMillis(), (int)1);
        TezDAGID dagID = TezDAGID.getInstance((ApplicationId)appId, (int)1);
        AppContext appContext = (AppContext)Mockito.mock(AppContext.class);
        Mockito.when((Object)appContext.getCurrentRecoveryDir()).thenReturn((Object)new Path(this.recoveryPath + "/1"));
        Mockito.when((Object)appContext.getClock()).thenReturn((Object)new SystemClock());
        Mockito.when((Object)this.mockDAGImpl.getID()).thenReturn((Object)dagID);
        Mockito.when((Object)appContext.getHadoopShim()).thenReturn((Object)new DefaultHadoopShim());
        Mockito.when((Object)appContext.getApplicationID()).thenReturn((Object)appId);
        RecoveryService rService = new RecoveryService(appContext);
        Configuration conf = new Configuration();
        conf.set("fs.defaultFS", "file:///");
        conf.setBoolean("tez.test.recovery.drain_event", true);
        rService.init(conf);
        rService.start();
        DAGProtos.DAGPlan dagPlan = TestDAGImpl.createTestDAGPlan();
        rService.handle(new DAGHistoryEvent(dagID, (HistoryEvent)new DAGSubmittedEvent(dagID, 1L, dagPlan, ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1), null, "user", new Configuration(), null, null)));
        DAGInitializedEvent dagInitedEvent = new DAGInitializedEvent(dagID, 100L, "user", "dagName", null);
        DAGStartedEvent dagStartedEvent = new DAGStartedEvent(dagID, 0L, "user", "dagName");
        rService.handle(new DAGHistoryEvent(dagID, (HistoryEvent)dagInitedEvent));
        rService.handle(new DAGHistoryEvent(dagID, (HistoryEvent)dagStartedEvent));
        ArrayList<TaskLocationHint> taskLocationHints = new ArrayList<TaskLocationHint>(100000);
        TaskLocationHint taskLocationHint = TaskLocationHint.createTaskLocationHint((Set)Sets.newHashSet((Object[])new String[]{"aaaaaaaaaaaaaaa.aaaaaaaaaaaaaaa.aaaaaaaaaaaaaaa", "bbbbbbbbbbbbbbb.bbbbbbbbbbbbbbb.bbbbbbbbbbbbbbb", "ccccccccccccccc.ccccccccccccccc.ccccccccccccccc", "ddddddddddddddd.ddddddddddddddd.ddddddddddddddd", "eeeeeeeeeeeeeee.eeeeeeeeeeeeeee.eeeeeeeeeeeeeee", "fffffffffffffff.fffffffffffffff.fffffffffffffff", "ggggggggggggggg.ggggggggggggggg.ggggggggggggggg", "hhhhhhhhhhhhhhh.hhhhhhhhhhhhhhh.hhhhhhhhhhhhhhh", "iiiiiiiiiiiiiii.iiiiiiiiiiiiiii.iiiiiiiiiiiiiii", "jjjjjjjjjjjjjjj.jjjjjjjjjjjjjjj.jjjjjjjjjjjjjjj", "kkkkkkkkkkkkkkk.kkkkkkkkkkkkkkk.kkkkkkkkkkkkkkk", "lllllllllllllll.lllllllllllllll.lllllllllllllll", "mmmmmmmmmmmmmmm.mmmmmmmmmmmmmmm.mmmmmmmmmmmmmmm", "nnnnnnnnnnnnnnn.nnnnnnnnnnnnnnn.nnnnnnnnnnnnnnn"}), (Set)Sets.newHashSet((Object[])new String[]{"rack1", "rack2", "rack3"}));
        for (int i = 0; i < 100000; ++i) {
            taskLocationHints.add(taskLocationHint);
        }
        TezVertexID v0Id = TezVertexID.getInstance((TezDAGID)dagID, (int)0);
        VertexConfigurationDoneEvent vertexConfigurationDoneEvent = new VertexConfigurationDoneEvent(v0Id, 0L, 100000, vertexLocationHint = VertexLocationHint.create(taskLocationHints), null, null, false);
        Assert.assertTrue((vertexConfigurationDoneEvent.toProto().getSerializedSize() > 0x4000000 ? 1 : 0) != 0);
        rService.handle(new DAGHistoryEvent(dagID, (HistoryEvent)vertexConfigurationDoneEvent));
        rService.stop();
        RecoveryParser.DAGRecoveryData dagData = this.parser.parseRecoveryData();
        RecoveryParser.VertexRecoveryData v0data = dagData.getVertexRecoveryData(v0Id);
        Assert.assertNotNull((String)"Vertex Recovery Data should be non-null", (Object)v0data);
        VertexConfigurationDoneEvent parsedVertexConfigurationDoneEvent = v0data.getVertexConfigurationDoneEvent();
        Assert.assertNotNull((String)"Vertex Configuration Done Event should be non-null", (Object)parsedVertexConfigurationDoneEvent);
        VertexLocationHint parsedVertexLocationHint = parsedVertexConfigurationDoneEvent.getVertexLocationHint();
        Assert.assertNotNull((String)"Vertex Location Hint should be non-null", (Object)parsedVertexLocationHint);
        Assert.assertEquals((long)parsedVertexLocationHint.getTaskLocationHints().size(), (long)100000L);
    }

    @Test(timeout=5000L)
    public void testRecoveryData() throws IOException {
        ApplicationId appId = ApplicationId.newInstance((long)System.currentTimeMillis(), (int)1);
        TezDAGID dagID = TezDAGID.getInstance((ApplicationId)appId, (int)1);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1);
        AppContext appContext = (AppContext)Mockito.mock(AppContext.class);
        Mockito.when((Object)appContext.getCurrentRecoveryDir()).thenReturn((Object)new Path(this.recoveryPath + "/1"));
        Mockito.when((Object)appContext.getClock()).thenReturn((Object)new SystemClock());
        Mockito.when((Object)this.mockDAGImpl.getID()).thenReturn((Object)dagID);
        Mockito.when((Object)appContext.getHadoopShim()).thenReturn((Object)new DefaultHadoopShim());
        Mockito.when((Object)appContext.getApplicationID()).thenReturn((Object)appId);
        RecoveryService rService = new RecoveryService(appContext);
        Configuration conf = new Configuration();
        conf.set("fs.defaultFS", "file:///");
        conf.setBoolean("tez.test.recovery.drain_event", true);
        rService.init(conf);
        rService.start();
        DAGProtos.DAGPlan dagPlan = TestDAGImpl.createTestDAGPlan();
        rService.handle(new DAGHistoryEvent(dagID, (HistoryEvent)new DAGSubmittedEvent(dagID, 1L, dagPlan, ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1), null, "user", new Configuration(), null, null)));
        DAGInitializedEvent dagInitedEvent = new DAGInitializedEvent(dagID, 100L, "user", "dagName", null);
        DAGStartedEvent dagStartedEvent = new DAGStartedEvent(dagID, 0L, "user", "dagName");
        rService.handle(new DAGHistoryEvent(dagID, (HistoryEvent)dagInitedEvent));
        rService.handle(new DAGHistoryEvent(dagID, (HistoryEvent)dagStartedEvent));
        TezVertexID v0Id = TezVertexID.getInstance((TezDAGID)dagID, (int)0);
        TezVertexID v1Id = TezVertexID.getInstance((TezDAGID)dagID, (int)1);
        TezVertexID v2Id = TezVertexID.getInstance((TezDAGID)dagID, (int)2);
        VertexInitializedEvent v0InitedEvent = new VertexInitializedEvent(v0Id, "v0", 200L, 400L, 2, null, null, null, null);
        rService.handle(new DAGHistoryEvent(dagID, (HistoryEvent)v0InitedEvent));
        VertexFinishedEvent v1FinishedEvent = new VertexFinishedEvent(v1Id, "v1", 2, 300L, 400L, 500L, 600L, 700L, VertexState.KILLED, "", null, null, null, null);
        rService.handle(new DAGHistoryEvent(dagID, (HistoryEvent)v1FinishedEvent));
        ArrayList initGeneratedEvents = Lists.newArrayList((Object[])new TezEvent[]{new TezEvent((Event)DataMovementEvent.create((ByteBuffer)ByteBuffer.wrap(new byte[0])), null)});
        VertexInitializedEvent v2InitedEvent = new VertexInitializedEvent(v2Id, "v2", 200L, 300L, 2, null, null, (List)initGeneratedEvents, null);
        VertexStartedEvent v2StartedEvent = new VertexStartedEvent(v2Id, 0L, 0L);
        rService.handle(new DAGHistoryEvent(dagID, (HistoryEvent)v2InitedEvent));
        rService.handle(new DAGHistoryEvent(dagID, (HistoryEvent)v2StartedEvent));
        TezTaskID t0v2Id = TezTaskID.getInstance((TezVertexID)v2Id, (int)0);
        TezTaskID t1v2Id = TezTaskID.getInstance((TezVertexID)v2Id, (int)1);
        TezTaskID t2v2Id = TezTaskID.getInstance((TezVertexID)v2Id, (int)2);
        TaskStartedEvent t0v2StartedEvent = new TaskStartedEvent(t0v2Id, "v2", 400L, 5000L);
        rService.handle(new DAGHistoryEvent(dagID, (HistoryEvent)t0v2StartedEvent));
        TaskFinishedEvent t1v2FinishedEvent = new TaskFinishedEvent(t1v2Id, "v1", 0L, 0L, null, TaskState.KILLED, "", null, 4);
        rService.handle(new DAGHistoryEvent(dagID, (HistoryEvent)t1v2FinishedEvent));
        TaskStartedEvent t2v2StartedEvent = new TaskStartedEvent(t2v2Id, "v2", 400L, 500L);
        rService.handle(new DAGHistoryEvent(dagID, (HistoryEvent)t2v2StartedEvent));
        TaskFinishedEvent t2v2FinishedEvent = new TaskFinishedEvent(t2v2Id, "v1", 0L, 0L, null, TaskState.SUCCEEDED, "", null, 4);
        rService.handle(new DAGHistoryEvent(dagID, (HistoryEvent)t2v2FinishedEvent));
        ContainerId containerId = ContainerId.newInstance((ApplicationAttemptId)appAttemptId, (int)1);
        NodeId nodeId = NodeId.newInstance((String)"localhost", (int)9999);
        TezTaskAttemptID ta0t0v2Id = TezTaskAttemptID.getInstance((TezTaskID)t0v2Id, (int)0);
        TaskAttemptStartedEvent ta0t0v2StartedEvent = new TaskAttemptStartedEvent(ta0t0v2Id, "v1", 0L, containerId, nodeId, "", "", "");
        rService.handle(new DAGHistoryEvent(dagID, (HistoryEvent)ta0t0v2StartedEvent));
        TezTaskAttemptID ta0t2v2Id = TezTaskAttemptID.getInstance((TezTaskID)t2v2Id, (int)0);
        TaskAttemptStartedEvent ta0t2v2StartedEvent = new TaskAttemptStartedEvent(ta0t2v2Id, "v1", 500L, containerId, nodeId, "", "", "");
        rService.handle(new DAGHistoryEvent(dagID, (HistoryEvent)ta0t2v2StartedEvent));
        TaskAttemptFinishedEvent ta0t2v2FinishedEvent = new TaskAttemptFinishedEvent(ta0t2v2Id, "v1", 500L, 600L, TaskAttemptState.SUCCEEDED, null, null, "", null, null, null, 0L, null, 0L, null, null, null, null, null);
        rService.handle(new DAGHistoryEvent(dagID, (HistoryEvent)ta0t2v2FinishedEvent));
        rService.stop();
        RecoveryParser.DAGRecoveryData dagData = this.parser.parseRecoveryData();
        Assert.assertFalse((boolean)dagData.nonRecoverable);
        Assert.assertEquals((long)dagInitedEvent.getInitTime(), (long)dagData.getDAGInitializedEvent().getInitTime());
        Assert.assertEquals((long)dagStartedEvent.getStartTime(), (long)dagData.getDAGStartedEvent().getStartTime());
        Assert.assertNull((Object)dagData.getDAGFinishedEvent());
        RecoveryParser.VertexRecoveryData v0Data = dagData.getVertexRecoveryData(v0Id);
        RecoveryParser.VertexRecoveryData v1Data = dagData.getVertexRecoveryData(v1Id);
        RecoveryParser.VertexRecoveryData v2Data = dagData.getVertexRecoveryData(v2Id);
        Assert.assertNotNull((Object)v0Data);
        Assert.assertNotNull((Object)v1Data);
        Assert.assertNotNull((Object)v2Data);
        Assert.assertEquals((long)v0InitedEvent.getInitedTime(), (long)v0Data.getVertexInitedEvent().getInitedTime());
        Assert.assertNull((Object)v0Data.getVertexStartedEvent());
        Assert.assertNull((Object)v1Data.getVertexInitedEvent());
        Assert.assertEquals((long)v1FinishedEvent.getFinishTime(), (long)v1Data.getVertexFinishedEvent().getFinishTime());
        Assert.assertEquals((long)v2InitedEvent.getInitedTime(), (long)v2Data.getVertexInitedEvent().getInitedTime());
        Assert.assertEquals((long)v2StartedEvent.getStartTime(), (long)v2Data.getVertexStartedEvent().getStartTime());
        RecoveryParser.TaskRecoveryData t0v2Data = dagData.getTaskRecoveryData(t0v2Id);
        RecoveryParser.TaskRecoveryData t1v2Data = dagData.getTaskRecoveryData(t1v2Id);
        RecoveryParser.TaskRecoveryData t2v2Data = dagData.getTaskRecoveryData(t2v2Id);
        Assert.assertNotNull((Object)t0v2Data);
        Assert.assertNotNull((Object)t1v2Data);
        Assert.assertNotNull((Object)t2v2Data);
        Assert.assertEquals((long)t0v2StartedEvent.getStartTime(), (long)t0v2Data.getTaskStartedEvent().getStartTime());
        Assert.assertNull((Object)t0v2Data.getTaskFinishedEvent());
        Assert.assertEquals((long)t1v2FinishedEvent.getFinishTime(), (long)t1v2Data.getTaskFinishedEvent().getFinishTime());
        Assert.assertNull((Object)t1v2Data.getTaskStartedEvent());
        Assert.assertEquals((long)t2v2StartedEvent.getStartTime(), (long)t2v2Data.getTaskStartedEvent().getStartTime());
        Assert.assertEquals((long)t2v2FinishedEvent.getFinishTime(), (long)t2v2Data.getTaskFinishedEvent().getFinishTime());
        RecoveryParser.TaskAttemptRecoveryData ta0t0v2Data = dagData.getTaskAttemptRecoveryData(ta0t0v2Id);
        RecoveryParser.TaskAttemptRecoveryData ta0t2v2Data = dagData.getTaskAttemptRecoveryData(ta0t2v2Id);
        Assert.assertNotNull((Object)ta0t0v2Data);
        Assert.assertNotNull((Object)ta0t2v2Data);
        Assert.assertEquals((long)ta0t0v2StartedEvent.getStartTime(), (long)ta0t0v2Data.getTaskAttemptStartedEvent().getStartTime());
        Assert.assertNull((Object)ta0t0v2Data.getTaskAttemptFinishedEvent());
        Assert.assertEquals((long)ta0t2v2StartedEvent.getStartTime(), (long)ta0t2v2Data.getTaskAttemptStartedEvent().getStartTime());
        Assert.assertEquals((long)ta0t2v2FinishedEvent.getFinishTime(), (long)ta0t2v2Data.getTaskAttemptFinishedEvent().getFinishTime());
    }

    public static class MockRecoveryService
    extends RecoveryService {
        public MockRecoveryService(AppContext appContext) {
            super(appContext);
        }

        protected void handleRecoveryEvent(DAGHistoryEvent event) throws IOException {
        }
    }
}

