/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.rm;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.NodeReport;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.tez.common.ContainerSignatureMatcher;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.dag.app.AppContext;
import org.apache.tez.dag.app.rm.TaskSchedulerManager;
import org.apache.tez.serviceplugins.api.DagInfo;
import org.apache.tez.serviceplugins.api.ServicePluginError;
import org.apache.tez.serviceplugins.api.TaskSchedulerContext;

public class TaskSchedulerContextImpl
implements TaskSchedulerContext {
    private final TaskSchedulerManager taskSchedulerManager;
    private final AppContext appContext;
    private final int schedulerId;
    private final String trackingUrl;
    private final long customClusterIdentifier;
    private final String appHostName;
    private final int clientPort;
    private final UserPayload initialUserPayload;

    public TaskSchedulerContextImpl(TaskSchedulerManager taskSchedulerManager, AppContext appContext, int schedulerId, String trackingUrl, long customClusterIdentifier, String appHostname, int clientPort, UserPayload initialUserPayload) {
        this.taskSchedulerManager = taskSchedulerManager;
        this.appContext = appContext;
        this.schedulerId = schedulerId;
        this.trackingUrl = trackingUrl;
        this.customClusterIdentifier = customClusterIdentifier;
        this.appHostName = appHostname;
        this.clientPort = clientPort;
        this.initialUserPayload = initialUserPayload;
    }

    public void taskAllocated(Object task, Object appCookie, Container container) {
        this.taskSchedulerManager.taskAllocated(this.schedulerId, task, appCookie, container);
    }

    public void containerCompleted(Object taskLastAllocated, ContainerStatus containerStatus) {
        this.taskSchedulerManager.containerCompleted(this.schedulerId, taskLastAllocated, containerStatus);
    }

    public void containerBeingReleased(ContainerId containerId) {
        this.taskSchedulerManager.containerBeingReleased(this.schedulerId, containerId);
    }

    public void nodesUpdated(List<NodeReport> updatedNodes) {
        this.taskSchedulerManager.nodesUpdated(this.schedulerId, updatedNodes);
    }

    public void appShutdownRequested() {
        this.taskSchedulerManager.appShutdownRequested(this.schedulerId);
    }

    public void setApplicationRegistrationData(Resource maxContainerCapability, Map<ApplicationAccessType, String> appAcls, ByteBuffer clientAMSecretKey, String queueName) {
        this.taskSchedulerManager.setApplicationRegistrationData(this.schedulerId, maxContainerCapability, appAcls, clientAMSecretKey, queueName);
    }

    public float getProgress() {
        return this.taskSchedulerManager.getProgress(this.schedulerId);
    }

    public void preemptContainer(ContainerId containerId) {
        this.taskSchedulerManager.preemptContainer(this.schedulerId, containerId);
    }

    public TaskSchedulerContext.AppFinalStatus getFinalAppStatus() {
        return this.taskSchedulerManager.getFinalAppStatus();
    }

    public UserPayload getInitialUserPayload() {
        return this.initialUserPayload;
    }

    public String getAppTrackingUrl() {
        return this.trackingUrl;
    }

    public long getCustomClusterIdentifier() {
        return this.customClusterIdentifier;
    }

    public ContainerSignatureMatcher getContainerSignatureMatcher() {
        return this.taskSchedulerManager.getContainerSignatureMatcher();
    }

    public ApplicationAttemptId getApplicationAttemptId() {
        return this.appContext.getApplicationAttemptId();
    }

    @Nullable
    public DagInfo getCurrentDagInfo() {
        return this.appContext.getCurrentDAG();
    }

    public String getAppHostName() {
        return this.appHostName;
    }

    public int getAppClientPort() {
        return this.clientPort;
    }

    public boolean isSession() {
        return this.appContext.isSession();
    }

    public TaskSchedulerContext.AMState getAMState() {
        switch (this.appContext.getAMState()) {
            case NEW: 
            case INITED: 
            case IDLE: {
                return TaskSchedulerContext.AMState.IDLE;
            }
            case RECOVERING: 
            case RUNNING: {
                return TaskSchedulerContext.AMState.RUNNING_APP;
            }
            case SUCCEEDED: 
            case FAILED: 
            case KILLED: 
            case ERROR: {
                return TaskSchedulerContext.AMState.COMPLETED;
            }
        }
        throw new TezUncheckedException("Unexpected state " + this.appContext.getAMState());
    }

    public int getVertexIndexForTask(Object task) {
        return this.taskSchedulerManager.getVertexIndexForTask(task);
    }

    public void reportError(ServicePluginError servicePluginError, String diagnostics, DagInfo dagInfo) {
        Objects.requireNonNull(servicePluginError, "ServicePluginError must be specified");
        this.taskSchedulerManager.reportError(this.schedulerId, servicePluginError, diagnostics, dagInfo);
    }
}

