/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.dag.app;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.tez.common.ContainerContext;
import org.apache.tez.common.ContainerTask;
import org.apache.tez.common.TezUtils;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.dag.app.TezTaskCommunicatorImpl;
import org.apache.tez.serviceplugins.api.TaskCommunicatorContext;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestTezTaskCommunicatorManager {
    @Test(timeout=5000L)
    public void testContainerAliveOnGetTask() throws IOException {
        TaskCommunicatorContext context = (TaskCommunicatorContext)Mockito.mock(TaskCommunicatorContext.class);
        Configuration conf = new Configuration(false);
        UserPayload userPayload = TezUtils.createUserPayloadFromConf((Configuration)conf);
        ApplicationId appId = ApplicationId.newInstance((long)1000L, (int)1);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1);
        ContainerId containerId = this.createContainerId(appId, 1);
        ((TaskCommunicatorContext)Mockito.doReturn((Object)appAttemptId).when((Object)context)).getApplicationAttemptId();
        ((TaskCommunicatorContext)Mockito.doReturn((Object)userPayload).when((Object)context)).getInitialUserPayload();
        ((TaskCommunicatorContext)Mockito.doReturn((Object)new Credentials()).when((Object)context)).getAMCredentials();
        TezTaskCommunicatorImpl taskComm = new TezTaskCommunicatorImpl(context);
        ContainerContext containerContext = new ContainerContext(containerId.toString());
        taskComm.registerRunningContainer(containerId, "fakehost", 0);
        ContainerTask containerTask = taskComm.getUmbilical().getTask(containerContext);
        Assert.assertNull((Object)containerTask);
        ((TaskCommunicatorContext)Mockito.verify((Object)context)).containerAlive(containerId);
    }

    private ContainerId createContainerId(ApplicationId applicationId, int containerIdx) {
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)applicationId, (int)1);
        return ContainerId.newInstance((ApplicationAttemptId)appAttemptId, (int)containerIdx);
    }
}

