/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.api.client;

import java.util.List;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.dag.api.DagTypeConverters;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.dag.api.client.DAGStatus;
import org.apache.tez.dag.api.client.ProgressBuilder;
import org.apache.tez.dag.api.records.DAGProtos;
import org.apache.tez.dag.app.dag.DAGState;

public class DAGStatusBuilder
extends DAGStatus {
    public DAGStatusBuilder() {
        super((DAGProtos.DAGStatusProtoOrBuilder)DAGProtos.DAGStatusProto.newBuilder(), null);
    }

    public void setState(DAGState state) {
        this.getBuilder().setState(this.getProtoState(state));
    }

    public void setDiagnostics(List<String> diagnostics) {
        DAGProtos.DAGStatusProto.Builder builder = this.getBuilder();
        builder.clearDiagnostics();
        builder.addAllDiagnostics(diagnostics);
    }

    public void setDAGProgress(ProgressBuilder progress) {
        this.getBuilder().setDAGProgress(progress.getProto());
    }

    public void setDAGCounters(TezCounters counters) {
        this.getBuilder().setDagCounters(DagTypeConverters.convertTezCountersToProto((TezCounters)counters));
    }

    public void addVertexProgress(String name, ProgressBuilder progress) {
        DAGProtos.StringProgressPairProto.Builder builder = DAGProtos.StringProgressPairProto.newBuilder();
        builder.setKey(name);
        builder.setProgress(progress.getProto());
        this.getBuilder().addVertexProgress(builder.build());
    }

    public void setMemoryUsage(long memoryUsedByAM, long memoryUsedByTasks) {
        DAGProtos.DAGStatusProto.Builder builder = this.getBuilder();
        builder.setMemoryUsedByAM(memoryUsedByAM);
        builder.setMemoryUsedByTasks(memoryUsedByTasks);
    }

    public DAGProtos.DAGStatusProto getProto() {
        return this.getBuilder().build();
    }

    private DAGProtos.DAGStatusStateProto getProtoState(DAGState state) {
        switch (state) {
            case NEW: 
            case INITED: {
                return DAGProtos.DAGStatusStateProto.DAG_INITING;
            }
            case RUNNING: {
                return DAGProtos.DAGStatusStateProto.DAG_RUNNING;
            }
            case COMMITTING: {
                return DAGProtos.DAGStatusStateProto.DAG_COMMITTING;
            }
            case SUCCEEDED: {
                return DAGProtos.DAGStatusStateProto.DAG_SUCCEEDED;
            }
            case FAILED: {
                return DAGProtos.DAGStatusStateProto.DAG_FAILED;
            }
            case KILLED: {
                return DAGProtos.DAGStatusStateProto.DAG_KILLED;
            }
            case TERMINATING: {
                return DAGProtos.DAGStatusStateProto.DAG_TERMINATING;
            }
            case ERROR: {
                return DAGProtos.DAGStatusStateProto.DAG_ERROR;
            }
        }
        throw new TezUncheckedException("Unsupported value for DAGState : " + state);
    }

    private DAGProtos.DAGStatusProto.Builder getBuilder() {
        return (DAGProtos.DAGStatusProto.Builder)this.proxy;
    }
}

