/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.test;

import com.google.protobuf.ByteString;
import java.io.IOException;
import java.util.EnumSet;
import java.util.Objects;
import org.apache.hadoop.conf.Configuration;
import org.apache.tez.common.Preconditions;
import org.apache.tez.common.TezUtils;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.dag.api.VertexManagerPluginContext;
import org.apache.tez.dag.api.event.VertexState;
import org.apache.tez.dag.api.event.VertexStateUpdate;
import org.apache.tez.dag.library.vertexmanager.ShuffleVertexManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GraceShuffleVertexManagerForTest
extends ShuffleVertexManager {
    private static final Logger logger = LoggerFactory.getLogger(GraceShuffleVertexManagerForTest.class);
    private GraceConf graceConf;
    private boolean isParallelismSet = false;

    public GraceShuffleVertexManagerForTest(VertexManagerPluginContext context) {
        super(context);
    }

    public void initialize() {
        try {
            Configuration conf = TezUtils.createConfFromUserPayload((UserPayload)this.getContext().getUserPayload());
            this.graceConf = GraceConf.fromConfiguration(conf);
        }
        catch (IOException e) {
            throw new TezUncheckedException((Throwable)e);
        }
        this.getContext().registerForVertexStateUpdates(this.graceConf.grandparentVertex, EnumSet.of(VertexState.SUCCEEDED));
        logger.info("Watching {}", (Object)this.graceConf.grandparentVertex);
        super.initialize();
    }

    public synchronized void onVertexStateUpdated(VertexStateUpdate stateUpdate) {
        logger.info("Received onVertexStateUpdated");
        String vertexName = stateUpdate.getVertexName();
        VertexState vertexState = stateUpdate.getVertexState();
        Preconditions.checkState((this.graceConf != null ? 1 : 0) != 0, (String)"Received state notification {} for vertex {} in vertex {} before manager was initialized", (Object[])new Object[]{vertexState, vertexName, this.getContext().getVertexName()});
        if (!this.shouldSetParallelism(stateUpdate)) {
            return;
        }
        this.getContext().reconfigureVertex(this.graceConf.desiredParallelism, null, null);
        this.isParallelismSet = true;
        logger.info("Initialize parallelism for {} to {}", (Object)this.getContext().getVertexName(), (Object)this.graceConf.desiredParallelism);
    }

    private boolean shouldSetParallelism(VertexStateUpdate update) {
        return !this.isParallelismSet && update.getVertexState().equals((Object)VertexState.SUCCEEDED) && update.getVertexName().equals(this.graceConf.grandparentVertex);
    }

    public static GraceConfBuilder newConfBuilder() {
        return new GraceConfBuilder();
    }

    public static final class GraceConfBuilder {
        private String grandparentVertex;
        private int desiredParallelism;

        private GraceConfBuilder() {
        }

        public GraceConfBuilder setGrandparentVertex(String grandparentVertex) {
            this.grandparentVertex = grandparentVertex;
            return this;
        }

        public GraceConfBuilder setDesiredParallelism(int desiredParallelism) {
            this.desiredParallelism = desiredParallelism;
            return this;
        }

        public ByteString toByteString() throws IOException {
            return TezUtils.createByteStringFromConf((Configuration)this.build().toConfiguration());
        }

        private GraceConf build() {
            Objects.requireNonNull(this.grandparentVertex, "Grandparent vertex is required");
            Preconditions.checkArgument((this.desiredParallelism > 0 ? 1 : 0) != 0, (Object)"Desired parallelism must be greater than 0");
            return new GraceConf(this);
        }
    }

    private static final class GraceConf {
        static final String TEST_GRACE_GRANDPARENT_VERTEX = "test.grace.grandparent-vertex";
        static final String TEST_GRACE_DESIRED_PARALLELISM = "test.grace.desired-parallelism";
        final String grandparentVertex;
        final int desiredParallelism;

        GraceConf(GraceConfBuilder builder) {
            this.grandparentVertex = builder.grandparentVertex;
            this.desiredParallelism = builder.desiredParallelism;
        }

        static GraceConf fromConfiguration(Configuration conf) {
            return GraceShuffleVertexManagerForTest.newConfBuilder().setGrandparentVertex(conf.get(TEST_GRACE_GRANDPARENT_VERTEX)).setDesiredParallelism(conf.getInt(TEST_GRACE_DESIRED_PARALLELISM, -1)).build();
        }

        Configuration toConfiguration() {
            Configuration conf = new Configuration();
            conf.setStrings(TEST_GRACE_GRANDPARENT_VERTEX, new String[]{this.grandparentVertex});
            conf.setInt(TEST_GRACE_DESIRED_PARALLELISM, this.desiredParallelism);
            return conf;
        }
    }
}

