/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.rm.container;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.tez.common.ContainerSignatureMatcher;
import org.apache.tez.dag.app.AppContext;
import org.apache.tez.dag.app.ContainerHeartbeatHandler;
import org.apache.tez.dag.app.TaskCommunicatorManagerInterface;
import org.apache.tez.dag.app.dag.DAG;
import org.apache.tez.dag.app.rm.container.AMContainer;
import org.apache.tez.dag.app.rm.container.AMContainerMap;
import org.apache.tez.dag.app.rm.container.AMContainerState;
import org.apache.tez.dag.app.rm.container.TestAMContainer;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestAMContainerMap {
    @Test(timeout=10000L)
    public void testCleanupOnDagComplete() {
        ContainerHeartbeatHandler chh = (ContainerHeartbeatHandler)Mockito.mock(ContainerHeartbeatHandler.class);
        TaskCommunicatorManagerInterface tal = (TaskCommunicatorManagerInterface)Mockito.mock(TaskCommunicatorManagerInterface.class);
        AppContext appContext = (AppContext)Mockito.mock(AppContext.class);
        Mockito.when((Object)appContext.getAMConf()).thenReturn((Object)new Configuration());
        int numContainers = 7;
        TestAMContainer.WrappedContainer[] wContainers = new TestAMContainer.WrappedContainer[numContainers];
        for (int i = 0; i < numContainers; ++i) {
            TestAMContainer.WrappedContainer wc;
            wContainers[i] = wc = new TestAMContainer.WrappedContainer(false, null, i);
        }
        AMContainerMapForTest amContainerMap = new AMContainerMapForTest(chh, tal, (ContainerSignatureMatcher)Mockito.mock(ContainerSignatureMatcher.class), appContext, wContainers);
        for (int i = 0; i < numContainers; ++i) {
            amContainerMap.addContainerIfNew(wContainers[i].container, 0, 0, 0);
        }
        wContainers[0].launchContainer();
        wContainers[0].verifyState(AMContainerState.LAUNCHING);
        wContainers[1].launchContainer();
        wContainers[1].containerLaunched();
        wContainers[1].verifyState(AMContainerState.IDLE);
        wContainers[2].launchContainer();
        wContainers[2].containerLaunched();
        wContainers[2].assignTaskAttempt(wContainers[2].taskAttemptID);
        wContainers[2].verifyState(AMContainerState.RUNNING);
        wContainers[3].launchContainer();
        wContainers[3].containerLaunched();
        wContainers[3].stopRequest();
        wContainers[3].verifyState(AMContainerState.STOP_REQUESTED);
        wContainers[4].launchContainer();
        wContainers[4].containerLaunched();
        wContainers[4].stopRequest();
        wContainers[4].nmStopSent();
        wContainers[4].verifyState(AMContainerState.STOPPING);
        wContainers[5].launchContainer();
        wContainers[5].containerLaunched();
        wContainers[5].stopRequest();
        wContainers[5].nmStopSent();
        wContainers[5].containerCompleted();
        wContainers[5].verifyState(AMContainerState.COMPLETED);
        wContainers[6].launchContainer();
        wContainers[6].containerLaunched();
        wContainers[6].containerLaunched();
        Assert.assertTrue((boolean)wContainers[6].amContainer.isInErrorState());
        wContainers[6].verifyState(AMContainerState.STOP_REQUESTED);
        Assert.assertEquals((long)7L, (long)amContainerMap.containerMap.size());
        amContainerMap.dagComplete((DAG)Mockito.mock(DAG.class));
        Assert.assertEquals((long)5L, (long)amContainerMap.containerMap.size());
    }

    private static class AMContainerMapForTest
    extends AMContainerMap {
        private TestAMContainer.WrappedContainer[] wrappedContainers;

        public AMContainerMapForTest(ContainerHeartbeatHandler chh, TaskCommunicatorManagerInterface tal, ContainerSignatureMatcher containerSignatureMatcher, AppContext context, TestAMContainer.WrappedContainer[] wrappedContainers) {
            super(chh, tal, containerSignatureMatcher, context);
            this.wrappedContainers = wrappedContainers;
        }

        AMContainer createAmContainer(Container container, ContainerHeartbeatHandler chh, TaskCommunicatorManagerInterface tal, ContainerSignatureMatcher signatureMatcher, AppContext appContext, int schedulerId, int launcherId, int taskCommId, String auxiliaryService) {
            return this.wrappedContainers[container.getId().getId()].amContainer;
        }
    }
}

