/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.test;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.PriorityQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RunnableScheduledFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.tez.dag.app.MockClock;

public class ControlledScheduledExecutorService
implements ScheduledExecutorService,
MockClock.MockClockListener {
    private final MockClock clock;
    private final PriorityQueue<ScheduledFutureTask<?>> queue = new PriorityQueue();
    private final AtomicLong nextSequenceNum = new AtomicLong(0L);
    private final AtomicBoolean stopped = new AtomicBoolean(false);

    public ControlledScheduledExecutorService(MockClock clock) {
        this.clock = clock;
        clock.register(this);
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        ScheduledFutureTask<Object> task = new ScheduledFutureTask<Object>(command, null, this.toTimestamp(delay, unit));
        this.schedule(task);
        return task;
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        ScheduledFutureTask<V> task = new ScheduledFutureTask<V>(callable, this.toTimestamp(delay, unit));
        this.schedule(task);
        return task;
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        ScheduledFutureTask<Object> task = new ScheduledFutureTask<Object>(command, null, this.toTimestamp(initialDelay, unit), unit.toMillis(delay));
        this.schedule(task);
        return task;
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return this.scheduleWithFixedDelay(command, initialDelay, period, unit);
    }

    @Override
    public <T> Future<T> submit(Callable<T> callable) {
        ScheduledFutureTask<T> task = new ScheduledFutureTask<T>(callable, 0L);
        this.schedule(task);
        return task;
    }

    @Override
    public <T> Future<T> submit(Runnable runnable, T result) {
        ScheduledFutureTask<T> task = new ScheduledFutureTask<T>(runnable, result, 0L);
        this.schedule(task);
        return task;
    }

    @Override
    public Future<?> submit(Runnable runnable) {
        ScheduledFutureTask<Object> task = new ScheduledFutureTask<Object>(runnable, null, 0L);
        this.schedule(task);
        return task;
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) {
        throw new UnsupportedOperationException("invokeAll not yet implemented");
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        throw new UnsupportedOperationException("invokeAll not yet implemented");
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        throw new UnsupportedOperationException("invokeAny not yet implemented");
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        throw new UnsupportedOperationException("invokeAny not yet implemented");
    }

    @Override
    public void execute(Runnable command) {
        this.submit(command);
    }

    @Override
    public void shutdown() {
        this.stopped.set(true);
    }

    @Override
    public List<Runnable> shutdownNow() {
        this.stopped.set(true);
        return new ArrayList<Runnable>(this.queue);
    }

    @Override
    public boolean isShutdown() {
        return this.stopped.get();
    }

    @Override
    public boolean isTerminated() {
        return false;
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return false;
    }

    @Override
    public void onTimeUpdated(long newTime) {
        ScheduledFutureTask<?> task = this.queue.peek();
        while (task != null && task.timestamp <= newTime) {
            task = this.queue.poll();
            this.runTask(task);
            task = this.queue.peek();
        }
    }

    private long now() {
        return this.clock.getTime();
    }

    private long toTimestamp(long delay, TimeUnit unit) {
        return this.now() + unit.toMillis(delay);
    }

    private void schedule(ScheduledFutureTask<?> task) {
        if (this.isShutdown()) {
            throw new RejectedExecutionException("Executor has been shutdown");
        }
        if (this.now() - task.timestamp >= 0L) {
            this.runTask(task);
        } else {
            this.queue.add(task);
        }
    }

    private void runTask(ScheduledFutureTask<?> task) {
        task.run();
        if (task.isPeriodic() && !this.isShutdown()) {
            task.timestamp = this.toTimestamp(task.period, TimeUnit.MILLISECONDS);
            this.queue.add(task);
        }
    }

    private class ScheduledFutureTask<V>
    extends FutureTask<V>
    implements RunnableScheduledFuture<V> {
        private final long sequenceNum;
        private final long period;
        private long timestamp;

        public ScheduledFutureTask(Callable<V> callable, long timestamp) {
            super(callable);
            this.sequenceNum = ControlledScheduledExecutorService.this.nextSequenceNum.getAndIncrement();
            this.timestamp = timestamp;
            this.period = 0L;
        }

        public ScheduledFutureTask(Runnable runnable, V result, long timestamp) {
            super(runnable, result);
            this.sequenceNum = ControlledScheduledExecutorService.this.nextSequenceNum.getAndIncrement();
            this.timestamp = timestamp;
            this.period = 0L;
        }

        public ScheduledFutureTask(Runnable runnable, V result, long timestamp, long period) {
            super(runnable, result);
            this.sequenceNum = ControlledScheduledExecutorService.this.nextSequenceNum.getAndIncrement();
            this.timestamp = timestamp;
            this.period = period;
        }

        @Override
        public boolean isPeriodic() {
            return this.period != 0L;
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return unit.convert(this.timestamp - ControlledScheduledExecutorService.this.now(), TimeUnit.MILLISECONDS);
        }

        @Override
        public int compareTo(Delayed o) {
            if (o == this) {
                return 0;
            }
            int result = Long.compare(this.getDelay(TimeUnit.MILLISECONDS), o.getDelay(TimeUnit.MILLISECONDS));
            if (result == 0 && o instanceof ScheduledFutureTask) {
                ScheduledFutureTask otherTask = (ScheduledFutureTask)o;
                result = Long.compare(this.sequenceNum, otherTask.sequenceNum);
            }
            return result;
        }
    }
}

