/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.dag.impl;

import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.tez.dag.api.oldrecords.TaskReport;
import org.apache.tez.dag.api.oldrecords.TaskState;
import org.apache.tez.dag.app.dag.impl.TaskReportImpl;
import org.apache.tez.dag.app.dag.impl.VertexStats;
import org.apache.tez.dag.records.TezDAGID;
import org.apache.tez.dag.records.TezTaskID;
import org.apache.tez.dag.records.TezVertexID;
import org.junit.Assert;
import org.junit.Test;

public class TestVertexStats {
    @Test(timeout=5000L)
    public void testBasicStats() {
        VertexStats stats = new VertexStats();
        Assert.assertEquals((long)-1L, (long)stats.firstTaskStartTime);
        Assert.assertEquals((long)-1L, (long)stats.lastTaskFinishTime);
        Assert.assertEquals((long)-1L, (long)stats.minTaskDuration);
        Assert.assertEquals((long)-1L, (long)stats.maxTaskDuration);
        Assert.assertTrue((-1.0 == stats.avgTaskDuration ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)stats.getFirstTasksToStart().size());
        Assert.assertEquals((long)0L, (long)stats.getLastTasksToFinish().size());
        Assert.assertEquals((long)0L, (long)stats.getShortestDurationTasks().size());
        Assert.assertEquals((long)0L, (long)stats.getLongestDurationTasks().size());
        TezVertexID tezVertexID = TezVertexID.getInstance((TezDAGID)TezDAGID.getInstance((ApplicationId)ApplicationId.newInstance((long)100L, (int)1), (int)1), (int)1);
        TezTaskID tezTaskID1 = TezTaskID.getInstance((TezVertexID)tezVertexID, (int)1);
        TezTaskID tezTaskID2 = TezTaskID.getInstance((TezVertexID)tezVertexID, (int)2);
        TezTaskID tezTaskID3 = TezTaskID.getInstance((TezVertexID)tezVertexID, (int)3);
        TezTaskID tezTaskID4 = TezTaskID.getInstance((TezVertexID)tezVertexID, (int)4);
        TezTaskID tezTaskID5 = TezTaskID.getInstance((TezVertexID)tezVertexID, (int)5);
        TezTaskID tezTaskID6 = TezTaskID.getInstance((TezVertexID)tezVertexID, (int)6);
        stats.updateStats((TaskReport)new TaskReportImpl(tezTaskID1, TaskState.SUCCEEDED, 1.0f, 100L, 200L));
        Assert.assertEquals((long)100L, (long)stats.firstTaskStartTime);
        Assert.assertEquals((long)200L, (long)stats.lastTaskFinishTime);
        Assert.assertEquals((long)100L, (long)stats.minTaskDuration);
        Assert.assertEquals((long)100L, (long)stats.maxTaskDuration);
        Assert.assertTrue((100.0 == stats.avgTaskDuration ? 1 : 0) != 0);
        Assert.assertTrue((boolean)stats.firstTasksToStart.contains(tezTaskID1));
        Assert.assertTrue((boolean)stats.lastTasksToFinish.contains(tezTaskID1));
        Assert.assertTrue((boolean)stats.shortestDurationTasks.contains(tezTaskID1));
        Assert.assertTrue((boolean)stats.longestDurationTasks.contains(tezTaskID1));
        Assert.assertEquals((long)1L, (long)stats.firstTasksToStart.size());
        Assert.assertEquals((long)1L, (long)stats.lastTasksToFinish.size());
        Assert.assertEquals((long)1L, (long)stats.shortestDurationTasks.size());
        Assert.assertEquals((long)1L, (long)stats.longestDurationTasks.size());
        stats.updateStats((TaskReport)new TaskReportImpl(tezTaskID2, TaskState.FAILED, 1.0f, 150L, 300L));
        Assert.assertEquals((long)100L, (long)stats.firstTaskStartTime);
        Assert.assertEquals((long)300L, (long)stats.lastTaskFinishTime);
        Assert.assertEquals((long)100L, (long)stats.minTaskDuration);
        Assert.assertEquals((long)100L, (long)stats.maxTaskDuration);
        Assert.assertTrue((100.0 == stats.avgTaskDuration ? 1 : 0) != 0);
        Assert.assertTrue((boolean)stats.firstTasksToStart.contains(tezTaskID1));
        Assert.assertTrue((boolean)stats.lastTasksToFinish.contains(tezTaskID2));
        Assert.assertTrue((boolean)stats.shortestDurationTasks.contains(tezTaskID1));
        Assert.assertTrue((boolean)stats.longestDurationTasks.contains(tezTaskID1));
        Assert.assertEquals((long)1L, (long)stats.firstTasksToStart.size());
        Assert.assertEquals((long)1L, (long)stats.lastTasksToFinish.size());
        Assert.assertEquals((long)1L, (long)stats.shortestDurationTasks.size());
        Assert.assertEquals((long)1L, (long)stats.longestDurationTasks.size());
        stats.updateStats((TaskReport)new TaskReportImpl(tezTaskID3, TaskState.RUNNING, 1.0f, 50L, 550L));
        Assert.assertEquals((long)50L, (long)stats.firstTaskStartTime);
        Assert.assertEquals((long)550L, (long)stats.lastTaskFinishTime);
        Assert.assertEquals((long)100L, (long)stats.minTaskDuration);
        Assert.assertEquals((long)100L, (long)stats.maxTaskDuration);
        Assert.assertTrue((100.0 == stats.avgTaskDuration ? 1 : 0) != 0);
        Assert.assertTrue((boolean)stats.shortestDurationTasks.contains(tezTaskID1));
        Assert.assertTrue((boolean)stats.longestDurationTasks.contains(tezTaskID1));
        Assert.assertTrue((boolean)stats.firstTasksToStart.contains(tezTaskID3));
        Assert.assertTrue((boolean)stats.lastTasksToFinish.contains(tezTaskID3));
        Assert.assertEquals((long)1L, (long)stats.firstTasksToStart.size());
        Assert.assertEquals((long)1L, (long)stats.lastTasksToFinish.size());
        Assert.assertEquals((long)1L, (long)stats.shortestDurationTasks.size());
        Assert.assertEquals((long)1L, (long)stats.longestDurationTasks.size());
        stats.updateStats((TaskReport)new TaskReportImpl(tezTaskID4, TaskState.SUCCEEDED, 1.0f, 50L, 450L));
        Assert.assertEquals((long)50L, (long)stats.firstTaskStartTime);
        Assert.assertEquals((long)550L, (long)stats.lastTaskFinishTime);
        Assert.assertEquals((long)100L, (long)stats.minTaskDuration);
        Assert.assertEquals((long)400L, (long)stats.maxTaskDuration);
        Assert.assertTrue((250.0 == stats.avgTaskDuration ? 1 : 0) != 0);
        Assert.assertTrue((boolean)stats.firstTasksToStart.contains(tezTaskID4));
        Assert.assertTrue((boolean)stats.firstTasksToStart.contains(tezTaskID3));
        Assert.assertTrue((boolean)stats.lastTasksToFinish.contains(tezTaskID3));
        Assert.assertTrue((boolean)stats.shortestDurationTasks.contains(tezTaskID1));
        Assert.assertTrue((boolean)stats.longestDurationTasks.contains(tezTaskID4));
        Assert.assertEquals((long)2L, (long)stats.firstTasksToStart.size());
        Assert.assertEquals((long)1L, (long)stats.lastTasksToFinish.size());
        Assert.assertEquals((long)1L, (long)stats.shortestDurationTasks.size());
        Assert.assertEquals((long)1L, (long)stats.longestDurationTasks.size());
        stats.updateStats((TaskReport)new TaskReportImpl(tezTaskID5, TaskState.SUCCEEDED, 1.0f, 50L, 450L));
        Assert.assertEquals((long)50L, (long)stats.firstTaskStartTime);
        Assert.assertEquals((long)550L, (long)stats.lastTaskFinishTime);
        Assert.assertEquals((long)100L, (long)stats.minTaskDuration);
        Assert.assertEquals((long)400L, (long)stats.maxTaskDuration);
        Assert.assertTrue((300.0 == stats.avgTaskDuration ? 1 : 0) != 0);
        Assert.assertTrue((boolean)stats.firstTasksToStart.contains(tezTaskID5));
        Assert.assertTrue((boolean)stats.firstTasksToStart.contains(tezTaskID4));
        Assert.assertTrue((boolean)stats.firstTasksToStart.contains(tezTaskID3));
        Assert.assertTrue((boolean)stats.lastTasksToFinish.contains(tezTaskID3));
        Assert.assertTrue((boolean)stats.shortestDurationTasks.contains(tezTaskID1));
        Assert.assertTrue((boolean)stats.longestDurationTasks.contains(tezTaskID4));
        Assert.assertTrue((boolean)stats.longestDurationTasks.contains(tezTaskID5));
        Assert.assertEquals((long)3L, (long)stats.firstTasksToStart.size());
        Assert.assertEquals((long)1L, (long)stats.lastTasksToFinish.size());
        Assert.assertEquals((long)1L, (long)stats.shortestDurationTasks.size());
        Assert.assertEquals((long)2L, (long)stats.longestDurationTasks.size());
        stats.updateStats((TaskReport)new TaskReportImpl(tezTaskID6, TaskState.SUCCEEDED, 1.0f, 450L, 550L));
        Assert.assertEquals((long)50L, (long)stats.firstTaskStartTime);
        Assert.assertEquals((long)550L, (long)stats.lastTaskFinishTime);
        Assert.assertEquals((long)100L, (long)stats.minTaskDuration);
        Assert.assertEquals((long)400L, (long)stats.maxTaskDuration);
        Assert.assertTrue((250.0 == stats.avgTaskDuration ? 1 : 0) != 0);
        Assert.assertTrue((boolean)stats.firstTasksToStart.contains(tezTaskID5));
        Assert.assertTrue((boolean)stats.firstTasksToStart.contains(tezTaskID4));
        Assert.assertTrue((boolean)stats.firstTasksToStart.contains(tezTaskID3));
        Assert.assertTrue((boolean)stats.lastTasksToFinish.contains(tezTaskID3));
        Assert.assertTrue((boolean)stats.lastTasksToFinish.contains(tezTaskID6));
        Assert.assertTrue((boolean)stats.shortestDurationTasks.contains(tezTaskID1));
        Assert.assertTrue((boolean)stats.shortestDurationTasks.contains(tezTaskID6));
        Assert.assertTrue((boolean)stats.longestDurationTasks.contains(tezTaskID4));
        Assert.assertTrue((boolean)stats.longestDurationTasks.contains(tezTaskID5));
        Assert.assertEquals((long)3L, (long)stats.firstTasksToStart.size());
        Assert.assertEquals((long)2L, (long)stats.lastTasksToFinish.size());
        Assert.assertEquals((long)2L, (long)stats.shortestDurationTasks.size());
        Assert.assertEquals((long)2L, (long)stats.longestDurationTasks.size());
    }
}

