/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.history.events;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.MessageLite;
import java.io.IOException;
import java.util.Map;
import org.apache.tez.dag.history.HistoryEvent;
import org.apache.tez.dag.history.HistoryEventType;
import org.apache.tez.dag.records.DAGIDAware;
import org.apache.tez.dag.records.TezDAGID;
import org.apache.tez.dag.records.TezVertexID;
import org.apache.tez.dag.recovery.records.RecoveryProtos;

public class DAGInitializedEvent
implements HistoryEvent,
DAGIDAware {
    private TezDAGID dagID;
    private long initTime;
    private String user;
    private String dagName;
    private Map<String, TezVertexID> vertexNameIDMap;

    public DAGInitializedEvent() {
    }

    public DAGInitializedEvent(TezDAGID dagID, long initTime, String user, String dagName, Map<String, TezVertexID> vertexNameIDMap) {
        this.dagID = dagID;
        this.initTime = initTime;
        this.user = user;
        this.dagName = dagName;
        this.vertexNameIDMap = vertexNameIDMap;
    }

    @Override
    public HistoryEventType getEventType() {
        return HistoryEventType.DAG_INITIALIZED;
    }

    @Override
    public boolean isRecoveryEvent() {
        return true;
    }

    @Override
    public boolean isHistoryEvent() {
        return true;
    }

    public String toString() {
        return "dagID=" + this.dagID + ", initTime=" + this.initTime;
    }

    public RecoveryProtos.DAGInitializedProto toProto() {
        return RecoveryProtos.DAGInitializedProto.newBuilder().setDagId(this.dagID.toString()).setInitTime(this.initTime).build();
    }

    public void fromProto(RecoveryProtos.DAGInitializedProto proto) {
        this.dagID = TezDAGID.fromString((String)proto.getDagId());
        this.initTime = proto.getInitTime();
    }

    @Override
    public void toProtoStream(CodedOutputStream outputStream) throws IOException {
        outputStream.writeMessageNoTag((MessageLite)this.toProto());
    }

    @Override
    public void fromProtoStream(CodedInputStream inputStream) throws IOException {
        RecoveryProtos.DAGInitializedProto proto = (RecoveryProtos.DAGInitializedProto)inputStream.readMessage(RecoveryProtos.DAGInitializedProto.PARSER, ExtensionRegistryLite.getEmptyRegistry());
        if (proto == null) {
            throw new IOException("No data found in stream");
        }
        this.fromProto(proto);
    }

    public long getInitTime() {
        return this.initTime;
    }

    public TezDAGID getDAGID() {
        return this.dagID;
    }

    public String getUser() {
        return this.user;
    }

    public String getDagName() {
        return this.dagName;
    }

    public Map<String, TezVertexID> getVertexNameIDMap() {
        return this.vertexNameIDMap;
    }
}

