/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.rm;

import java.util.LinkedHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.dag.app.rm.LocalTaskSchedulerService;
import org.apache.tez.dag.app.rm.TestTaskSchedulerHelpers;
import org.apache.tez.serviceplugins.api.TaskSchedulerContext;
import org.junit.Assert;
import org.junit.Test;

public class TestLocalTaskScheduler {
    @Test(timeout=5000L)
    public void maxTasksAllocationsCannotBeExceeded() {
        int i;
        int MAX_TASKS = 4;
        TezConfiguration tezConf = new TezConfiguration();
        tezConf.setInt("tez.am.inline.task.execution.max-tasks", 4);
        ApplicationId appId = ApplicationId.newInstance((long)2000L, (int)1);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1);
        TaskSchedulerContext mockContext = TestTaskSchedulerHelpers.setupMockTaskSchedulerContext("", 0, "", true, appAttemptId, 1000L, null, new Configuration());
        LocalTaskSchedulerService.LocalContainerFactory containerFactory = new LocalTaskSchedulerService.LocalContainerFactory(appAttemptId, 1000L);
        LinkedHashMap taskAllocations = new LinkedHashMap();
        LinkedBlockingQueue clientRequestQueue = new LinkedBlockingQueue();
        LocalTaskSchedulerService.AsyncDelegateRequestHandler requestHandler = new LocalTaskSchedulerService.AsyncDelegateRequestHandler(clientRequestQueue, containerFactory, taskAllocations, mockContext, (Configuration)tezConf);
        for (i = 0; i < 4; ++i) {
            Priority priority = Priority.newInstance((int)20);
            requestHandler.addAllocateTaskRequest((Object)new Long(i), null, priority, null);
            requestHandler.dispatchRequest();
            requestHandler.allocateTask();
        }
        Assert.assertEquals((String)"Wrong number of allocate tasks", (long)4L, (long)taskAllocations.size());
        Assert.assertTrue((String)"Another allocation should not fit", (!requestHandler.shouldProcess() ? 1 : 0) != 0);
        for (i = 0; i < 4; ++i) {
            requestHandler.addDeallocateTaskRequest((Object)new Long(i));
            requestHandler.dispatchRequest();
        }
        Assert.assertEquals((String)"Wrong number of allocate tasks", (long)0L, (long)taskAllocations.size());
    }
}

