/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.common;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.tez.common.AsyncDispatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DrainDispatcher
extends AsyncDispatcher {
    static final String DEFAULT_NAME = "dispatcher";
    private volatile boolean drained = false;
    private volatile boolean stopped = false;
    private final BlockingQueue<Event> queue;
    private final Object mutex;
    private static final Logger LOG = LoggerFactory.getLogger(DrainDispatcher.class);

    public DrainDispatcher() {
        this(DEFAULT_NAME, new LinkedBlockingQueue<Event>());
    }

    public DrainDispatcher(String name, BlockingQueue<Event> eventQueue) {
        super(name, eventQueue);
        this.queue = eventQueue;
        this.mutex = this;
    }

    public void register(Class<? extends Enum> eventType, EventHandler handler) {
        EventHandler registeredHandler = (EventHandler)this.eventHandlers.get(eventType);
        this.checkForExistingDispatchers(false, eventType);
        LOG.info("Registering " + eventType + " for " + handler.getClass());
        if (registeredHandler == null) {
            this.eventHandlers.put(eventType, handler);
        } else if (!(registeredHandler instanceof AsyncDispatcher.MultiListenerHandler)) {
            AsyncDispatcher.MultiListenerHandler multiHandler = new AsyncDispatcher.MultiListenerHandler();
            multiHandler.addHandler(registeredHandler);
            multiHandler.addHandler(handler);
            this.eventHandlers.put(eventType, multiHandler);
        } else {
            AsyncDispatcher.MultiListenerHandler multiHandler = (AsyncDispatcher.MultiListenerHandler)registeredHandler;
            multiHandler.addHandler(handler);
        }
    }

    public void await() {
        while (!this.drained) {
            Thread.yield();
        }
    }

    public Runnable createThread() {
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (!DrainDispatcher.this.stopped && !Thread.currentThread().isInterrupted()) {
                    Event event;
                    Object object = DrainDispatcher.this.mutex;
                    synchronized (object) {
                        DrainDispatcher.this.drained = DrainDispatcher.this.queue.isEmpty();
                    }
                    try {
                        event = DrainDispatcher.this.queue.take();
                    }
                    catch (InterruptedException ie) {
                        return;
                    }
                    if (event == null) continue;
                    DrainDispatcher.this.dispatch(event);
                }
            }
        };
    }

    public EventHandler getEventHandler() {
        final EventHandler actual = super.getEventHandler();
        return new EventHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handle(Event event) {
                Object object = DrainDispatcher.this.mutex;
                synchronized (object) {
                    actual.handle(event);
                    DrainDispatcher.this.drained = false;
                }
            }
        };
    }

    protected void serviceStop() throws Exception {
        this.stopped = true;
        super.serviceStop();
    }
}

