/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.net.CachedDNSToSwitchMapping;
import org.apache.hadoop.net.DNSToSwitchMapping;
import org.apache.hadoop.yarn.util.RackResolver;

public class MockDNSToSwitchMapping
extends CachedDNSToSwitchMapping
implements DNSToSwitchMapping {
    private static final Map<String, String> rackMap = Collections.synchronizedMap(new HashMap());
    private final String defaultRack = "/default-rack";

    public MockDNSToSwitchMapping() {
        super(null);
    }

    public List<String> resolve(List<String> strings) {
        ArrayList<String> resolvedHosts = new ArrayList<String>();
        for (String h : strings) {
            String rack = rackMap.get(h);
            if (rack == null) {
                rack = "/default-rack";
            }
            resolvedHosts.add(rack);
        }
        return resolvedHosts;
    }

    public void reloadCachedMappings() {
    }

    public void reloadCachedMappings(List<String> strings) {
    }

    public static void initializeMockRackResolver() {
        Configuration rackResolverConf = new Configuration(false);
        rackResolverConf.set("net.topology.node.switch.mapping.impl", MockDNSToSwitchMapping.class.getName());
        RackResolver.init((Configuration)rackResolverConf);
    }

    public static void addRackMapping(String host, String rack) {
        rackMap.put(host, rack);
    }
}

