/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.common.security;

import com.google.common.collect.Sets;
import org.apache.hadoop.conf.Configuration;
import org.apache.tez.common.security.DAGAccessControls;
import org.junit.Assert;
import org.junit.Test;

public class TestDAGAccessControls {
    @Test(timeout=5000L)
    public void testStringBasedConstructor() {
        DAGAccessControls dagAccessControls = new DAGAccessControls("u1 g1", "u2 g2");
        Assert.assertEquals((long)1L, (long)dagAccessControls.getUsersWithViewACLs().size());
        Assert.assertEquals((long)1L, (long)dagAccessControls.getUsersWithModifyACLs().size());
        Assert.assertEquals((long)1L, (long)dagAccessControls.getGroupsWithViewACLs().size());
        Assert.assertEquals((long)1L, (long)dagAccessControls.getGroupsWithModifyACLs().size());
        Assert.assertTrue((boolean)dagAccessControls.getUsersWithViewACLs().contains("u1"));
        Assert.assertTrue((boolean)dagAccessControls.getUsersWithModifyACLs().contains("u2"));
        Assert.assertTrue((boolean)dagAccessControls.getGroupsWithViewACLs().contains("g1"));
        Assert.assertTrue((boolean)dagAccessControls.getGroupsWithModifyACLs().contains("g2"));
    }

    @Test(timeout=5000L)
    public void testMergeIntoAmAcls() {
        DAGAccessControls dagAccessControls = new DAGAccessControls("u1 g1", "u2 g2");
        Configuration conf = new Configuration(false);
        dagAccessControls.mergeIntoAmAcls(conf);
        this.assertACLS("u1 g1", conf.get("tez.am.view-acls"));
        this.assertACLS("u2 g2", conf.get("tez.am.modify-acls"));
        conf.set("tez.am.view-acls", "u1 g1");
        conf.set("tez.am.modify-acls", "u2 g2");
        dagAccessControls.mergeIntoAmAcls(conf);
        this.assertACLS("u1 g1", conf.get("tez.am.view-acls"));
        this.assertACLS("u2 g2", conf.get("tez.am.modify-acls"));
        conf.set("tez.am.view-acls", "u3 g3");
        conf.set("tez.am.modify-acls", "u4 g4");
        dagAccessControls.mergeIntoAmAcls(conf);
        this.assertACLS("u3,u1 g3,g1", conf.get("tez.am.view-acls"));
        this.assertACLS("u4,u2 g4,g2", conf.get("tez.am.modify-acls"));
        conf.set("tez.am.view-acls", "*,u3 g3");
        conf.set("tez.am.modify-acls", "*,u4 g4");
        dagAccessControls.mergeIntoAmAcls(conf);
        this.assertACLS("*", conf.get("tez.am.view-acls"));
        this.assertACLS("*", conf.get("tez.am.modify-acls"));
        conf.set("tez.am.view-acls", "*");
        conf.set("tez.am.modify-acls", "*");
        dagAccessControls.mergeIntoAmAcls(conf);
        this.assertACLS("*", conf.get("tez.am.view-acls"));
        this.assertACLS("*", conf.get("tez.am.modify-acls"));
        dagAccessControls = new DAGAccessControls("*", "*");
        conf.set("tez.am.view-acls", "u3 g3");
        conf.set("tez.am.modify-acls", "u4 g4");
        dagAccessControls.mergeIntoAmAcls(conf);
        this.assertACLS("*", conf.get("tez.am.view-acls"));
        this.assertACLS("*", conf.get("tez.am.modify-acls"));
        conf.set("tez.am.view-acls", "*,u3 g3");
        conf.set("tez.am.modify-acls", "*,u4 g4");
        dagAccessControls.mergeIntoAmAcls(conf);
        this.assertACLS("*", conf.get("tez.am.view-acls"));
        this.assertACLS("*", conf.get("tez.am.modify-acls"));
        conf.set("tez.am.view-acls", "*");
        conf.set("tez.am.modify-acls", "*");
        dagAccessControls.mergeIntoAmAcls(conf);
        this.assertACLS("*", conf.get("tez.am.view-acls"));
        this.assertACLS("*", conf.get("tez.am.modify-acls"));
        dagAccessControls = new DAGAccessControls("", "");
        conf.set("tez.am.view-acls", "u3 g3");
        conf.set("tez.am.modify-acls", "u4 g4");
        dagAccessControls.mergeIntoAmAcls(conf);
        this.assertACLS("u3 g3", conf.get("tez.am.view-acls"));
        this.assertACLS("u4 g4", conf.get("tez.am.modify-acls"));
        conf.set("tez.am.view-acls", "*,u3 g3");
        conf.set("tez.am.modify-acls", "*,u4 g4");
        dagAccessControls.mergeIntoAmAcls(conf);
        this.assertACLS("*", conf.get("tez.am.view-acls"));
        this.assertACLS("*", conf.get("tez.am.modify-acls"));
        conf.set("tez.am.view-acls", "*");
        conf.set("tez.am.modify-acls", "*");
        dagAccessControls.mergeIntoAmAcls(conf);
        this.assertACLS("*", conf.get("tez.am.view-acls"));
        this.assertACLS("*", conf.get("tez.am.modify-acls"));
    }

    public void assertACLS(String expected, String obtained) {
        if (expected.equals(obtained)) {
            return;
        }
        String[] parts1 = expected.split(" ");
        String[] parts2 = obtained.split(" ");
        Assert.assertEquals((long)parts1.length, (long)parts2.length);
        Assert.assertEquals((Object)Sets.newHashSet((Object[])parts1[0].split(",")), (Object)Sets.newHashSet((Object[])parts2[0].split(",")));
        if (parts1.length < 2) {
            return;
        }
        Assert.assertEquals((Object)Sets.newHashSet((Object[])parts1[1].split(",")), (Object)Sets.newHashSet((Object[])parts2[1].split(",")));
    }
}

