/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.client;

import java.io.DataInput;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.io.DataInputByteBuffer;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceVisibility;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.util.Records;
import org.apache.tez.client.AMConfiguration;
import org.apache.tez.client.TezApiVersionInfo;
import org.apache.tez.client.TezClientUtils;
import org.apache.tez.common.security.JobTokenSecretManager;
import org.apache.tez.common.security.TokenCache;
import org.apache.tez.dag.api.DAG;
import org.apache.tez.dag.api.ProcessorDescriptor;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.dag.api.Vertex;
import org.apache.tez.dag.api.records.DAGProtos;
import org.apache.tez.serviceplugins.api.ServicePluginsDescriptor;
import org.junit.Assert;
import org.junit.Test;

public class TestTezClientUtils {
    private static String TEST_ROOT_DIR = "target/" + TestTezClientUtils.class.getName() + "-tmpDir";
    private static final File STAGING_DIR = new File(System.getProperty("test.build.data", "target"), TestTezClientUtils.class.getName()).getAbsoluteFile();

    @Test(timeout=5000L)
    public void validateSetTezJarLocalResourcesNotDefined() throws Exception {
        TezConfiguration conf = new TezConfiguration(false);
        Credentials credentials = new Credentials();
        try {
            HashMap resources = new HashMap();
            TezClientUtils.setupTezJarsLocalResources((TezConfiguration)conf, (Credentials)credentials, resources);
            Assert.fail((String)"Expected TezUncheckedException");
        }
        catch (TezUncheckedException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Invalid configuration of tez jars"));
        }
    }

    @Test(timeout=5000L)
    public void validateSetTezJarLocalResourcesDefinedButEmpty() throws Exception {
        File emptyDir = new File(TEST_ROOT_DIR, "emptyDir");
        emptyDir.deleteOnExit();
        Assert.assertTrue((boolean)emptyDir.mkdirs());
        TezConfiguration conf = new TezConfiguration();
        conf.set("tez.lib.uris", emptyDir.toURI().toURL().toString());
        Credentials credentials = new Credentials();
        try {
            HashMap resources = new HashMap();
            TezClientUtils.setupTezJarsLocalResources((TezConfiguration)conf, (Credentials)credentials, resources);
            Assert.fail((String)"Expected TezUncheckedException");
        }
        catch (TezUncheckedException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("No files found in locations"));
        }
    }

    @Test(expected=FileNotFoundException.class, timeout=5000L)
    public void validateSetTezJarLocalResourcesDefinedNonExistingDirectory() throws Exception {
        TezConfiguration conf = new TezConfiguration();
        conf.set("tez.lib.uris", "file:///foo");
        Credentials credentials = new Credentials();
        HashMap resources = new HashMap();
        TezClientUtils.setupTezJarsLocalResources((TezConfiguration)conf, (Credentials)credentials, resources);
    }

    private static List<URL> getDirAndFileURL() throws MalformedURLException {
        String[] classpaths = System.getProperty("java.class.path").split(System.getProperty("path.separator"));
        ArrayList<URL> urls = new ArrayList<URL>(2);
        File lastFile = null;
        for (String path : classpaths) {
            URL url = new URL("file://" + path);
            File file = FileUtils.toFile((URL)url);
            if (lastFile == null) {
                lastFile = file;
                urls.add(url);
                continue;
            }
            if (lastFile.isDirectory() == file.isDirectory()) continue;
            urls.add(url);
            break;
        }
        return urls;
    }

    @Test(timeout=20000L)
    public void validateSetTezJarLocalResourcesDefinedExistingDirectory() throws Exception {
        List<URL> cp = TestTezClientUtils.getDirAndFileURL();
        StringBuffer buffer = new StringBuffer();
        for (URL url : cp) {
            buffer.append(url.toExternalForm());
            buffer.append(",");
        }
        TezConfiguration conf = new TezConfiguration();
        conf.set("tez.lib.uris", buffer.toString());
        Credentials credentials = new Credentials();
        HashMap localizedMap = new HashMap();
        boolean usingArchive = TezClientUtils.setupTezJarsLocalResources((TezConfiguration)conf, (Credentials)credentials, localizedMap);
        Assert.assertFalse((boolean)usingArchive);
        Set resourceNames = localizedMap.keySet();
        boolean assertedDir = false;
        boolean assertedFile = false;
        for (URL url : cp) {
            File file = FileUtils.toFile((URL)url);
            if (file.isDirectory()) {
                String[] firList;
                for (String fileNme : firList = file.list()) {
                    File innerFile = new File(file, fileNme);
                    if (innerFile.isDirectory()) continue;
                    Assert.assertTrue((boolean)resourceNames.contains(innerFile.getName()));
                    assertedDir = true;
                }
                continue;
            }
            Assert.assertTrue((boolean)resourceNames.contains(file.getName()));
            assertedFile = true;
        }
        Assert.assertTrue((boolean)assertedDir);
        Assert.assertTrue((boolean)assertedFile);
    }

    @Test(timeout=5000L)
    public void validateSetTezJarLocalResourcesDefinedExistingDirectoryIgnored() throws Exception {
        List<URL> cp = TestTezClientUtils.getDirAndFileURL();
        StringBuffer buffer = new StringBuffer();
        for (URL url : cp) {
            buffer.append(url.toExternalForm());
            buffer.append(",");
        }
        TezConfiguration conf = new TezConfiguration();
        conf.set("tez.lib.uris", buffer.toString());
        conf.setBoolean("tez.ignore.lib.uris", true);
        Credentials credentials = new Credentials();
        HashMap localizedMap = new HashMap();
        Assert.assertFalse((boolean)TezClientUtils.setupTezJarsLocalResources((TezConfiguration)conf, (Credentials)credentials, localizedMap));
        Assert.assertTrue((boolean)localizedMap.isEmpty());
    }

    @Test(timeout=20000L)
    public void validateSetTezJarLocalResourcesDefinedExistingDirectoryIgnoredSetToFalse() throws Exception {
        List<URL> cp = TestTezClientUtils.getDirAndFileURL();
        StringBuffer buffer = new StringBuffer();
        for (URL url : cp) {
            buffer.append(url.toExternalForm());
            buffer.append(",");
        }
        TezConfiguration conf = new TezConfiguration();
        conf.set("tez.lib.uris", buffer.toString());
        conf.setBoolean("tez.ignore.lib.uris", false);
        Credentials credentials = new Credentials();
        HashMap localizedMap = new HashMap();
        Assert.assertFalse((boolean)TezClientUtils.setupTezJarsLocalResources((TezConfiguration)conf, (Credentials)credentials, localizedMap));
        Assert.assertFalse((boolean)localizedMap.isEmpty());
    }

    @Test(timeout=5000L)
    public void testTezDefaultFS() throws Exception {
        LocalFileSystem localFs = FileSystem.getLocal((Configuration)new Configuration());
        StringBuilder tezLibUris = new StringBuilder();
        Path topDir = new Path(TEST_ROOT_DIR, "testTezDefaultFS");
        if (localFs.exists(topDir)) {
            localFs.delete(topDir, true);
        }
        localFs.mkdirs(topDir);
        Path file = new Path(topDir, "file.jar");
        Assert.assertTrue((boolean)localFs.createNewFile(file));
        tezLibUris.append(localFs.makeQualified(file).toString());
        TezConfiguration conf = new TezConfiguration();
        conf.set("tez.lib.uris", tezLibUris.toString());
        conf.set("fs.defaultFS", "hdfs:///localhost:1234");
        Credentials credentials = new Credentials();
        HashMap localizedMap = new HashMap();
        TezClientUtils.setupTezJarsLocalResources((TezConfiguration)conf, (Credentials)credentials, localizedMap);
        Assert.assertTrue((boolean)localFs.delete(file, true));
        Assert.assertTrue((boolean)localFs.delete(topDir, true));
    }

    @Test(timeout=5000L)
    public void validateSetTezJarLocalResourcesMultipleTarballs() throws Exception {
        LocalFileSystem localFs = FileSystem.getLocal((Configuration)new Configuration());
        StringBuilder tezLibUris = new StringBuilder();
        Path topDir = new Path(TEST_ROOT_DIR, "validatemultipletarballs");
        if (localFs.exists(topDir)) {
            localFs.delete(topDir, true);
        }
        localFs.mkdirs(topDir);
        Path tarFile1 = new Path(topDir, "f1.tar.gz");
        Path tarFile2 = new Path(topDir, "f2.tar.gz");
        Assert.assertTrue((boolean)localFs.createNewFile(tarFile1));
        Assert.assertTrue((boolean)localFs.createNewFile(tarFile2));
        tezLibUris.append(localFs.makeQualified(tarFile1).toString()).append("#tar1").append(",");
        tezLibUris.append(localFs.makeQualified(tarFile2).toString()).append("#tar2").append(",");
        TezConfiguration conf = new TezConfiguration();
        conf.set("tez.lib.uris", tezLibUris.toString());
        Credentials credentials = new Credentials();
        HashMap localizedMap = new HashMap();
        TezClientUtils.setupTezJarsLocalResources((TezConfiguration)conf, (Credentials)credentials, localizedMap);
        Set resourceNames = localizedMap.keySet();
        Assert.assertEquals((long)2L, (long)resourceNames.size());
        Assert.assertTrue((boolean)resourceNames.contains("tar1"));
        Assert.assertTrue((boolean)resourceNames.contains("tar2"));
        Assert.assertFalse((boolean)resourceNames.contains("f1.tar.gz"));
        Assert.assertFalse((boolean)resourceNames.contains("f2.tar.gz"));
        Assert.assertTrue((boolean)localFs.delete(tarFile1, true));
        Assert.assertTrue((boolean)localFs.delete(tarFile2, true));
        Assert.assertTrue((boolean)localFs.delete(topDir, true));
    }

    @Test(timeout=5000L)
    public void validateSetTezJarLocalResourcesMixTarballAndJar() throws Exception {
        LocalFileSystem localFs = FileSystem.getLocal((Configuration)new Configuration());
        StringBuilder tezLibUris = new StringBuilder();
        Path topDir = new Path(TEST_ROOT_DIR, "validatetarballandjar");
        if (localFs.exists(topDir)) {
            localFs.delete(topDir, true);
        }
        localFs.mkdirs(topDir);
        Path tarFile1 = new Path(topDir, "f1.tar.gz");
        Path jarFile2 = new Path(topDir, "f2.jar");
        Path jarFile3 = new Path(topDir, "f3.jar");
        Assert.assertTrue((boolean)localFs.createNewFile(tarFile1));
        Assert.assertTrue((boolean)localFs.createNewFile(jarFile2));
        Assert.assertTrue((boolean)localFs.createNewFile(jarFile3));
        tezLibUris.append(localFs.makeQualified(topDir).toString()).append(",");
        tezLibUris.append(localFs.makeQualified(tarFile1).toString()).append("#tar1").append(",");
        TezConfiguration conf = new TezConfiguration();
        conf.set("tez.lib.uris", tezLibUris.toString());
        Credentials credentials = new Credentials();
        HashMap localizedMap = new HashMap();
        TezClientUtils.setupTezJarsLocalResources((TezConfiguration)conf, (Credentials)credentials, localizedMap);
        Set resourceNames = localizedMap.keySet();
        Assert.assertEquals((long)4L, (long)resourceNames.size());
        Assert.assertTrue((boolean)resourceNames.contains("tar1"));
        Assert.assertTrue((boolean)resourceNames.contains("f1.tar.gz"));
        Assert.assertTrue((boolean)resourceNames.contains("f2.jar"));
        Assert.assertTrue((boolean)resourceNames.contains("f3.jar"));
        Assert.assertTrue((boolean)localFs.delete(tarFile1, true));
        Assert.assertTrue((boolean)localFs.delete(jarFile2, true));
        Assert.assertTrue((boolean)localFs.delete(jarFile3, true));
        Assert.assertTrue((boolean)localFs.delete(topDir, true));
    }

    @Test(timeout=2000L)
    public void testAppSubmissionContextForPriority() throws Exception {
        TezConfiguration tezConf = new TezConfiguration();
        tezConf.set("fs.defaultFS", "file:///");
        tezConf.set("tez.staging-dir", STAGING_DIR.getAbsolutePath());
        int testpriority = 999;
        ApplicationId appId = ApplicationId.newInstance((long)1000L, (int)1);
        Credentials credentials = new Credentials();
        TezClientUtils.createSessionToken((String)appId.toString(), (JobTokenSecretManager)new JobTokenSecretManager(), (Credentials)credentials);
        tezConf.setBoolean("tez.ignore.lib.uris", true);
        HashMap m = new HashMap();
        tezConf.setInt("tez.am.application.priority", testpriority);
        AMConfiguration amConf = new AMConfiguration(tezConf, new HashMap(), credentials);
        ApplicationSubmissionContext appcontext = TezClientUtils.createApplicationSubmissionContext((ApplicationId)appId, null, (String)"dagname", (AMConfiguration)amConf, m, (Credentials)credentials, (boolean)false, (TezApiVersionInfo)new TezApiVersionInfo(), null, null);
        Assert.assertEquals((long)testpriority, (long)appcontext.getPriority().getPriority());
    }

    @Test(timeout=1000L)
    public void testSetApplicationPriority() {
        TezConfiguration conf = new TezConfiguration(false);
        AMConfiguration amconfig = new AMConfiguration(conf, null, null);
        ApplicationSubmissionContext appContext = (ApplicationSubmissionContext)Records.newRecord(ApplicationSubmissionContext.class);
        TezClientUtils.setApplicationPriority((ApplicationSubmissionContext)appContext, (AMConfiguration)amconfig);
        Assert.assertNull((Object)appContext.getPriority());
    }

    @Test(timeout=1000L)
    public void testSetApplicationTags() {
        TezConfiguration conf = new TezConfiguration(false);
        conf.set("tez.application.tags", "foo,bar");
        AMConfiguration amconfig = new AMConfiguration(conf, null, null);
        ApplicationSubmissionContext appContext = (ApplicationSubmissionContext)Records.newRecord(ApplicationSubmissionContext.class);
        Collection tagsFromConf = amconfig.getTezConfiguration().getTrimmedStringCollection("tez.application.tags");
        appContext.setApplicationTags(new HashSet(tagsFromConf));
        Assert.assertTrue((boolean)appContext.getApplicationTags().contains("foo"));
        Assert.assertTrue((boolean)appContext.getApplicationTags().contains("bar"));
    }

    @Test(timeout=5000L)
    public void testSessionTokenInAmClc() throws IOException, YarnException {
        TezConfiguration tezConf = new TezConfiguration();
        tezConf.set("fs.defaultFS", "file:///");
        tezConf.set("tez.staging-dir", STAGING_DIR.getAbsolutePath());
        ApplicationId appId = ApplicationId.newInstance((long)1000L, (int)1);
        DAG dag = DAG.create((String)"testdag");
        dag.addVertex(Vertex.create((String)"testVertex", (ProcessorDescriptor)ProcessorDescriptor.create((String)"processorClassname"), (int)1).setTaskLaunchCmdOpts("initialLaunchOpts"));
        Credentials credentials = new Credentials();
        JobTokenSecretManager jobTokenSecretManager = new JobTokenSecretManager();
        TezClientUtils.createSessionToken((String)appId.toString(), (JobTokenSecretManager)jobTokenSecretManager, (Credentials)credentials);
        Token jobToken = TokenCache.getSessionToken((Credentials)credentials);
        Assert.assertNotNull((Object)jobToken);
        AMConfiguration amConf = new AMConfiguration(tezConf, new HashMap(), credentials);
        ApplicationSubmissionContext appSubmissionContext = TezClientUtils.createApplicationSubmissionContext((ApplicationId)appId, (DAG)dag, (String)"amName", (AMConfiguration)amConf, new HashMap(), (Credentials)credentials, (boolean)false, (TezApiVersionInfo)new TezApiVersionInfo(), null, null);
        ContainerLaunchContext amClc = appSubmissionContext.getAMContainerSpec();
        Map amServiceData = amClc.getServiceData();
        Assert.assertNotNull((Object)amServiceData);
        Assert.assertEquals((long)1L, (long)amServiceData.size());
        DataInputByteBuffer dibb = new DataInputByteBuffer();
        dibb.reset(new ByteBuffer[]{(ByteBuffer)amServiceData.values().iterator().next()});
        Token jtSent = new Token();
        jtSent.readFields((DataInput)dibb);
        Assert.assertTrue((boolean)Arrays.equals(jobToken.getIdentifier(), jtSent.getIdentifier()));
    }

    @Test(timeout=5000L)
    public void testAMLoggingOptsSimple() throws IOException, YarnException {
        TezConfiguration tezConf = new TezConfiguration();
        tezConf.set("fs.defaultFS", "file:///");
        tezConf.set("tez.am.log.level", "WARN");
        tezConf.set("tez.staging-dir", STAGING_DIR.getAbsolutePath());
        ApplicationId appId = ApplicationId.newInstance((long)1000L, (int)1);
        Credentials credentials = new Credentials();
        JobTokenSecretManager jobTokenSecretManager = new JobTokenSecretManager();
        TezClientUtils.createSessionToken((String)appId.toString(), (JobTokenSecretManager)jobTokenSecretManager, (Credentials)credentials);
        DAG dag = DAG.create((String)"testdag");
        dag.addVertex(Vertex.create((String)"testVertex", (ProcessorDescriptor)ProcessorDescriptor.create((String)"processorClassname"), (int)1).setTaskLaunchCmdOpts("initialLaunchOpts"));
        AMConfiguration amConf = new AMConfiguration(tezConf, new HashMap(), credentials);
        ApplicationSubmissionContext appSubmissionContext = TezClientUtils.createApplicationSubmissionContext((ApplicationId)appId, (DAG)dag, (String)"amName", (AMConfiguration)amConf, new HashMap(), (Credentials)credentials, (boolean)false, (TezApiVersionInfo)new TezApiVersionInfo(), null, null);
        LinkedList<String> expectedCommands = new LinkedList<String>();
        expectedCommands.add("-Dlog4j.configuratorClass=org.apache.tez.common.TezLog4jConfigurator");
        expectedCommands.add("-Dlog4j.configuration=tez-container-log4j.properties");
        expectedCommands.add("-Dyarn.app.container.log.dir=<LOG_DIR>");
        expectedCommands.add("-Dtez.root.logger=WARN,CLA");
        List commands = appSubmissionContext.getAMContainerSpec().getCommands();
        Assert.assertEquals((long)1L, (long)commands.size());
        for (String expectedCmd : expectedCommands) {
            Assert.assertTrue((boolean)((String)commands.get(0)).contains(expectedCmd));
        }
        Map environment = appSubmissionContext.getAMContainerSpec().getEnvironment();
        String logEnv = (String)environment.get("TEZ_CONTAINER_LOG_PARAMS");
        Assert.assertNull((Object)logEnv);
    }

    @Test(timeout=5000L)
    public void testAMLoggingOptsPerLogger() throws IOException, YarnException {
        TezConfiguration tezConf = new TezConfiguration();
        tezConf.set("fs.defaultFS", "file:///");
        tezConf.set("tez.am.log.level", "WARN;org.apache.hadoop.ipc=DEBUG;org.apache.hadoop.security=DEBUG");
        tezConf.set("tez.staging-dir", STAGING_DIR.getAbsolutePath());
        ApplicationId appId = ApplicationId.newInstance((long)1000L, (int)1);
        Credentials credentials = new Credentials();
        JobTokenSecretManager jobTokenSecretManager = new JobTokenSecretManager();
        TezClientUtils.createSessionToken((String)appId.toString(), (JobTokenSecretManager)jobTokenSecretManager, (Credentials)credentials);
        DAG dag = DAG.create((String)"testdag");
        dag.addVertex(Vertex.create((String)"testVertex", (ProcessorDescriptor)ProcessorDescriptor.create((String)"processorClassname"), (int)1).setTaskLaunchCmdOpts("initialLaunchOpts"));
        AMConfiguration amConf = new AMConfiguration(tezConf, new HashMap(), credentials);
        ApplicationSubmissionContext appSubmissionContext = TezClientUtils.createApplicationSubmissionContext((ApplicationId)appId, (DAG)dag, (String)"amName", (AMConfiguration)amConf, new HashMap(), (Credentials)credentials, (boolean)false, (TezApiVersionInfo)new TezApiVersionInfo(), null, null);
        LinkedList<String> expectedCommands = new LinkedList<String>();
        expectedCommands.add("-Dlog4j.configuratorClass=org.apache.tez.common.TezLog4jConfigurator");
        expectedCommands.add("-Dlog4j.configuration=tez-container-log4j.properties");
        expectedCommands.add("-Dyarn.app.container.log.dir=<LOG_DIR>");
        expectedCommands.add("-Dtez.root.logger=WARN,CLA");
        List commands = appSubmissionContext.getAMContainerSpec().getCommands();
        Assert.assertEquals((long)1L, (long)commands.size());
        for (String expectedCmd : expectedCommands) {
            Assert.assertTrue((boolean)((String)commands.get(0)).contains(expectedCmd));
        }
        Map environment = appSubmissionContext.getAMContainerSpec().getEnvironment();
        String logEnv = (String)environment.get("TEZ_CONTAINER_LOG_PARAMS");
        Assert.assertEquals((Object)"org.apache.hadoop.ipc=DEBUG;org.apache.hadoop.security=DEBUG", (Object)logEnv);
    }

    @Test(timeout=5000L)
    public void testAMCommandOpts() {
        Path tmpDir = new Path(ApplicationConstants.Environment.PWD.$(), "./tmp");
        String tmpOpts = "-Djava.io.tmpdir=" + tmpDir;
        TezConfiguration tezConf = new TezConfiguration();
        tezConf.set("fs.defaultFS", "file:///");
        String amCommandOpts = "-Xmx 200m -Dtest.property";
        tezConf.set("tez.am.launch.cmd-opts", amCommandOpts);
        String amOptsConstructed = TezClientUtils.constructAMLaunchOpts((TezConfiguration)tezConf, (Resource)Resource.newInstance((int)1024, (int)1));
        Assert.assertEquals((Object)(tmpOpts + " -server -Djava.net.preferIPv4Stack=true -Dhadoop.metrics.log.level=WARN " + amCommandOpts), (Object)amOptsConstructed);
        String clusterDefaultCommandOpts = "-server -Djava.net.preferIPv4Stack=true -XX:+PrintGCDetails -verbose:gc ";
        tezConf.set("tez.am.launch.cluster-default.cmd-opts", clusterDefaultCommandOpts);
        amOptsConstructed = TezClientUtils.constructAMLaunchOpts((TezConfiguration)tezConf, (Resource)Resource.newInstance((int)1024, (int)1));
        Assert.assertEquals((Object)(tmpOpts + " " + clusterDefaultCommandOpts + " " + amCommandOpts), (Object)amOptsConstructed);
        double factor = 0.8;
        amCommandOpts = "-Dtest.property";
        tezConf.set("tez.am.launch.cmd-opts", amCommandOpts);
        amOptsConstructed = TezClientUtils.constructAMLaunchOpts((TezConfiguration)tezConf, (Resource)Resource.newInstance((int)1024, (int)1));
        Assert.assertEquals((Object)(" -Xmx819m " + tmpOpts + " " + clusterDefaultCommandOpts + " " + amCommandOpts), (Object)amOptsConstructed);
        clusterDefaultCommandOpts = "-server -Djava.net.preferIPv4Stack=true -XX:+PrintGCDetails -verbose:gc -Xmx200m";
        tezConf.set("tez.am.launch.cluster-default.cmd-opts", clusterDefaultCommandOpts);
        amOptsConstructed = TezClientUtils.constructAMLaunchOpts((TezConfiguration)tezConf, (Resource)Resource.newInstance((int)1024, (int)1));
        Assert.assertEquals((Object)(tmpOpts + " " + clusterDefaultCommandOpts + " " + amCommandOpts), (Object)amOptsConstructed);
    }

    @Test(timeout=5000L)
    public void testTaskCommandOpts() throws TezException {
        TezConfiguration tezConf = new TezConfiguration();
        tezConf.set("fs.defaultFS", "file:///");
        String taskCommandOpts = "-Xmx 200m -Dtest.property";
        tezConf.set("tez.task.launch.cmd-opts", taskCommandOpts);
        String expected = null;
        String taskOptsConstructed = TezClientUtils.addDefaultsToTaskLaunchCmdOpts((String)"", (Configuration)tezConf);
        expected = "-server -Djava.net.preferIPv4Stack=true -Dhadoop.metrics.log.level=WARN " + taskCommandOpts;
        Assert.assertTrue((String)("Did not find Expected prefix: [" + expected + "] in string [" + taskOptsConstructed + "]"), (boolean)taskOptsConstructed.startsWith(expected));
        String taskClusterDefaultCommandOpts = "-server -Djava.net.preferIPv4Stack=true -XX:+PrintGCDetails -verbose:gc ";
        tezConf.set("tez.task.launch.cluster-default.cmd-opts", taskClusterDefaultCommandOpts);
        taskOptsConstructed = TezClientUtils.addDefaultsToTaskLaunchCmdOpts((String)"", (Configuration)tezConf);
        expected = taskClusterDefaultCommandOpts + " " + taskCommandOpts;
        Assert.assertTrue((String)("Did not find Expected prefix: [" + expected + "] in string [" + taskOptsConstructed + "]"), (boolean)taskOptsConstructed.startsWith(expected));
        taskCommandOpts = "-Dtest.property";
        tezConf.set("tez.task.launch.cmd-opts", taskCommandOpts);
        taskOptsConstructed = TezClientUtils.addDefaultsToTaskLaunchCmdOpts((String)"", (Configuration)tezConf);
        expected = taskClusterDefaultCommandOpts + " " + taskCommandOpts;
        Assert.assertTrue((String)("Did not find Expected prefix: [" + expected + "] in string [" + taskOptsConstructed + "]"), (boolean)taskOptsConstructed.startsWith(expected));
        String programmaticTaskOpts = "-Dset.programatically=true -Djava.net.preferIPv4Stack=false";
        taskOptsConstructed = TezClientUtils.addDefaultsToTaskLaunchCmdOpts((String)programmaticTaskOpts, (Configuration)tezConf);
        expected = taskClusterDefaultCommandOpts + " " + taskCommandOpts + " " + programmaticTaskOpts;
        Assert.assertTrue((String)("Did not find Expected prefix: [" + expected + "] in string [" + taskOptsConstructed + "]"), (boolean)taskOptsConstructed.startsWith(expected));
    }

    @Test(timeout=5000L)
    public void testDefaultMemoryJavaOpts() {
        double factor = 0.8;
        String origJavaOpts = "-Xmx";
        String javaOpts = TezClientUtils.maybeAddDefaultMemoryJavaOpts((String)origJavaOpts, (Resource)Resource.newInstance((int)1000, (int)1), (double)0.8);
        Assert.assertEquals((Object)origJavaOpts, (Object)javaOpts);
        origJavaOpts = "";
        javaOpts = TezClientUtils.maybeAddDefaultMemoryJavaOpts((String)origJavaOpts, (Resource)Resource.newInstance((int)1000, (int)1), (double)0.8);
        Assert.assertTrue((boolean)javaOpts.contains("-Xmx800m"));
        origJavaOpts = "";
        javaOpts = TezClientUtils.maybeAddDefaultMemoryJavaOpts((String)origJavaOpts, (Resource)Resource.newInstance((int)1, (int)1), (double)0.8);
        Assert.assertTrue((boolean)javaOpts.contains("-Xmx1m"));
        origJavaOpts = "";
        javaOpts = TezClientUtils.maybeAddDefaultMemoryJavaOpts((String)origJavaOpts, (Resource)Resource.newInstance((int)-1, (int)1), (double)0.8);
        Assert.assertEquals((Object)origJavaOpts, (Object)javaOpts);
        origJavaOpts = "";
        javaOpts = TezClientUtils.maybeAddDefaultMemoryJavaOpts((String)origJavaOpts, (Resource)Resource.newInstance((int)355, (int)1), (double)0.8);
        Assert.assertTrue((boolean)javaOpts.contains("-Xmx284m"));
        origJavaOpts = " -Xms100m ";
        javaOpts = TezClientUtils.maybeAddDefaultMemoryJavaOpts((String)origJavaOpts, (Resource)Resource.newInstance((int)355, (int)1), (double)0.8);
        Assert.assertFalse((boolean)javaOpts.contains("-Xmx284m"));
        Assert.assertTrue((boolean)javaOpts.contains("-Xms100m"));
        origJavaOpts = "";
        javaOpts = TezClientUtils.maybeAddDefaultMemoryJavaOpts((String)origJavaOpts, (Resource)Resource.newInstance((int)355, (int)1), (double)0.0);
        Assert.assertEquals((Object)origJavaOpts, (Object)javaOpts);
        origJavaOpts = "";
        javaOpts = TezClientUtils.maybeAddDefaultMemoryJavaOpts((String)origJavaOpts, (Resource)Resource.newInstance((int)355, (int)1), (double)100.0);
        Assert.assertEquals((Object)origJavaOpts, (Object)javaOpts);
        origJavaOpts = "";
        javaOpts = TezClientUtils.maybeAddDefaultMemoryJavaOpts((String)origJavaOpts, (Resource)Resource.newInstance((int)1000, (int)1), (double)-1.0);
        Assert.assertTrue((boolean)javaOpts.contains("-Xmx700m"));
        origJavaOpts = "";
        javaOpts = TezClientUtils.maybeAddDefaultMemoryJavaOpts((String)origJavaOpts, (Resource)Resource.newInstance((int)5000, (int)1), (double)-1.0);
        Assert.assertTrue((boolean)javaOpts.contains("-Xmx4000m"));
    }

    @Test(timeout=5000L)
    public void testDefaultLoggingJavaOpts() {
        String origJavaOpts = null;
        String javaOpts = TezClientUtils.maybeAddDefaultLoggingJavaOpts((String)"FOOBAR", origJavaOpts);
        Assert.assertNotNull((Object)javaOpts);
        Assert.assertTrue((javaOpts.contains("-Dtez.root.logger=FOOBAR") && javaOpts.contains("tez-container-log4j.properties") && javaOpts.contains("-Dlog4j.configuratorClass=org.apache.tez.common.TezLog4jConfigurator") ? 1 : 0) != 0);
    }

    @Test
    public void testDefaultLoggingJavaOptsWithRootLogger() {
        String origJavaOpts = "-Dtez.root.logger=INFO -DtestProperty=value";
        String javaOpts = TezClientUtils.maybeAddDefaultLoggingJavaOpts((String)"FOOBAR", (String)origJavaOpts);
        Assert.assertNotNull((Object)javaOpts);
        Assert.assertTrue((boolean)javaOpts.contains("-Dtez.root.logger=FOOBAR"));
        Assert.assertTrue((javaOpts.contains("tez-container-log4j.properties") && javaOpts.contains("-Dlog4j.configuratorClass=org.apache.tez.common.TezLog4jConfigurator") ? 1 : 0) != 0);
        Assert.assertTrue((boolean)javaOpts.contains("-DtestProperty=value"));
    }

    @Test(timeout=5000L)
    public void testConfSerializationForAm() {
        Configuration conf = new Configuration(false);
        String val1 = "fixedProperty";
        String val2 = "parametrizedProperty/${user.name}";
        String expVal2 = "parametrizedProperty/" + System.getProperty("user.name");
        conf.set("property1", val1);
        conf.set("property2", val2);
        HashMap<String, Object> expected = new HashMap<String, Object>();
        expected.put("property1", val1);
        expected.put("property2", expVal2);
        DAGProtos.ConfigurationProto confProto = TezClientUtils.createFinalConfProtoForApp((Configuration)conf, null);
        for (DAGProtos.PlanKeyValuePair kvPair : confProto.getConfKeyValuesList()) {
            String v = (String)expected.remove(kvPair.getKey());
            Assert.assertEquals((Object)v, (Object)kvPair.getValue());
        }
        Assert.assertTrue((boolean)expected.isEmpty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void testLocalResourceVisibility(DistributedFileSystem remoteFs, Configuration conf) throws Exception {
        Path topLevelDir = null;
        try {
            FsPermission publicDirPerms = new FsPermission(493);
            FsPermission privateDirPerms = new FsPermission(492);
            FsPermission publicFilePerms = new FsPermission(364);
            FsPermission privateFilePerms = new FsPermission(360);
            String fsURI = remoteFs.getUri().toString();
            topLevelDir = new Path(fsURI, "/testLRVisibility");
            Assert.assertTrue((boolean)remoteFs.mkdirs(topLevelDir, publicDirPerms));
            Path publicSubDir = new Path(topLevelDir, "public_sub_dir");
            Assert.assertTrue((boolean)remoteFs.mkdirs(publicSubDir, publicDirPerms));
            Path privateSubDir = new Path(topLevelDir, "private_sub_dir");
            Assert.assertTrue((boolean)remoteFs.mkdirs(privateSubDir, privateDirPerms));
            Path publicFile = new Path(publicSubDir, "public_file");
            Assert.assertTrue((boolean)remoteFs.createNewFile(publicFile));
            remoteFs.setPermission(publicFile, publicFilePerms);
            Path privateFile = new Path(publicSubDir, "private_file");
            Assert.assertTrue((boolean)remoteFs.createNewFile(privateFile));
            remoteFs.setPermission(privateFile, privateFilePerms);
            Path publicFileInPrivateSubdir = new Path(privateSubDir, "public_file_in_private_subdir");
            Assert.assertTrue((boolean)remoteFs.createNewFile(publicFileInPrivateSubdir));
            remoteFs.setPermission(publicFileInPrivateSubdir, publicFilePerms);
            TezConfiguration tezConf = new TezConfiguration(conf);
            String tmpTezLibUris = String.format("%s,%s,%s,%s", topLevelDir, publicSubDir, privateSubDir, conf.get("tez.lib.uris", ""));
            tezConf.set("tez.lib.uris", tmpTezLibUris);
            HashMap lrMap = new HashMap();
            TezClientUtils.setupTezJarsLocalResources((TezConfiguration)tezConf, (Credentials)new Credentials(), lrMap);
            Assert.assertEquals((String)publicFile.getName(), (Object)LocalResourceVisibility.PUBLIC, (Object)((LocalResource)lrMap.get(publicFile.getName())).getVisibility());
            Assert.assertEquals((String)privateFile.getName(), (Object)LocalResourceVisibility.PRIVATE, (Object)((LocalResource)lrMap.get(privateFile.getName())).getVisibility());
            Assert.assertEquals((String)publicFileInPrivateSubdir.getName(), (Object)LocalResourceVisibility.PRIVATE, (Object)((LocalResource)lrMap.get(publicFileInPrivateSubdir.getName())).getVisibility());
            tezConf = new TezConfiguration(conf);
            Path tarFile = new Path(topLevelDir, "foo.tar.gz");
            Assert.assertTrue((boolean)remoteFs.createNewFile(tarFile));
            remoteFs.setPermission(tarFile, publicFilePerms);
            tezConf.set("tez.lib.uris", tarFile.toString());
            lrMap.clear();
            Assert.assertTrue((boolean)TezClientUtils.setupTezJarsLocalResources((TezConfiguration)tezConf, (Credentials)new Credentials(), lrMap));
            Assert.assertEquals((Object)LocalResourceVisibility.PUBLIC, (Object)((LocalResource)lrMap.get("tezlib")).getVisibility());
            remoteFs.setPermission(tarFile, privateFilePerms);
            lrMap.clear();
            TezClientUtils.setupTezJarsLocalResources((TezConfiguration)tezConf, (Credentials)new Credentials(), lrMap);
            Assert.assertEquals((Object)LocalResourceVisibility.PRIVATE, (Object)((LocalResource)lrMap.get("tezlib")).getVisibility());
            if (topLevelDir == null) return;
        }
        catch (Throwable throwable) {
            if (topLevelDir == null) throw throwable;
            remoteFs.delete(topLevelDir, true);
            throw throwable;
        }
        remoteFs.delete(topLevelDir, true);
    }

    @Test(timeout=5000L)
    public void testConfigurationAllowAll() {
        Configuration srcConf = new Configuration(false);
        HashMap<String, String> confMap = new HashMap<String, String>();
        confMap.put("foo.property", "2000");
        confMap.put("tez.property", "tezProperty");
        confMap.put("yarn.property", "yarnProperty");
        for (Map.Entry entry : confMap.entrySet()) {
            srcConf.set((String)entry.getKey(), (String)entry.getValue());
        }
        DAGProtos.ConfigurationProto confProto = TezClientUtils.createFinalConfProtoForApp((Configuration)srcConf, null);
        for (DAGProtos.PlanKeyValuePair kvPair : confProto.getConfKeyValuesList()) {
            String val = (String)confMap.remove(kvPair.getKey());
            Assert.assertNotNull((Object)val);
            Assert.assertEquals((Object)val, (Object)kvPair.getValue());
        }
        Assert.assertTrue((boolean)confMap.isEmpty());
    }

    private Path createFile(FileSystem fs, Path dir, String fileName) throws IOException {
        Path f1 = new Path(dir, fileName);
        FSDataOutputStream outputStream = fs.create(f1, true);
        outputStream.write(1);
        outputStream.close();
        return fs.makeQualified(f1);
    }

    @Test(timeout=5000L)
    public void validateSetTezAuxLocalResourcesWithFilesAndFolders() throws Exception {
        LocalFileSystem localFs = FileSystem.getLocal((Configuration)new Configuration());
        ArrayList<String> resources = new ArrayList<String>();
        StringBuilder auxUriStr = new StringBuilder();
        Path topDir = new Path(TEST_ROOT_DIR, "validateauxwithfiles");
        if (localFs.exists(topDir)) {
            localFs.delete(topDir, true);
        }
        localFs.mkdirs(topDir);
        resources.add(this.createFile((FileSystem)localFs, topDir, "f1.txt").toString());
        auxUriStr.append(localFs.makeQualified(topDir).toString()).append(",");
        Path dir2 = new Path(topDir, "dir2");
        localFs.mkdirs(dir2);
        Path nestedDir = new Path(dir2, "nestedDir");
        localFs.mkdirs(nestedDir);
        this.createFile((FileSystem)localFs, nestedDir, "nested-f.txt");
        resources.add(this.createFile((FileSystem)localFs, dir2, "dir2-f.txt").toString());
        auxUriStr.append(localFs.makeQualified(dir2).toString()).append(",");
        Path dir3 = new Path(topDir, "dir3");
        localFs.mkdirs(dir3);
        auxUriStr.append(localFs.makeQualified(dir3).toString()).append(",");
        TezConfiguration conf = new TezConfiguration();
        conf.setBoolean("tez.ignore.lib.uris", true);
        conf.set("tez.aux.uris", auxUriStr.toString());
        Credentials credentials = new Credentials();
        HashMap localizedMap = new HashMap();
        TezClientUtils.setupTezJarsLocalResources((TezConfiguration)conf, (Credentials)credentials, localizedMap);
        Set resourceNames = localizedMap.keySet();
        Assert.assertEquals((long)2L, (long)resourceNames.size());
        Assert.assertTrue((boolean)resourceNames.contains("f1.txt"));
        Assert.assertTrue((boolean)resourceNames.contains("dir2-f.txt"));
    }

    @Test(timeout=5000L)
    public void testServiceDescriptorSerializationForAM() {
        Configuration conf = new Configuration(false);
        ServicePluginsDescriptor servicePluginsDescriptor = ServicePluginsDescriptor.create((boolean)true);
        DAGProtos.ConfigurationProto confProto = TezClientUtils.createFinalConfProtoForApp((Configuration)conf, (ServicePluginsDescriptor)servicePluginsDescriptor);
        Assert.assertTrue((boolean)confProto.hasAmPluginDescriptor());
        Assert.assertTrue((boolean)confProto.getAmPluginDescriptor().getUberEnabled());
    }

    @Test(timeout=5000L)
    public void testTaskLaunchCmdOptsSetup() throws TezException {
        Configuration conf = new Configuration(false);
        String vOpts = "";
        String opts = TezClientUtils.addDefaultsToTaskLaunchCmdOpts((String)vOpts, (Configuration)conf);
        Assert.assertEquals((Object)opts, (Object)("-server -Djava.net.preferIPv4Stack=true -Dhadoop.metrics.log.level=WARN " + TezConfiguration.TEZ_TASK_LAUNCH_CMD_OPTS_DEFAULT + " " + vOpts));
        vOpts = "foo";
        opts = TezClientUtils.addDefaultsToTaskLaunchCmdOpts((String)vOpts, (Configuration)conf);
        Assert.assertEquals((Object)opts, (Object)("-server -Djava.net.preferIPv4Stack=true -Dhadoop.metrics.log.level=WARN  " + vOpts));
        String taskOpts = "taskOpts";
        conf.set("tez.task.launch.cmd-opts", taskOpts);
        opts = TezClientUtils.addDefaultsToTaskLaunchCmdOpts((String)vOpts, (Configuration)conf);
        Assert.assertEquals((Object)opts, (Object)("-server -Djava.net.preferIPv4Stack=true -Dhadoop.metrics.log.level=WARN " + taskOpts + " " + vOpts));
    }

    @Test(timeout=5000L)
    public void testClusterTaskLaunchCmdOptsSetup() throws TezException {
        Configuration conf = new Configuration(false);
        String adminOpts = "adminOpts";
        conf.set("tez.task.launch.cluster-default.cmd-opts", adminOpts);
        String vOpts = "";
        String opts = TezClientUtils.addDefaultsToTaskLaunchCmdOpts((String)vOpts, (Configuration)conf);
        Assert.assertEquals((Object)opts, (Object)(adminOpts + " " + TezConfiguration.TEZ_TASK_LAUNCH_CMD_OPTS_DEFAULT + " " + vOpts));
        vOpts = "foo";
        opts = TezClientUtils.addDefaultsToTaskLaunchCmdOpts((String)vOpts, (Configuration)conf);
        Assert.assertEquals((Object)opts, (Object)(adminOpts + "  " + vOpts));
        String taskOpts = "taskOpts";
        conf.set("tez.task.launch.cmd-opts", taskOpts);
        opts = TezClientUtils.addDefaultsToTaskLaunchCmdOpts((String)vOpts, (Configuration)conf);
        Assert.assertEquals((Object)opts, (Object)(adminOpts + " " + taskOpts + " " + vOpts));
    }

    @Test
    public void testSessionCredentialsMergedBeforeAmConfigCredentials() throws Exception {
        TezConfiguration conf = new TezConfiguration();
        Text tokenType = new Text("TEST_TOKEN_TYPE");
        Text tokenKind = new Text("TEST_TOKEN_KIND");
        Text tokenService = new Text("TEST_TOKEN_SERVICE");
        Credentials amConfigCredentials = new Credentials();
        amConfigCredentials.addToken(tokenType, new Token("id1".getBytes(), null, tokenKind, tokenService));
        Credentials sessionCredentials = new Credentials();
        Token sessionToken = new Token("id2".getBytes(), null, tokenKind, tokenService);
        sessionCredentials.addToken(tokenType, sessionToken);
        AMConfiguration amConfig = new AMConfiguration(conf, null, amConfigCredentials);
        Credentials amLaunchCredentials = TezClientUtils.prepareAmLaunchCredentials((AMConfiguration)amConfig, (Credentials)sessionCredentials, (TezConfiguration)conf, null);
        Assert.assertEquals((Object)sessionToken, (Object)amLaunchCredentials.getToken(tokenType));
    }
}

