/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.common.security;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileSystemTestHelper;
import org.apache.hadoop.fs.FilterFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.token.Token;
import org.apache.tez.common.security.Master;
import org.apache.tez.common.security.TokenCache;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class TestTokenCache {
    private static Configuration conf;
    private static String renewer;

    @BeforeClass
    public static void setup() throws Exception {
        conf = new Configuration();
        conf.set("fs.defaultFS", "file:///");
        conf.set("yarn.resourcemanager.principal", "mapred/host@REALM");
        conf.setSocketAddr("yarn.resourcemanager.address", InetSocketAddress.createUnresolved("127.0.0.1", 8032));
        renewer = Master.getMasterPrincipal((Configuration)conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test(timeout=5000L)
    public void testBinaryCredentials() throws Exception {
        String binaryTokenFile = null;
        try {
            Path TEST_ROOT_DIR = new Path("target");
            binaryTokenFile = FileSystem.getLocal((Configuration)conf).makeQualified(new Path(TEST_ROOT_DIR, "tokenFile")).toUri().getPath();
            FileSystemTestHelper.MockFileSystem fs1 = this.createFileSystemForServiceName("service1");
            FileSystemTestHelper.MockFileSystem fs2 = this.createFileSystemForServiceName("service2");
            Credentials creds = new Credentials();
            Token token1 = fs1.getDelegationToken(renewer);
            Token token2 = fs2.getDelegationToken(renewer);
            creds.addToken(token1.getService(), token1);
            creds.addToken(token2.getService(), token2);
            creds.writeTokenStorageFile(new Path(binaryTokenFile), conf);
            Credentials newCreds = new Credentials();
            TokenCache.mergeBinaryTokens((Credentials)newCreds, (Configuration)conf, (String)binaryTokenFile);
            Assert.assertTrue((newCreds.getAllTokens().size() > 0 ? 1 : 0) != 0);
            this.checkTokens(creds, newCreds);
            if (binaryTokenFile == null) return;
        }
        catch (Throwable throwable) {
            if (binaryTokenFile == null) throw throwable;
            try {
                FileSystem.getLocal((Configuration)conf).delete(new Path(binaryTokenFile));
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            FileSystem.getLocal((Configuration)conf).delete(new Path(binaryTokenFile));
            return;
        }
        catch (IOException iOException) {}
    }

    @Test(timeout=5000L)
    public void testObtainTokensForFileSystems() throws Exception {
        Path[] paths = this.makePaths(100, "test://dir/file");
        Credentials creds = new Credentials();
        Configuration conf = new Configuration(TestTokenCache.conf);
        conf.set("fs.test.impl", TestFileSystem.class.getName());
        conf.setBoolean("fs.test.impl.disable.cache", false);
        TokenCache.obtainTokensForFileSystemsInternal((Credentials)creds, (Path[])paths, (Configuration)conf);
        ((FileSystem)Mockito.verify((Object)TestFileSystem.fs, (VerificationMode)Mockito.times((int)1))).addDelegationTokens(renewer, creds);
        conf.setBoolean("fs.test.impl.disable.cache", true);
        TokenCache.obtainTokensForFileSystemsInternal((Credentials)creds, (Path[])paths, (Configuration)conf);
        ((FileSystem)Mockito.verify((Object)TestFileSystem.fs, (VerificationMode)Mockito.times((int)(paths.length + 1)))).addDelegationTokens(renewer, creds);
        conf.set("tez.job.fs-servers.token-renewal.exclude", "dir");
        TokenCache.obtainTokensForFileSystemsInternal((Credentials)creds, (Path[])paths, (Configuration)conf);
        ((FileSystem)Mockito.verify((Object)TestFileSystem.fs, (VerificationMode)Mockito.times((int)(paths.length + 1)))).addDelegationTokens(renewer, creds);
    }

    private Path[] makePaths(int count, String prefix) throws Exception {
        Path[] ps = new Path[count];
        for (int i = 0; i < count; ++i) {
            ps[i] = new Path(prefix + i);
        }
        return ps;
    }

    private FileSystemTestHelper.MockFileSystem createFileSystemForServiceName(final String service) throws IOException {
        FileSystemTestHelper.MockFileSystem mockFs = new FileSystemTestHelper.MockFileSystem();
        Mockito.when((Object)mockFs.getCanonicalServiceName()).thenReturn((Object)service);
        Mockito.when((Object)mockFs.getDelegationToken((String)Mockito.any())).thenAnswer(new Answer<Token<?>>(){
            int unique = 0;

            public Token<?> answer(InvocationOnMock invocation) throws Throwable {
                Token token = new Token();
                token.setService(new Text(service));
                token.setKind(new Text("token" + this.unique++));
                return token;
            }
        });
        return mockFs;
    }

    private void checkTokens(Credentials creds, Credentials newCreds) {
        Assert.assertEquals((long)creds.getAllTokens().size(), (long)newCreds.getAllTokens().size());
        for (Token token : newCreds.getAllTokens()) {
            Token credsToken = creds.getToken(token.getService());
            Assert.assertTrue((credsToken != null ? 1 : 0) != 0);
            Assert.assertEquals((Object)token, (Object)credsToken);
        }
    }

    public static class TestFileSystem
    extends FilterFileSystem {
        static final FileSystem fs = (FileSystem)Mockito.mock(FileSystem.class);

        public TestFileSystem() {
            super(fs);
        }

        public Token<?>[] addDelegationTokens(String renewer, Credentials credentials) throws IOException {
            return fs.addDelegationTokens(renewer, credentials);
        }

        static {
            try {
                Mockito.when((Object)fs.getUri()).thenReturn((Object)new URI("test://dir"));
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

