/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.api;

import org.apache.hadoop.conf.Configuration;
import org.apache.tez.dag.api.HistoryLogLevel;
import org.junit.Assert;
import org.junit.Test;

public class TestHistoryLogLevel {
    @Test
    public void testGetLogLevel() {
        Assert.assertNull((Object)HistoryLogLevel.getLogLevel((Configuration)this.getConfiguration(null), null));
        Assert.assertEquals((Object)HistoryLogLevel.DEFAULT, (Object)HistoryLogLevel.getLogLevel((Configuration)this.getConfiguration(null), (HistoryLogLevel)HistoryLogLevel.DEFAULT));
        Assert.assertEquals((Object)HistoryLogLevel.NONE, (Object)HistoryLogLevel.getLogLevel((Configuration)this.getConfiguration("NONE"), (HistoryLogLevel)HistoryLogLevel.DEFAULT));
        Assert.assertEquals((Object)HistoryLogLevel.NONE, (Object)HistoryLogLevel.getLogLevel((Configuration)this.getConfiguration("none"), (HistoryLogLevel)HistoryLogLevel.DEFAULT));
        try {
            HistoryLogLevel.getLogLevel((Configuration)this.getConfiguration("invalid"), (HistoryLogLevel)HistoryLogLevel.DEFAULT);
            Assert.fail((String)"Expected IllegalArugment Exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testValidateLogLevel() {
        Assert.assertTrue((boolean)HistoryLogLevel.validateLogLevel(null));
        Assert.assertTrue((boolean)HistoryLogLevel.validateLogLevel((String)"NONE"));
        Assert.assertTrue((boolean)HistoryLogLevel.validateLogLevel((String)"none"));
        Assert.assertFalse((boolean)HistoryLogLevel.validateLogLevel((String)"invalid"));
    }

    private Configuration getConfiguration(String confValue) {
        Configuration conf = new Configuration(false);
        if (confValue != null) {
            conf.set("tez.history.logging.log.level", confValue);
        }
        return conf;
    }
}

