/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.hadoop.shim;

import org.apache.hadoop.conf.Configuration;
import org.apache.tez.hadoop.shim.DefaultHadoopShim;
import org.apache.tez.hadoop.shim.DummyShimProvider;
import org.apache.tez.hadoop.shim.HadoopShim;
import org.apache.tez.hadoop.shim.HadoopShimsLoader;
import org.junit.Assert;
import org.junit.Test;

public class TestHadoopShimsLoader {
    @Test
    public void testBasicLoader() {
        HadoopShimsLoader loader = new HadoopShimsLoader(new Configuration(false));
        HadoopShim shim = loader.getHadoopShim();
        Assert.assertNotNull((Object)shim);
        Assert.assertEquals(DefaultHadoopShim.class, shim.getClass());
    }

    @Test
    public void testLoaderOverride() {
        Configuration conf = new Configuration(false);
        conf.set("tez.hadoop.shim.provider.class", DummyShimProvider.class.getName());
        HadoopShimsLoader loader = new HadoopShimsLoader(conf, true);
        HadoopShim shim = loader.getHadoopShim();
        Assert.assertNotNull((Object)shim);
        Assert.assertEquals(DummyShimProvider.DummyShim.class, shim.getClass());
    }

    @Test(expected=RuntimeException.class)
    public void testInvalidOverride() {
        Configuration conf = new Configuration(false);
        conf.set("tez.hadoop.shim.provider.class", "org.apache.tez.foo");
        HadoopShimsLoader loader = new HadoopShimsLoader(conf, true);
        HadoopShim shim = loader.getHadoopShim();
    }
}

