/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.conftool;

import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.tez.conftool.ConfTool;
import org.apache.tez.conftool.Security;
import org.xml.sax.SAXException;

public final class ConfCli {
    private static final Options CMD_LINE_OPTIONS = new Options();
    private static final HelpFormatter HELP_FORMATTER = new HelpFormatter();
    private static final String HELP = "help";
    private static final String TOOL_NAME = "conftool";
    private static final String PATH = "path";
    private static final String SECURITY = "security";
    private static final String HEADERS = "headers";

    private ConfCli() {
    }

    public static void main(String[] args) throws IOException, ParserConfigurationException, SAXException, TransformerException {
        CommandLine line;
        GnuParser cmdParser = new GnuParser();
        try {
            line = cmdParser.parse(CMD_LINE_OPTIONS, args);
        }
        catch (ParseException e) {
            ConfCli.printHelp();
            throw new IllegalArgumentException("conftool: Parsing failed.  Reason: " + e.getLocalizedMessage());
        }
        if (line == null) {
            throw new IllegalArgumentException("conftool: parsing failed.  Reason: unknown");
        }
        if (line.hasOption(HELP)) {
            ConfCli.printHelp();
        } else if (line.hasOption(PATH)) {
            String pathToXmlFile = line.getOptionValue(PATH);
            if (line.hasOption(SECURITY)) {
                ConfCli.configureSecurity(pathToXmlFile, ConfCli.getSecurity(line));
                if (line.hasOption(HEADERS)) {
                    ConfTool.setHeaders(pathToXmlFile, ConfCli.getSecurity(line), line.getOptionValue(HEADERS));
                }
            }
        } else {
            ConfCli.printHelp();
        }
    }

    private static void printHelp() {
        HELP_FORMATTER.printHelp(TOOL_NAME, CMD_LINE_OPTIONS);
    }

    private static void configureSecurity(String pathToTezSite, Security security) throws IOException, ParserConfigurationException, SAXException, TransformerException {
        ConfTool.setEncryption(pathToTezSite, security);
    }

    private static boolean isTrueOrFalseOrCustom(String value) {
        for (Security security : Security.values()) {
            if (!security.value().equalsIgnoreCase(value.trim())) continue;
            return true;
        }
        return false;
    }

    private static boolean hasValidSecurityOptions(CommandLine line) {
        return line.hasOption(SECURITY) && ConfCli.isTrueOrFalseOrCustom(line.getOptionValue(SECURITY));
    }

    private static Security getSecurity(CommandLine line) {
        if (ConfCli.hasValidSecurityOptions(line)) {
            return Security.parse(line.getOptionValue(SECURITY));
        }
        ConfCli.printHelp();
        throw new IllegalArgumentException("Incorrect security configuration options");
    }

    static {
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.withDescription((String)"Print help information");
        CMD_LINE_OPTIONS.addOption(OptionBuilder.create((String)HELP));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"true or false for security");
        OptionBuilder.withDescription((String)"Shows current status of security");
        CMD_LINE_OPTIONS.addOption(OptionBuilder.create((String)SECURITY));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"path to xml file");
        OptionBuilder.withDescription((String)"Path to xml file to configure tez-site.xml.");
        CMD_LINE_OPTIONS.addOption(OptionBuilder.create((String)PATH));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"path to headers.xml file");
        OptionBuilder.withDescription((String)"Path to xml file to configure custom Tomcat headers.");
        CMD_LINE_OPTIONS.addOption(OptionBuilder.create((String)HEADERS));
    }
}

