/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.conftool;

import java.io.IOException;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.tez.conftool.ConfTool;
import org.apache.tez.conftool.Security;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class TestConfTool {
    @Test
    public void testSetProperty() throws ParserConfigurationException, IOException, SAXException {
        URL url = Thread.currentThread().getContextClassLoader().getResource("tez-site-01.xml");
        String pathToTezSite = url.getPath();
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        Document doc = docBuilder.parse(pathToTezSite);
        String valueBeforeTest = ConfTool.getProperty((Document)doc, (String)"myProperty");
        ConfTool.set((Document)doc, (String)"myProperty", (String)"myValue");
        Assert.assertNotEquals((Object)valueBeforeTest, (Object)ConfTool.getProperty((Document)doc, (String)"myProperty"));
        Assert.assertEquals((Object)"myValue", (Object)ConfTool.getProperty((Document)doc, (String)"myProperty"));
    }

    @Test
    public void testRemoveProperty() throws ParserConfigurationException, IOException, SAXException {
        URL url = Thread.currentThread().getContextClassLoader().getResource("tez-site-01.xml");
        String pathToTezSite = url.getPath();
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        Document doc = docBuilder.parse(pathToTezSite);
        String valueBeforeTest = ConfTool.getProperty((Document)doc, (String)"myProperty");
        ConfTool.removeProperty((Document)doc, (String)"myProperty");
        Assert.assertNotEquals((Object)valueBeforeTest, (Object)ConfTool.getProperty((Document)doc, (String)"myProperty"));
        Assert.assertEquals((Object)"", (Object)ConfTool.getProperty((Document)doc, (String)"myProperty"));
    }

    @Test
    public void testEncryptionEnable() throws IOException, ParserConfigurationException, SAXException, TransformerException {
        URL url = Thread.currentThread().getContextClassLoader().getResource("tez-site-01.xml");
        String pathToTezSite = url.getPath();
        ConfTool.setEncryption((String)pathToTezSite, (Security)Security.MAPRSASL);
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        Document doc = docBuilder.parse(pathToTezSite);
        Assert.assertEquals((Object)"true", (Object)ConfTool.getProperty((Document)doc, (String)"tez.runtime.shuffle.ssl.enable"));
        Assert.assertEquals((Object)"true", (Object)ConfTool.getProperty((Document)doc, (String)"tez.runtime.shuffle.keep-alive.enabled"));
    }

    @Test
    public void testEncryptionDisable() throws IOException, ParserConfigurationException, SAXException, TransformerException {
        URL url = Thread.currentThread().getContextClassLoader().getResource("tez-site-02.xml");
        String pathToTezSite = url.getPath();
        ConfTool.setEncryption((String)pathToTezSite, (Security)Security.NONE);
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        Document doc = docBuilder.parse(pathToTezSite);
        Assert.assertEquals((Object)"", (Object)ConfTool.getProperty((Document)doc, (String)"tez.runtime.shuffle.ssl.enable"));
        Assert.assertEquals((Object)"", (Object)ConfTool.getProperty((Document)doc, (String)"tez.runtime.shuffle.keep-alive.enabled"));
    }

    @Test
    public void testEncryptionDisableIfNotPresent() throws IOException, ParserConfigurationException, SAXException, TransformerException {
        URL url = Thread.currentThread().getContextClassLoader().getResource("tez-site-01.xml");
        String pathToTezSite = url.getPath();
        ConfTool.setEncryption((String)pathToTezSite, (Security)Security.NONE);
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        Document doc = docBuilder.parse(pathToTezSite);
        Assert.assertEquals((Object)"", (Object)ConfTool.getProperty((Document)doc, (String)"tez.runtime.shuffle.ssl.enable"));
        Assert.assertEquals((Object)"", (Object)ConfTool.getProperty((Document)doc, (String)"tez.runtime.shuffle.keep-alive.enabled"));
    }

    @Test
    public void testEncryptionCustom() throws IOException, ParserConfigurationException, SAXException, TransformerException {
        URL url = Thread.currentThread().getContextClassLoader().getResource("tez-site-01.xml");
        String pathToTezSite = url.getPath();
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        Document doc = docBuilder.parse(pathToTezSite);
        String sslBeforeTest = ConfTool.getProperty((Document)doc, (String)"tez.runtime.shuffle.ssl.enable");
        String keepAliveBeforeTest = ConfTool.getProperty((Document)doc, (String)"tez.runtime.shuffle.keep-alive.enabled");
        ConfTool.setEncryption((String)pathToTezSite, (Security)Security.CUSTOM);
        doc = docBuilder.parse(pathToTezSite);
        Assert.assertEquals((Object)sslBeforeTest, (Object)ConfTool.getProperty((Document)doc, (String)"tez.runtime.shuffle.ssl.enable"));
        Assert.assertEquals((Object)keepAliveBeforeTest, (Object)ConfTool.getProperty((Document)doc, (String)"tez.runtime.shuffle.keep-alive.enabled"));
    }

    @Test
    public void testSetHeadersMaprSASL() throws ParserConfigurationException, TransformerException, SAXException, IOException {
        URL url = Thread.currentThread().getContextClassLoader().getResource("tez-site-03.xml");
        String pathToTezSite = url.getPath();
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        String testHeaderPath = "test/header/file";
        ConfTool.setHeaders((String)pathToTezSite, (Security)Security.MAPRSASL, (String)testHeaderPath);
        Document doc = docBuilder.parse(pathToTezSite);
        Assert.assertEquals((Object)testHeaderPath, (Object)ConfTool.getProperty((Document)doc, (String)"tez.ui.tomcat.response.headers.file"));
    }

    @Test
    public void testNotRemoveHeadersCustom() throws ParserConfigurationException, SAXException, IOException, TransformerException {
        URL url = Thread.currentThread().getContextClassLoader().getResource("tez-site-04.xml");
        String pathToTezSite = url.getPath();
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        Document doc = docBuilder.parse(pathToTezSite);
        String beforeHeadersPath = ConfTool.getProperty((Document)doc, (String)"tez.ui.tomcat.response.headers.file");
        ConfTool.setHeaders((String)pathToTezSite, (Security)Security.CUSTOM, (String)"test/header/file");
        doc = docBuilder.parse(pathToTezSite);
        Assert.assertEquals((Object)beforeHeadersPath, (Object)ConfTool.getProperty((Document)doc, (String)"tez.ui.tomcat.response.headers.file"));
    }

    @Test
    public void testNotSetHeadersCustom() throws ParserConfigurationException, SAXException, IOException, TransformerException {
        URL url = Thread.currentThread().getContextClassLoader().getResource("tez-site-03.xml");
        String pathToTezSite = url.getPath();
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        Document doc = docBuilder.parse(pathToTezSite);
        String beforeHeadersPath = ConfTool.getProperty((Document)doc, (String)"tez.ui.tomcat.response.headers.file");
        ConfTool.setHeaders((String)pathToTezSite, (Security)Security.CUSTOM, (String)"test/header/file");
        doc = docBuilder.parse(pathToTezSite);
        Assert.assertEquals((Object)beforeHeadersPath, (Object)ConfTool.getProperty((Document)doc, (String)"tez.ui.tomcat.response.headers.file"));
    }

    @Test
    public void testRemoveHeadersNoneSecurity() throws ParserConfigurationException, SAXException, IOException, TransformerException {
        URL url = Thread.currentThread().getContextClassLoader().getResource("tez-site-03.xml");
        String pathToTezSite = url.getPath();
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        ConfTool.setHeaders((String)pathToTezSite, (Security)Security.NONE, (String)"test/header/file");
        Document doc = docBuilder.parse(pathToTezSite);
        Assert.assertFalse((boolean)ConfTool.propertyExists((Document)doc, (String)"tez.ui.tomcat.response.headers.file"));
    }

    @Test
    public void testNotSetHeadersNoneSecurity() throws ParserConfigurationException, SAXException, IOException, TransformerException {
        URL url = Thread.currentThread().getContextClassLoader().getResource("tez-site-03.xml");
        String pathToTezSite = url.getPath();
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        ConfTool.setHeaders((String)pathToTezSite, (Security)Security.NONE, (String)"test/header/file");
        Document doc = docBuilder.parse(pathToTezSite);
        Assert.assertFalse((boolean)ConfTool.propertyExists((Document)doc, (String)"tez.ui.tomcat.response.headers.file"));
    }
}

