/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.accumulo;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Set;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.DefaultConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.conf.SiteConfiguration;
import org.apache.accumulo.core.security.thrift.TCredentials;
import org.apache.accumulo.server.security.handler.Authenticator;
import org.apache.accumulo.server.security.handler.Authorizor;
import org.apache.accumulo.server.security.handler.PermissionHandler;
import org.apache.accumulo.server.security.handler.ZKAuthenticator;
import org.apache.slider.accumulo.ProviderUtil;

public final class CustomAuthenticator
implements Authenticator {
    public static final String ROOT_INITIAL_PASSWORD_PROPERTY = "root.initial.password";
    private static ZKAuthenticator zkAuthenticator = null;

    public CustomAuthenticator() {
        zkAuthenticator = new ZKAuthenticator();
    }

    public void initialize(String instanceId, boolean initialize) {
        zkAuthenticator.initialize(instanceId, initialize);
    }

    public void initializeSecurity(TCredentials credentials, String principal, byte[] token) throws AccumuloSecurityException {
        String pass = null;
        SiteConfiguration siteconf = SiteConfiguration.getInstance((AccumuloConfiguration)DefaultConfiguration.getInstance());
        String jksFile = siteconf.get(Property.GENERAL_SECURITY_CREDENTIAL_PROVIDER_PATHS);
        if (jksFile == null) {
            throw new RuntimeException(Property.GENERAL_SECURITY_CREDENTIAL_PROVIDER_PATHS + " not specified in accumulo-site.xml");
        }
        try {
            pass = new String(ProviderUtil.getPassword(jksFile, ROOT_INITIAL_PASSWORD_PROPERTY));
        }
        catch (IOException ioe) {
            throw new RuntimeException("Can't get key root.initial.password from " + jksFile, ioe);
        }
        zkAuthenticator.initializeSecurity(credentials, principal, pass.getBytes(Charset.forName("UTF-8")));
    }

    public Set<String> listUsers() {
        return zkAuthenticator.listUsers();
    }

    public void createUser(String principal, AuthenticationToken token) throws AccumuloSecurityException {
        zkAuthenticator.createUser(principal, token);
    }

    public void dropUser(String user) throws AccumuloSecurityException {
        zkAuthenticator.dropUser(user);
    }

    public void changePassword(String principal, AuthenticationToken token) throws AccumuloSecurityException {
        zkAuthenticator.changePassword(principal, token);
    }

    public boolean userExists(String user) {
        return zkAuthenticator.userExists(user);
    }

    public boolean validSecurityHandlers(Authorizor auth, PermissionHandler pm) {
        return true;
    }

    public boolean authenticateUser(String principal, AuthenticationToken token) throws AccumuloSecurityException {
        return zkAuthenticator.authenticateUser(principal, token);
    }

    public Set<Class<? extends AuthenticationToken>> getSupportedTokenTypes() {
        return zkAuthenticator.getSupportedTokenTypes();
    }

    public boolean validTokenClass(String tokenClass) {
        return zkAuthenticator.validTokenClass(tokenClass);
    }
}

