/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.file;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.io.Files;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@VisibleForTesting
public class PolicyFile {
    private static final Logger LOGGER = LoggerFactory.getLogger(PolicyFile.class);
    private static final String NL = System.getProperty("line.separator", "\n");
    private final Map<String, String> databasesToPolicyFiles = Maps.newHashMap();
    private final Multimap<String, String> usersToGroups = ArrayListMultimap.create();
    protected final Multimap<String, String> groupsToRoles = ArrayListMultimap.create();
    protected final Multimap<String, String> rolesToPermissions = ArrayListMultimap.create();

    public Multimap<String, String> getGroupsToRoles() {
        return this.groupsToRoles;
    }

    public Multimap<String, String> getRolesToPermissions() {
        return this.rolesToPermissions;
    }

    public PolicyFile addRolesToGroup(String groupName, String ... roleNames) throws Exception {
        return this.addRolesToGroup(groupName, false, roleNames);
    }

    public PolicyFile addRolesToGroup(String groupName, boolean allowDuplicates, String ... roleNames) {
        return this.add(this.groupsToRoles.get((Object)groupName), allowDuplicates, roleNames);
    }

    public PolicyFile addPermissionsToRole(String roleName, String ... permissionNames) {
        return this.addPermissionsToRole(roleName, false, permissionNames);
    }

    public PolicyFile addPermissionsToRole(String roleName, boolean allowDuplicates, String ... permissionNames) {
        return this.add(this.rolesToPermissions.get((Object)roleName), allowDuplicates, permissionNames);
    }

    public PolicyFile addGroupsToUser(String userName, String ... groupNames) {
        LOGGER.warn("Static user:group mapping is not being used");
        return this.addGroupsToUser(userName, false, groupNames);
    }

    public PolicyFile addGroupsToUser(String userName, boolean allowDuplicates, String ... groupNames) {
        LOGGER.warn("Static user:group mapping is not being used");
        return this.add(this.usersToGroups.get((Object)userName), allowDuplicates, groupNames);
    }

    public PolicyFile setUserGroupMapping(Map<String, String> mapping) {
        for (Map.Entry<String, String> entry : mapping.entrySet()) {
            this.usersToGroups.put((Object)entry.getKey(), (Object)entry.getValue());
        }
        return this;
    }

    public PolicyFile addDatabase(String databaseName, String path) {
        String oldPath = this.databasesToPolicyFiles.put(databaseName, path);
        if (oldPath != null) {
            throw new IllegalStateException("Database " + databaseName + " already existed in " + this.databasesToPolicyFiles + " with value of " + oldPath);
        }
        this.databasesToPolicyFiles.put(databaseName, path);
        return this;
    }

    public PolicyFile removeRolesFromGroup(String groupName, String ... roleNames) {
        return this.remove(this.groupsToRoles.get((Object)groupName), roleNames);
    }

    public PolicyFile removePermissionsFromRole(String roleName, String ... permissionNames) {
        return this.remove(this.rolesToPermissions.get((Object)roleName), permissionNames);
    }

    public PolicyFile removeGroupsFromUser(String userName, String ... groupNames) {
        LOGGER.warn("Static user:group mapping is not being used");
        return this.remove(this.usersToGroups.get((Object)userName), groupNames);
    }

    public PolicyFile removeDatabase(String databaseName) {
        if (this.databasesToPolicyFiles.remove(databaseName) == null) {
            throw new IllegalStateException("Database " + databaseName + " did not exist in " + this.databasesToPolicyFiles);
        }
        return this;
    }

    public PolicyFile copy() {
        PolicyFile other = new PolicyFile();
        other.databasesToPolicyFiles.putAll(this.databasesToPolicyFiles);
        other.usersToGroups.putAll(this.usersToGroups);
        other.groupsToRoles.putAll(this.groupsToRoles);
        other.rolesToPermissions.putAll(this.rolesToPermissions);
        return other;
    }

    public void write(File clientFile, File serverFile) throws Exception {
        this.write(clientFile);
        this.write(serverFile);
    }

    public void write(File file) throws Exception {
        if (file.exists() && !file.delete()) {
            throw new IllegalStateException("Unable to delete " + file);
        }
        String contents = Joiner.on((String)NL).join((Object)this.getSection("databases", this.databasesToPolicyFiles), (Object)this.getSection("users", this.usersToGroups), new Object[]{this.getSection("groups", this.groupsToRoles), this.getSection("roles", this.rolesToPermissions), ""});
        LOGGER.info("Writing policy file to " + file + ":\n" + contents);
        Files.write((CharSequence)contents, (File)file, (Charset)Charsets.UTF_8);
    }

    private String getSection(String name, Map<String, String> mapping) {
        if (mapping.isEmpty()) {
            return "";
        }
        Joiner kvJoiner = Joiner.on((String)" = ");
        ArrayList lines = Lists.newArrayList();
        lines.add("[" + name + "]");
        for (Map.Entry<String, String> entry : mapping.entrySet()) {
            lines.add(kvJoiner.join((Object)entry.getKey(), (Object)entry.getValue(), new Object[0]));
        }
        return Joiner.on((String)NL).join((Iterable)lines);
    }

    private String getSection(String name, Multimap<String, String> mapping) {
        if (mapping.isEmpty()) {
            return "";
        }
        Joiner kvJoiner = Joiner.on((String)" = ");
        Joiner itemJoiner = Joiner.on((String)" , ");
        ArrayList lines = Lists.newArrayList();
        lines.add("[" + name + "]");
        for (String key : mapping.keySet()) {
            lines.add(kvJoiner.join((Object)key, (Object)itemJoiner.join((Iterable)mapping.get((Object)key)), new Object[0]));
        }
        return Joiner.on((String)NL).join((Iterable)lines);
    }

    private PolicyFile remove(Collection<String> exitingItems, String[] newItems) {
        for (String newItem : newItems) {
            if (exitingItems.remove(newItem)) continue;
            throw new IllegalStateException("Item " + newItem + " did not exist in " + exitingItems);
        }
        return this;
    }

    private PolicyFile add(Collection<String> exitingItems, boolean allowDuplicates, String[] newItems) {
        for (String newItem : newItems) {
            if (exitingItems.contains(newItem) && !allowDuplicates) {
                throw new IllegalStateException("Item " + newItem + " already exists in " + exitingItems);
            }
            exitingItems.add(newItem);
        }
        return this;
    }

    public static PolicyFile setAdminOnServer1(String admin) throws Exception {
        return new PolicyFile().addRolesToGroup(admin, "admin_role").addPermissionsToRole("admin_role", "server=server1");
    }
}

