/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.file;

import com.google.common.io.ByteStreams;
import com.google.common.io.Resources;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.shiro.config.Ini;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolicyFiles {
    private static final Logger LOGGER = LoggerFactory.getLogger(PolicyFiles.class);

    public static void copyToDir(File dest, String ... resources) throws FileNotFoundException, IOException {
        for (String resource : resources) {
            LOGGER.debug("Copying " + resource + " to " + dest);
            Resources.copy((URL)Resources.getResource((String)resource), (OutputStream)new FileOutputStream(new File(dest, resource)));
        }
    }

    public static void copyToDir(FileSystem fs, Path dest, String ... resources) throws FileNotFoundException, IOException {
        for (String resource : resources) {
            InputStream in = Resources.getResource((String)resource).openStream();
            FSDataOutputStream out = fs.create(new Path(dest, resource));
            long bytes = ByteStreams.copy((InputStream)in, (OutputStream)out);
            in.close();
            out.hflush();
            out.close();
            LOGGER.debug("Copying " + resource + " to " + dest + ", bytes " + bytes);
        }
    }

    public static void copyFilesToDir(FileSystem fs, Path dest, File inputFile) throws IOException {
        FileInputStream input = new FileInputStream(inputFile.getPath());
        FSDataOutputStream out = fs.create(new Path(dest, inputFile.getName()));
        ByteStreams.copy((InputStream)input, (OutputStream)out);
        ((InputStream)input).close();
        out.hflush();
        out.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Ini loadFromPath(FileSystem fileSystem, Path path) throws IOException {
        InputStream inputStream = null;
        try {
            LOGGER.debug("Opening " + path);
            String dfsUri = FileSystem.getDefaultUri((Configuration)fileSystem.getConf()).toString();
            inputStream = fileSystem.open(path);
            Ini ini = new Ini();
            ini.load(inputStream);
            Ini ini2 = ini;
            return ini2;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    LOGGER.warn("Error closing " + inputStream);
                }
            }
        }
    }
}

