/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.file;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.sentry.provider.common.GroupMappingService;
import org.apache.sentry.provider.common.ProviderConstants;
import org.apache.sentry.provider.file.PolicyFiles;
import org.apache.shiro.config.Ini;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalGroupMappingService
implements GroupMappingService {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalGroupMappingService.class);
    private final Map<String, Set<String>> groupMap = new HashMap<String, Set<String>>();

    public LocalGroupMappingService(Path resourcePath) throws IOException {
        this(new Configuration(), resourcePath);
    }

    @VisibleForTesting
    public LocalGroupMappingService(Configuration configuration, Path resourcePath) throws IOException {
        this.parseGroups(resourcePath.getFileSystem(configuration), resourcePath);
    }

    public LocalGroupMappingService(Configuration configuration, String resource) throws IOException {
        this(configuration, new Path(resource));
    }

    public Set<String> getGroups(String user) {
        if (this.groupMap.containsKey(user)) {
            return this.groupMap.get(user);
        }
        return Collections.emptySet();
    }

    private void parseGroups(FileSystem fileSystem, Path resourcePath) throws IOException {
        Ini ini = PolicyFiles.loadFromPath(fileSystem, resourcePath);
        Ini.Section usersSection = ini.getSection("users");
        if (usersSection == null) {
            LOGGER.warn("No section users in the " + resourcePath);
            return;
        }
        for (Map.Entry userEntry : usersSection.entrySet()) {
            String userName = Strings.nullToEmpty((String)((String)userEntry.getKey())).trim();
            String groupNames = Strings.nullToEmpty((String)((String)userEntry.getValue())).trim();
            if (userName.isEmpty()) {
                LOGGER.error("Invalid user name in the " + resourcePath);
                continue;
            }
            if (groupNames.isEmpty()) {
                LOGGER.warn("No groups available for user " + userName + " in the " + resourcePath);
                continue;
            }
            HashSet groupList = Sets.newHashSet((Iterable)ProviderConstants.ROLE_SPLITTER.trimResults().split((CharSequence)groupNames));
            LOGGER.debug("Got user mapping: " + userName + ", Groups: " + groupNames);
            this.groupMap.put(userName, groupList);
        }
    }
}

