/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.file;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.apache.sentry.provider.file.PolicyFileConstants;

public class KeyValue {
    private final String key;
    private final String value;

    public KeyValue(String keyValue) {
        ArrayList kvList = Lists.newArrayList((Iterable)PolicyFileConstants.KV_SPLITTER.trimResults().limit(2).split((CharSequence)keyValue));
        if (kvList.size() != 2) {
            throw new IllegalArgumentException("Invalid key value: " + keyValue + " " + kvList);
        }
        this.key = (String)kvList.get(0);
        this.value = (String)kvList.get(1);
        if (this.key.isEmpty()) {
            throw new IllegalArgumentException("Key cannot be empty");
        }
        if (this.value.isEmpty()) {
            throw new IllegalArgumentException("Value cannot be empty");
        }
    }

    public KeyValue(String key, String value) {
        this.key = key;
        this.value = value;
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return PolicyFileConstants.KV_JOINER.join((Object)this.key, (Object)this.value, new Object[0]);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        KeyValue other = (KeyValue)obj;
        if (this.key == null ? other.key != null : !this.key.equalsIgnoreCase(other.key)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equalsIgnoreCase(other.value));
    }
}

