/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.usergroupsync;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ranger.unixusersync.config.UserGroupSyncConfig;
import org.apache.ranger.usergroupsync.AbstractMapper;

public class RegEx
extends AbstractMapper {
    private UserGroupSyncConfig config = UserGroupSyncConfig.getInstance();
    private LinkedHashMap<String, String> replacementPattern;

    public LinkedHashMap<String, String> getReplacementPattern() {
        return this.replacementPattern;
    }

    @Override
    public void init(String baseProperty) {
        logger.info("Initializing for " + baseProperty);
        try {
            List<String> regexPatterns = this.config.getAllRegexPatterns(baseProperty);
            this.populateReplacementPatterns(baseProperty, regexPatterns);
        }
        catch (Throwable t) {
            logger.error("Failed to initialize " + baseProperty, t.fillInStackTrace());
        }
    }

    protected void populateReplacementPatterns(String baseProperty, List<String> regexPatterns) throws Throwable {
        this.replacementPattern = new LinkedHashMap();
        Pattern p = Pattern.compile("s/([^/]*)/([^/]*)/(g)?");
        for (String regexPattern : regexPatterns) {
            Matcher m = p.matcher(regexPattern);
            if (!m.matches()) {
                logger.warn("Invalid RegEx " + regexPattern + " and hence skipping this regex property");
            }
            m = m.reset();
            while (m.find()) {
                String matchPattern = m.group(1);
                String replacement = m.group(2);
                if (matchPattern == null || matchPattern.isEmpty() || replacement == null) continue;
                this.replacementPattern.put(matchPattern, replacement);
                if (!logger.isDebugEnabled()) continue;
                logger.debug(baseProperty + " match pattern = " + matchPattern + " and replacement string = " + replacement);
            }
        }
    }

    @Override
    public String transform(String attrValue) {
        String result = attrValue;
        try {
            if (this.replacementPattern != null && !this.replacementPattern.isEmpty()) {
                for (String matchPattern : this.replacementPattern.keySet()) {
                    String replacement;
                    Pattern p = Pattern.compile(matchPattern);
                    Matcher m = p.matcher(result);
                    if (!m.find() || (replacement = this.replacementPattern.get(matchPattern)) == null) continue;
                    result = m.replaceAll(replacement);
                }
            }
        }
        catch (Throwable t) {
            logger.error("Failed to transform " + attrValue, t.fillInStackTrace());
        }
        return result;
    }
}

