/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.storm;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.authentication.util.KerberosName;
import org.apache.ranger.plugin.audit.RangerDefaultAuditHandler;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerAccessRequestImpl;
import org.apache.ranger.plugin.policyengine.RangerAccessResource;
import org.apache.ranger.plugin.policyengine.RangerAccessResourceImpl;
import org.apache.ranger.plugin.policyengine.RangerAccessResultProcessor;
import org.apache.ranger.plugin.service.RangerBasePlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StormRangerPlugin
extends RangerBasePlugin {
    private static final Logger LOG = LoggerFactory.getLogger(StormRangerPlugin.class);
    boolean initialized = false;
    private final Map<String, String> impliedAccessTypes;

    public StormRangerPlugin() {
        super("storm", "storm");
        HashMap<String, String> impliedTypes = new HashMap<String, String>();
        impliedTypes.put("getTopologyPageInfo", "getTopologyInfo");
        impliedTypes.put("getComponentPageInfo", "getTopologyInfo");
        impliedTypes.put("setWorkerProfiler", "getTopologyInfo");
        impliedTypes.put("getWorkerProfileActionExpiry", "getTopologyInfo");
        impliedTypes.put("getComponentPendingProfileActions", "getTopologyInfo");
        impliedTypes.put("startProfiling", "getTopologyInfo");
        impliedTypes.put("stopProfiling", "getTopologyInfo");
        impliedTypes.put("dumpProfile", "getTopologyInfo");
        impliedTypes.put("dumpJstack", "getTopologyInfo");
        impliedTypes.put("dumpHeap", "getTopologyInfo");
        impliedTypes.put("setLogConfig", "getTopologyInfo");
        impliedTypes.put("getLogConfig", "getTopologyInfo");
        impliedTypes.put("debug", "getTopologyInfo");
        this.impliedAccessTypes = Collections.unmodifiableMap(impliedTypes);
    }

    public synchronized void init() {
        if (!this.initialized) {
            super.init();
            super.setResultProcessor((RangerAccessResultProcessor)new RangerDefaultAuditHandler((Configuration)this.getConfig()));
            if (KerberosName.getRules() == null) {
                KerberosName.setRules((String)"DEFAULT");
            }
            this.initialized = true;
            LOG.info("StormRangerPlugin initialized!");
        }
    }

    public RangerAccessRequest buildAccessRequest(String _user, String[] _groups, String _clientIp, String _topology, String _operation) {
        RangerAccessRequestImpl request = new RangerAccessRequestImpl();
        request.setUser(_user);
        if (_groups != null && _groups.length > 0) {
            HashSet groups = Sets.newHashSet((Object[])_groups);
            request.setUserGroups((Set)groups);
        }
        request.setAccessType(this.getAccessType(_operation));
        request.setClientIPAddress(_clientIp);
        request.setAction(_operation);
        RangerAccessResourceImpl resource = new RangerAccessResourceImpl();
        resource.setValue("topology", (Object)_topology);
        request.setResource((RangerAccessResource)resource);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Returning request: " + request.toString());
        }
        return request;
    }

    private String getAccessType(String _operation) {
        String ret = null;
        ret = this.impliedAccessTypes.get(_operation);
        if (ret == null) {
            ret = _operation;
        }
        return ret;
    }

    public static class StormConstants {

        static class ResourceName {
            static final String Topology = "topology";

            ResourceName() {
            }
        }

        static class PluginConfiguration {
            static final String ServiceType = "storm";
            static final String AuditApplicationType = "storm";

            PluginConfiguration() {
            }
        }
    }
}

