/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.admin.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.PrivilegedAction;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.ranger.admin.client.AbstractRangerAdminClient;
import org.apache.ranger.audit.provider.MiscUtil;
import org.apache.ranger.authorization.utils.StringUtil;
import org.apache.ranger.plugin.util.GrantRevokeRequest;
import org.apache.ranger.plugin.util.RangerPluginCapability;
import org.apache.ranger.plugin.util.RangerRoles;
import org.apache.ranger.plugin.util.RangerServiceNotFoundException;
import org.apache.ranger.plugin.util.RangerSslHelper;
import org.apache.ranger.plugin.util.RangerUserStore;
import org.apache.ranger.plugin.util.ServicePolicies;
import org.apache.ranger.plugin.util.ServiceTags;
import org.apache.ranger.plugin.util.URLEncoderUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerAdminJersey2RESTClient
extends AbstractRangerAdminClient {
    private static final Logger LOG = LoggerFactory.getLogger(RangerAdminJersey2RESTClient.class);
    boolean _isSSL = false;
    volatile Client _client = null;
    SSLContext _sslContext = null;
    HostnameVerifier _hv;
    String _sslConfigFileName = null;
    String _serviceName = null;
    String _serviceNameUrlParam = null;
    String _clusterName = null;
    boolean _supportsPolicyDeltas = false;
    boolean _supportsTagDeltas = false;
    String _pluginId = null;
    int _restClientConnTimeOutMs;
    int _restClientReadTimeOutMs;
    int _restClientMaxRetryAttempts;
    int _restClientRetryIntervalMs;
    private int lastKnownActiveUrlIndex;
    private List<String> configURLs;
    private boolean isRangerCookieEnabled;
    private String rangerAdminCookieName;
    private Cookie policyDownloadSessionId = null;
    private boolean isValidPolicyDownloadSessionCookie = false;
    private Cookie tagDownloadSessionId = null;
    private boolean isValidTagDownloadSessionCookie = false;
    private Cookie roleDownloadSessionId = null;
    private boolean isValidRoleDownloadSessionCookie = false;
    private final String pluginCapabilities = Long.toHexString(new RangerPluginCapability().getPluginCapabilities());
    private static final int MAX_PLUGIN_ID_LEN = 255;

    public void init(String serviceName, String appId, String configPropertyPrefix, Configuration config) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAdminJersey2RESTClient.init(" + configPropertyPrefix + ")");
        }
        super.init(serviceName, appId, configPropertyPrefix, config);
        this._serviceName = serviceName;
        this._pluginId = this.getPluginId(serviceName, appId);
        String tmpUrl = config.get(configPropertyPrefix + ".policy.rest.url");
        this._sslConfigFileName = config.get(configPropertyPrefix + ".policy.rest.ssl.config.file");
        this._restClientConnTimeOutMs = config.getInt(configPropertyPrefix + ".policy.rest.client.connection.timeoutMs", 120000);
        this._restClientReadTimeOutMs = config.getInt(configPropertyPrefix + ".policy.rest.client.read.timeoutMs", 30000);
        this._restClientMaxRetryAttempts = config.getInt(configPropertyPrefix + ".policy.rest.client.max.retry.attempts", 3);
        this._restClientRetryIntervalMs = config.getInt(configPropertyPrefix + ".policy.rest.client.retry.interval.ms", 1000);
        this._clusterName = config.get(configPropertyPrefix + ".access.cluster.name", "");
        if (StringUtil.isEmpty((String)this._clusterName)) {
            this._clusterName = config.get(configPropertyPrefix + ".ambari.cluster.name", "");
        }
        this._supportsPolicyDeltas = config.getBoolean(configPropertyPrefix + ".supports.policy.deltas", false);
        this._supportsTagDeltas = config.getBoolean(configPropertyPrefix + ".supports.tag.deltas", false);
        this.isRangerCookieEnabled = config.getBoolean(configPropertyPrefix + ".policy.rest.client.cookie.enabled", true);
        this.rangerAdminCookieName = config.get(configPropertyPrefix + ".policy.rest.client.session.cookie.name", "RANGERADMINSESSIONID");
        this.configURLs = StringUtil.getURLs((String)tmpUrl);
        this.lastKnownActiveUrlIndex = new Random().nextInt(this.configURLs.size());
        String url = this.configURLs.get(this.lastKnownActiveUrlIndex);
        this._isSSL = this.isSsl(url);
        LOG.info("Init params: " + String.format("Base URL[%s], SSL Config filename[%s], ServiceName=[%s], SupportsPolicyDeltas=[%s], ConfigURLs=[%s]", url, this._sslConfigFileName, this._serviceName, this._supportsPolicyDeltas, this._supportsTagDeltas, this.configURLs));
        this._client = this.getClient();
        this._client.property("jersey.config.client.connectTimeout", (Object)this._restClientConnTimeOutMs);
        this._client.property("jersey.config.client.readTimeout", (Object)this._restClientReadTimeOutMs);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAdminJersey2RESTClient.init(" + configPropertyPrefix + "): " + this._client.toString());
        }
        try {
            this._serviceNameUrlParam = URLEncoderUtil.encodeURIParam((String)serviceName);
        }
        catch (UnsupportedEncodingException e) {
            LOG.warn("Unsupported encoding, serviceName=" + serviceName);
            this._serviceNameUrlParam = serviceName;
        }
    }

    public ServicePolicies getServicePoliciesIfUpdated(long lastKnownVersion, long lastActivationTimeInMillis) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAdminJersey2RESTClient.getServicePoliciesIfUpdated(" + lastKnownVersion + ", " + lastActivationTimeInMillis + ")");
        }
        ServicePolicies servicePolicies = this.isRangerCookieEnabled && this.policyDownloadSessionId != null && this.isValidPolicyDownloadSessionCookie ? this.getServicePoliciesIfUpdatedWithCookie(lastKnownVersion, lastActivationTimeInMillis) : this.getServicePoliciesIfUpdatedWithCred(lastKnownVersion, lastActivationTimeInMillis);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAdminJersey2RESTClient.getServicePoliciesIfUpdated(" + lastKnownVersion + ", " + lastActivationTimeInMillis + "): " + servicePolicies);
        }
        return servicePolicies;
    }

    public RangerRoles getRolesIfUpdated(long lastKnowRoleVersion, long lastActivationTimeInMillis) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAdminJersey2RESTClient.getRolesIfUpdated(" + lastKnowRoleVersion + ", " + lastActivationTimeInMillis + ")");
        }
        RangerRoles rangerRoles = this.isRangerCookieEnabled && this.roleDownloadSessionId != null && this.isValidRoleDownloadSessionCookie ? this.getRangerRolesIfUpdatedWithCookie(lastKnowRoleVersion, lastActivationTimeInMillis) : this.getRangerRolesIfUpdatedWithCred(lastKnowRoleVersion, lastActivationTimeInMillis);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAdminJersey2RESTClient.getRolesIfUpdated(" + lastKnowRoleVersion + ", " + lastActivationTimeInMillis + "): " + rangerRoles);
        }
        return rangerRoles;
    }

    public void grantAccess(GrantRevokeRequest request) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAdminRESTClient.grantAccess(" + request + ")");
        }
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("pluginId", this._pluginId);
        String relativeURL = "/service/plugins/services/grant/" + this._serviceName;
        Response response = this.get(queryParams, relativeURL);
        int httpResponseCode = response == null ? -1 : response.getStatus();
        switch (httpResponseCode) {
            case -1: {
                LOG.warn("Unexpected: Null response from policy server while granting access! Returning null!");
                throw new Exception("unknown error!");
            }
            case 200: {
                LOG.debug("grantAccess() suceeded: HTTP status=" + httpResponseCode);
                break;
            }
            case 401: {
                throw new AccessControlException();
            }
            default: {
                String body = (String)response.readEntity(String.class);
                String message = String.format("Unexpected: Received status[%d] with body[%s] form url[%s]", httpResponseCode, body, relativeURL);
                LOG.warn(message);
                throw new Exception("HTTP status: " + httpResponseCode);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAdminRESTClient.grantAccess(" + request + ")");
        }
    }

    public void revokeAccess(GrantRevokeRequest request) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAdminRESTClient.grantAccess(" + request + ")");
        }
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("pluginId", this._pluginId);
        String relativeURL = "/service/plugins/services/revoke/" + this._serviceName;
        Response response = this.get(queryParams, relativeURL);
        int httpResponseCode = response == null ? -1 : response.getStatus();
        switch (httpResponseCode) {
            case -1: {
                LOG.warn("Unexpected: Null response from policy server while granting access! Returning null!");
                throw new Exception("unknown error!");
            }
            case 200: {
                LOG.debug("grantAccess() suceeded: HTTP status=" + httpResponseCode);
                break;
            }
            case 401: {
                throw new AccessControlException();
            }
            default: {
                String body = (String)response.readEntity(String.class);
                String message = String.format("Unexpected: Received status[%d] with body[%s] form url[%s]", httpResponseCode, body, relativeURL);
                LOG.warn(message);
                throw new Exception("HTTP status: " + httpResponseCode);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAdminRESTClient.grantAccess(" + request + ")");
        }
    }

    public ServiceTags getServiceTagsIfUpdated(long lastKnownVersion, long lastActivationTimeInMillis) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAdminJersey2RESTClient.getServiceTagsIfUpdated(" + lastKnownVersion + ", " + lastActivationTimeInMillis + ")");
        }
        ServiceTags serviceTags = this.isRangerCookieEnabled && this.tagDownloadSessionId != null && this.isValidTagDownloadSessionCookie ? this.getServiceTagsIfUpdatedWithCookie(lastKnownVersion, lastActivationTimeInMillis) : this.getServiceTagsIfUpdatedWithCred(lastKnownVersion, lastActivationTimeInMillis);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAdminJersey2RESTClient.getServiceTagsIfUpdated(" + lastKnownVersion + ", " + lastActivationTimeInMillis + "): " + serviceTags);
        }
        return serviceTags;
    }

    public List<String> getTagTypes(String pattern) throws Exception {
        throw new Exception("RangerAdminjersey2RESTClient.getTagTypes() -- *** NOT IMPLEMENTED *** ");
    }

    public RangerUserStore getUserStoreIfUpdated(long lastKnownUserStoreVersion, long lastActivationTimeInMillis) throws Exception {
        RangerUserStore ret;
        String resp;
        Response response;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAdminjersey2RESTClient.getUserStoreIfUpdated(lastKnownUserStoreVersion={}, lastActivationTimeInMillis={})", (Object)lastKnownUserStoreVersion, (Object)lastActivationTimeInMillis);
        }
        UserGroupInformation user = MiscUtil.getUGILoginUser();
        boolean isSecureMode = this.isKerberosEnabled(user);
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("lastKnownUserStoreVersion", Long.toString(lastKnownUserStoreVersion));
        queryParams.put("lastActivationTime", Long.toString(lastActivationTimeInMillis));
        queryParams.put("pluginId", this._pluginId);
        queryParams.put("clusterName", this._clusterName);
        queryParams.put("pluginCapabilities", this.pluginCapabilities);
        if (isSecureMode) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Checking UserStore updated as user: {}", (Object)user);
            }
            PrivilegedAction<Response> action = () -> {
                Response resp = null;
                String relativeURL = "/service/xusers/secure/download/" + this._serviceNameUrlParam;
                try {
                    resp = this.get(queryParams, relativeURL);
                }
                catch (Exception e) {
                    LOG.error("Failed to get response", (Throwable)e);
                }
                return resp;
            };
            response = (Response)user.doAs(action);
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Checking UserStore updated as user: {}", (Object)user);
            }
            String relativeURL = "/service/xusers/download/" + this._serviceNameUrlParam;
            response = this.get(queryParams, relativeURL);
        }
        if (response == null || response.getStatus() == 304) {
            if (response == null) {
                LOG.error("Error getting UserStore; Received NULL response!!. secureMode={}, user={}, serviceName={}", new Object[]{isSecureMode, user, this._serviceName});
            } else {
                String string = resp = response.hasEntity() ? (String)response.readEntity(String.class) : null;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("No change in UserStore. secureMode={}, user={}, response={}, serviceName={}, lastKnownUserStoreVersion={}, lastActivationTimeInMillis={}", new Object[]{isSecureMode, user, resp, this._serviceName, lastKnownUserStoreVersion, lastActivationTimeInMillis});
                }
            }
            ret = null;
        } else if (response.getStatus() == 200) {
            String body = (String)response.readEntity(String.class);
            ret = (RangerUserStore)this.getGson().fromJson(body, RangerUserStore.class);
        } else if (response.getStatus() == 404) {
            ret = null;
            LOG.error("Error getting UserStore; service not found. secureMode={}, user={}, response={}, serviceName={}, lastKnownUserStoreVersion={}, lastActivationTimeInMillis={}", new Object[]{isSecureMode, user, response.getStatus(), this._serviceName, lastKnownUserStoreVersion, lastActivationTimeInMillis});
            String exceptionMsg = response.hasEntity() ? (String)response.readEntity(String.class) : null;
            RangerServiceNotFoundException.throwExceptionIfServiceNotFound((String)this._serviceName, (String)exceptionMsg);
            LOG.warn("Received 404 error code with body:[{}], Ignoring", (Object)exceptionMsg);
        } else {
            resp = response.hasEntity() ? (String)response.readEntity(String.class) : null;
            LOG.warn("Error getting UserStore. secureMode={}, user={}, response={}, serviceName={}, lastKnownUserStoreVersion={}, lastActivationTimeInMillis={}", new Object[]{isSecureMode, user, resp, this._serviceName, lastKnownUserStoreVersion, lastActivationTimeInMillis});
            ret = null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAdminjersey2RESTClient.getUserStoreIfUpdated(lastKnownUserStoreVersion={}, lastActivationTimeInMillis={}): ret={}", new Object[]{lastKnownUserStoreVersion, lastActivationTimeInMillis, ret});
        }
        return ret;
    }

    Gson getGson() {
        return new GsonBuilder().setPrettyPrinting().registerTypeAdapter(Date.class, (Object)new GsonUnixDateDeserializer()).create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Client getClient() {
        Client result = this._client;
        if (result == null) {
            RangerAdminJersey2RESTClient rangerAdminJersey2RESTClient = this;
            synchronized (rangerAdminJersey2RESTClient) {
                result = this._client;
                if (result == null) {
                    this._client = result = this.buildClient();
                }
            }
        }
        return result;
    }

    Client buildClient() {
        if (this._isSSL) {
            if (this._sslContext == null) {
                RangerSslHelper sslHelper = new RangerSslHelper(this._sslConfigFileName);
                this._sslContext = sslHelper.createContext();
            }
            if (this._hv == null) {
                this._hv = new HostnameVerifier(){

                    @Override
                    public boolean verify(String urlHostName, SSLSession session) {
                        return session.getPeerHost().equals(urlHostName);
                    }
                };
            }
            this._client = ClientBuilder.newBuilder().sslContext(this._sslContext).hostnameVerifier(this._hv).build();
        }
        if (this._client == null) {
            this._client = ClientBuilder.newClient();
        }
        return this._client;
    }

    private Response get(Map<String, String> queyParams, String relativeURL) {
        Response response = null;
        int startIndex = this.lastKnownActiveUrlIndex;
        int currentIndex = 0;
        int retryAttempt = 0;
        for (int index = 0; index < this.configURLs.size(); ++index) {
            try {
                currentIndex = (startIndex + index) % this.configURLs.size();
                WebTarget target = this._client.target(this.configURLs.get(currentIndex) + relativeURL);
                response = RangerAdminJersey2RESTClient.setQueryParams(target, queyParams).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get();
                if (response == null) continue;
                this.setLastKnownActiveUrlIndex(currentIndex);
                break;
            }
            catch (ProcessingException e) {
                if (!this.shouldRetry(this.configURLs.get(currentIndex), index, retryAttempt, e)) continue;
                ++retryAttempt;
                index = -1;
            }
        }
        return response;
    }

    private Response get(Map<String, String> queyParams, String relativeURL, Cookie sessionId) {
        Response response = null;
        int startIndex = this.lastKnownActiveUrlIndex;
        int currentIndex = 0;
        int retryAttempt = 0;
        for (int index = 0; index < this.configURLs.size(); ++index) {
            try {
                currentIndex = (startIndex + index) % this.configURLs.size();
                WebTarget target = this._client.target(this.configURLs.get(currentIndex) + relativeURL);
                target = RangerAdminJersey2RESTClient.setQueryParams(target, queyParams);
                Invocation.Builder invocationBuilder = target.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).cookie(sessionId);
                response = invocationBuilder.get();
                if (response == null) continue;
                this.setLastKnownActiveUrlIndex(currentIndex);
                break;
            }
            catch (ProcessingException e) {
                if (!this.shouldRetry(this.configURLs.get(currentIndex), index, retryAttempt, e)) continue;
                ++retryAttempt;
                index = -1;
            }
        }
        return response;
    }

    private static WebTarget setQueryParams(WebTarget target, Map<String, String> params) {
        WebTarget ret = target;
        if (target != null && params != null) {
            Set<Map.Entry<String, String>> entrySet = params.entrySet();
            for (Map.Entry<String, String> entry : entrySet) {
                ret = ret.queryParam(entry.getKey(), new Object[]{entry.getValue()});
            }
        }
        return ret;
    }

    private void setLastKnownActiveUrlIndex(int lastKnownActiveUrlIndex) {
        this.lastKnownActiveUrlIndex = lastKnownActiveUrlIndex;
    }

    private boolean isSsl(String url) {
        return !StringUtils.isEmpty((String)url) && url.toLowerCase().startsWith("https");
    }

    private String getPluginId(String serviceName, String appId) {
        String hostName = null;
        try {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            LOG.error("ERROR: Unable to find hostname for the agent ", (Throwable)e);
            hostName = "unknownHost";
        }
        String ret = hostName + "-" + serviceName;
        if (!StringUtils.isEmpty((String)appId)) {
            ret = appId + "@" + ret;
        }
        if (ret.length() > 255) {
            ret = ret.substring(0, 255);
        }
        return ret;
    }

    private ServicePolicies getServicePoliciesIfUpdatedWithCred(long lastKnownVersion, long lastActivationTimeInMillis) throws Exception {
        ServicePolicies ret;
        boolean isSecureMode;
        UserGroupInformation user;
        Response response;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAdminJersey2RESTClient.getServicePoliciesWithCred(" + lastKnownVersion + ", " + lastActivationTimeInMillis + ")");
        }
        int httpResponseCode = (response = this.getRangerAdminPolicyDownloadResponse(lastKnownVersion, lastActivationTimeInMillis, user = MiscUtil.getUGILoginUser(), isSecureMode = this.isKerberosEnabled(user))) == null ? -1 : response.getStatus();
        String body = null;
        switch (httpResponseCode) {
            case 200: {
                body = (String)response.readEntity(String.class);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Response from 200 server: " + body);
                }
                Gson gson = this.getGson();
                ret = (ServicePolicies)gson.fromJson(body, ServicePolicies.class);
                this.setCookieReceivedFromCredSession(response);
                if (!LOG.isDebugEnabled()) break;
                LOG.debug("Deserialized response to: " + ret);
                break;
            }
            case 304: {
                ret = null;
                this.setCookieReceivedFromCredSession(response);
                LOG.debug("Got response: 304. Ok. Returning null");
                break;
            }
            case -1: {
                ret = null;
                this.policyDownloadSessionId = null;
                LOG.warn("Unexpected: Null response from policy server while trying to get policies! Returning null!");
                break;
            }
            case 404: {
                ret = null;
                this.policyDownloadSessionId = null;
                if (response.hasEntity() && StringUtils.isNotBlank((String)(body = (String)response.readEntity(String.class)))) {
                    RangerServiceNotFoundException.throwExceptionIfServiceNotFound((String)this._serviceName, (String)body);
                }
                LOG.warn("Received 404 error code with body:[" + body + "], Ignoring");
                break;
            }
            default: {
                ret = null;
                this.policyDownloadSessionId = null;
                body = (String)response.readEntity(String.class);
                LOG.warn(String.format("Unexpected: Received status[%d] with body[%s] form url[%s]", httpResponseCode, body, this.getRelativeURL(isSecureMode)));
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAdminJersey2RESTClient.getServicePoliciesWithCred(" + lastKnownVersion + ", " + lastActivationTimeInMillis + "): " + ret);
        }
        return ret;
    }

    private ServicePolicies getServicePoliciesIfUpdatedWithCookie(long lastKnownVersion, long lastActivationTimeInMillis) throws Exception {
        ServicePolicies ret;
        boolean isSecureMode;
        UserGroupInformation user;
        Response response;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAdminJersey2RESTClient.getServicePoliciesWithCookie(" + lastKnownVersion + ", " + lastActivationTimeInMillis + ")");
        }
        int httpResponseCode = (response = this.getRangerAdminPolicyDownloadResponse(lastKnownVersion, lastActivationTimeInMillis, user = MiscUtil.getUGILoginUser(), isSecureMode = this.isKerberosEnabled(user))) == null ? -1 : response.getStatus();
        String body = null;
        switch (httpResponseCode) {
            case 200: {
                body = (String)response.readEntity(String.class);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Response from 200 server: " + body);
                }
                Gson gson = this.getGson();
                ret = (ServicePolicies)gson.fromJson(body, ServicePolicies.class);
                this.checkAndResetSessionCookie(response);
                if (!LOG.isDebugEnabled()) break;
                LOG.debug("Deserialized response to: " + ret);
                break;
            }
            case 304: {
                ret = null;
                this.checkAndResetSessionCookie(response);
                LOG.debug("Got response: 304. Ok. Returning null");
                break;
            }
            case -1: {
                ret = null;
                this.policyDownloadSessionId = null;
                this.isValidPolicyDownloadSessionCookie = false;
                LOG.warn("Unexpected: Null response from policy server while trying to get policies! Returning null!");
                break;
            }
            case 404: {
                ret = null;
                this.policyDownloadSessionId = null;
                this.isValidPolicyDownloadSessionCookie = false;
                if (response.hasEntity() && StringUtils.isNotBlank((String)(body = (String)response.readEntity(String.class)))) {
                    RangerServiceNotFoundException.throwExceptionIfServiceNotFound((String)this._serviceName, (String)body);
                }
                LOG.warn("Received 404 error code with body:[" + body + "], Ignoring");
                break;
            }
            default: {
                ret = null;
                this.policyDownloadSessionId = null;
                this.isValidPolicyDownloadSessionCookie = false;
                body = (String)response.readEntity(String.class);
                LOG.warn(String.format("Unexpected: Received status[%d] with body[%s] form url[%s]", httpResponseCode, body, this.getRelativeURL(isSecureMode)));
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAdminJersey2RESTClient.getServicePoliciesWithCookie(" + lastKnownVersion + ", " + lastActivationTimeInMillis + "): " + ret);
        }
        return ret;
    }

    private Response getRangerAdminPolicyDownloadResponse(long lastKnownVersion, long lastActivationTimeInMillis, UserGroupInformation user, boolean isSecureMode) throws Exception {
        Response ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAdminJersey2RESTClient.getRangerAdminPolicyDownloadResponse(" + lastKnownVersion + ", " + lastActivationTimeInMillis + ")");
        }
        final HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("lastKnownVersion", Long.toString(lastKnownVersion));
        queryParams.put("lastActivationTime", Long.toString(lastActivationTimeInMillis));
        queryParams.put("pluginId", this._pluginId);
        queryParams.put("clusterName", this._clusterName);
        queryParams.put("supportsPolicyDeltas", Boolean.toString(this._supportsPolicyDeltas));
        queryParams.put("pluginCapabilities", this.pluginCapabilities);
        final String relativeURL = this.getRelativeURL(isSecureMode);
        if (isSecureMode) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Checking Service policy if updated as user : " + user);
            }
            PrivilegedAction<Response> action = new PrivilegedAction<Response>(){

                @Override
                public Response run() {
                    return RangerAdminJersey2RESTClient.this.get(queryParams, relativeURL, RangerAdminJersey2RESTClient.this.policyDownloadSessionId);
                }
            };
            ret = (Response)user.doAs((PrivilegedAction)action);
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Checking Service policy if updated with old api call");
            }
            ret = this.get(queryParams, relativeURL, this.policyDownloadSessionId);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAdminJersey2RESTClient.getRangerAdminPolicyDownloadResponse(" + lastKnownVersion + ", " + lastActivationTimeInMillis + "): " + ret);
        }
        return ret;
    }

    private String getRelativeURL(boolean isSecureMode) {
        String ret = isSecureMode ? "/service/plugins/secure/policies/download/" + this._serviceName : "/service/plugins/policies/download/" + this._serviceName;
        return ret;
    }

    private void checkAndResetSessionCookie(Response response) {
        Map cookieMap = response.getCookies();
        Set cookieNames = cookieMap.keySet();
        for (String cookieName : cookieNames) {
            if (!cookieName.equalsIgnoreCase(this.rangerAdminCookieName)) continue;
            this.policyDownloadSessionId = (Cookie)cookieMap.get(cookieName);
            this.isValidPolicyDownloadSessionCookie = this.policyDownloadSessionId != null;
            break;
        }
    }

    private void setCookieReceivedFromCredSession(Response response) {
        if (this.isRangerCookieEnabled) {
            Cookie sessionCookie = null;
            Map cookieMap = response.getCookies();
            Set cookieNames = cookieMap.keySet();
            for (String cookieName : cookieNames) {
                if (!cookieName.equalsIgnoreCase(this.rangerAdminCookieName)) continue;
                sessionCookie = (Cookie)cookieMap.get(cookieName);
                break;
            }
            this.policyDownloadSessionId = sessionCookie;
            this.isValidPolicyDownloadSessionCookie = this.policyDownloadSessionId != null;
        }
    }

    private ServiceTags getServiceTagsIfUpdatedWithCred(long lastKnownVersion, long lastActivationTimeInMillis) throws Exception {
        ServiceTags ret;
        boolean isSecureMode;
        UserGroupInformation user;
        Response response;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAdminJersey2RESTClient.getServiceTagsIfUpdatedWithCred(" + lastKnownVersion + ", " + lastActivationTimeInMillis + ")");
        }
        int httpResponseCode = (response = this.getTagsDownloadResponse(lastKnownVersion, lastActivationTimeInMillis, user = MiscUtil.getUGILoginUser(), isSecureMode = this.isKerberosEnabled(user))) == null ? -1 : response.getStatus();
        String body = null;
        switch (httpResponseCode) {
            case 200: {
                body = (String)response.readEntity(String.class);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Response from 200 server: " + body);
                }
                Gson gson = this.getGson();
                ret = (ServiceTags)gson.fromJson(body, ServiceTags.class);
                this.setCookieReceivedFromTagDownloadSession(response);
                if (!LOG.isDebugEnabled()) break;
                LOG.debug("Deserialized response to: " + ret);
                break;
            }
            case 304: {
                ret = null;
                this.setCookieReceivedFromTagDownloadSession(response);
                LOG.debug("Got response: 304. Ok. Returning null");
                break;
            }
            case -1: {
                ret = null;
                this.tagDownloadSessionId = null;
                LOG.warn("Unexpected: Null response from tag server while trying to get tags! Returning null!");
                break;
            }
            case 404: {
                ret = null;
                this.tagDownloadSessionId = null;
                if (response.hasEntity() && StringUtils.isNotBlank((String)(body = (String)response.readEntity(String.class)))) {
                    RangerServiceNotFoundException.throwExceptionIfServiceNotFound((String)this._serviceName, (String)body);
                }
                LOG.warn("Received 404 error code with body:[" + body + "], Ignoring");
                break;
            }
            default: {
                ret = null;
                this.tagDownloadSessionId = null;
                body = (String)response.readEntity(String.class);
                LOG.warn(String.format("Unexpected: Received status[%d] with body[%s] form url[%s]", httpResponseCode, body, this.getRelativeURLForTagDownload(isSecureMode)));
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAdminJersey2RESTClient.getServiceTagsIfUpdatedWithCred(" + lastKnownVersion + ", " + lastActivationTimeInMillis + "): " + ret);
        }
        return ret;
    }

    private ServiceTags getServiceTagsIfUpdatedWithCookie(long lastKnownVersion, long lastActivationTimeInMillis) throws Exception {
        ServiceTags ret;
        boolean isSecureMode;
        UserGroupInformation user;
        Response response;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAdminJersey2RESTClient.getServiceTagsIfUpdatedWithCookie(" + lastKnownVersion + ", " + lastActivationTimeInMillis + ")");
        }
        int httpResponseCode = (response = this.getTagsDownloadResponse(lastKnownVersion, lastActivationTimeInMillis, user = MiscUtil.getUGILoginUser(), isSecureMode = this.isKerberosEnabled(user))) == null ? -1 : response.getStatus();
        String body = null;
        switch (httpResponseCode) {
            case 200: {
                body = (String)response.readEntity(String.class);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Response from 200 server: " + body);
                }
                Gson gson = this.getGson();
                ret = (ServiceTags)gson.fromJson(body, ServiceTags.class);
                this.checkAndResetTagDownloadSessionCookie(response);
                if (!LOG.isDebugEnabled()) break;
                LOG.debug("Deserialized response to: " + ret);
                break;
            }
            case 304: {
                ret = null;
                this.checkAndResetTagDownloadSessionCookie(response);
                LOG.debug("Got response: 304. Ok. Returning null");
                break;
            }
            case -1: {
                ret = null;
                this.tagDownloadSessionId = null;
                this.isValidTagDownloadSessionCookie = false;
                LOG.warn("Unexpected: Null response from tag server while trying to get tags! Returning null!");
                break;
            }
            case 404: {
                ret = null;
                this.tagDownloadSessionId = null;
                this.isValidTagDownloadSessionCookie = false;
                if (response.hasEntity() && StringUtils.isNotBlank((String)(body = (String)response.readEntity(String.class)))) {
                    RangerServiceNotFoundException.throwExceptionIfServiceNotFound((String)this._serviceName, (String)body);
                }
                LOG.warn("Received 404 error code with body:[" + body + "], Ignoring");
                break;
            }
            default: {
                ret = null;
                this.tagDownloadSessionId = null;
                this.isValidTagDownloadSessionCookie = false;
                body = (String)response.readEntity(String.class);
                LOG.warn(String.format("Unexpected: Received status[%d] with body[%s] form url[%s]", httpResponseCode, body, ret));
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAdminJersey2RESTClient.getServiceTagsIfUpdatedWithCookie(" + lastKnownVersion + ", " + lastActivationTimeInMillis + "): " + ret);
        }
        return ret;
    }

    private Response getTagsDownloadResponse(long lastKnownVersion, long lastActivationTimeInMillis, UserGroupInformation user, boolean isSecureMode) throws Exception {
        Response ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAdminJersey2RESTClient.getTagsDownloadResponse(" + lastKnownVersion + ", " + lastActivationTimeInMillis + ")");
        }
        final HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("lastKnownVersion", Long.toString(lastKnownVersion));
        queryParams.put("lastActivationTime", Long.toString(lastActivationTimeInMillis));
        queryParams.put("pluginId", this._pluginId);
        queryParams.put("supportsTagDeltas", Boolean.toString(this._supportsTagDeltas));
        queryParams.put("pluginCapabilities", this.pluginCapabilities);
        final String relativeURL = this.getRelativeURLForTagDownload(isSecureMode);
        if (isSecureMode) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Checking Service tags if updated as user : " + user);
            }
            PrivilegedAction<Response> action = new PrivilegedAction<Response>(){

                @Override
                public Response run() {
                    return RangerAdminJersey2RESTClient.this.get(queryParams, relativeURL, RangerAdminJersey2RESTClient.this.tagDownloadSessionId);
                }
            };
            ret = (Response)user.doAs((PrivilegedAction)action);
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Checking Service tags if updated with old api call");
            }
            ret = this.get(queryParams, relativeURL, this.tagDownloadSessionId);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAdminJersey2RESTClient.getTagsDownloadResponse(" + lastKnownVersion + ", " + lastActivationTimeInMillis + "): " + ret);
        }
        return ret;
    }

    private String getRelativeURLForTagDownload(boolean isSecureMode) {
        String ret = isSecureMode ? "/service/tags/secure/download/" + this._serviceName : "/service/tags/download/" + this._serviceName;
        return ret;
    }

    private void checkAndResetTagDownloadSessionCookie(Response response) {
        Map cookieMap = response.getCookies();
        Set cookieNames = cookieMap.keySet();
        for (String cookieName : cookieNames) {
            if (!cookieName.equalsIgnoreCase(this.rangerAdminCookieName)) continue;
            this.tagDownloadSessionId = (Cookie)cookieMap.get(cookieName);
            this.isValidTagDownloadSessionCookie = this.tagDownloadSessionId != null;
            break;
        }
    }

    private void setCookieReceivedFromTagDownloadSession(Response response) {
        if (this.isRangerCookieEnabled) {
            Cookie sessionCookie = null;
            Map cookieMap = response.getCookies();
            Set cookieNames = cookieMap.keySet();
            for (String cookieName : cookieNames) {
                if (!cookieName.equalsIgnoreCase(this.rangerAdminCookieName)) continue;
                sessionCookie = (Cookie)cookieMap.get(cookieName);
            }
            this.tagDownloadSessionId = sessionCookie;
            this.isValidTagDownloadSessionCookie = this.tagDownloadSessionId != null;
        }
    }

    private RangerRoles getRangerRolesIfUpdatedWithCred(long lastKnownRoleVersion, long lastActivationTimeInMillis) throws Exception {
        RangerRoles ret;
        boolean isSecureMode;
        UserGroupInformation user;
        Response response;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAdminJersey2RESTClient.getRangerRolesIfUpdatedWithCred(" + lastKnownRoleVersion + ", " + lastActivationTimeInMillis + ")");
        }
        int httpResponseCode = (response = this.getRoleDownloadResponse(lastKnownRoleVersion, lastActivationTimeInMillis, user = MiscUtil.getUGILoginUser(), isSecureMode = this.isKerberosEnabled(user))) == null ? -1 : response.getStatus();
        String body = null;
        switch (httpResponseCode) {
            case 200: {
                body = (String)response.readEntity(String.class);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Response from 200 server: " + body);
                }
                Gson gson = this.getGson();
                ret = (RangerRoles)gson.fromJson(body, RangerRoles.class);
                this.setCookieReceivedFromRoleDownloadSession(response);
                if (!LOG.isDebugEnabled()) break;
                LOG.debug("Deserialized response to: " + ret);
                break;
            }
            case 304: {
                ret = null;
                this.setCookieReceivedFromRoleDownloadSession(response);
                LOG.debug("Got response: 304. Ok. Returning null");
                break;
            }
            case -1: {
                ret = null;
                this.roleDownloadSessionId = null;
                LOG.warn("Unexpected: Null response from policy server while trying to get policies! Returning null!");
                break;
            }
            case 404: {
                ret = null;
                this.roleDownloadSessionId = null;
                if (response.hasEntity() && StringUtils.isNotBlank((String)(body = (String)response.readEntity(String.class)))) {
                    RangerServiceNotFoundException.throwExceptionIfServiceNotFound((String)this._serviceName, (String)body);
                }
                LOG.warn("Received 404 error code with body:[" + body + "], Ignoring");
                break;
            }
            default: {
                ret = null;
                this.roleDownloadSessionId = null;
                body = (String)response.readEntity(String.class);
                LOG.warn(String.format("Unexpected: Received status[%d] with body[%s] form url[%s]", httpResponseCode, body, this.getRelativeURLForRoleDownload(isSecureMode)));
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAdminJersey2RESTClient.getRangerRolesIfUpdatedWithCred(" + lastKnownRoleVersion + ", " + lastActivationTimeInMillis + "): " + ret);
        }
        return ret;
    }

    private RangerRoles getRangerRolesIfUpdatedWithCookie(long lastKnownRoleVersion, long lastActivationTimeInMillis) throws Exception {
        RangerRoles ret;
        boolean isSecureMode;
        UserGroupInformation user;
        Response response;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAdminJersey2RESTClient.getRangerRolesIfUpdatedWithCookie(" + lastKnownRoleVersion + ", " + lastActivationTimeInMillis + ")");
        }
        int httpResponseCode = (response = this.getRoleDownloadResponse(lastKnownRoleVersion, lastActivationTimeInMillis, user = MiscUtil.getUGILoginUser(), isSecureMode = this.isKerberosEnabled(user))) == null ? -1 : response.getStatus();
        String body = null;
        switch (httpResponseCode) {
            case 200: {
                body = (String)response.readEntity(String.class);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Response from 200 server: " + body);
                }
                Gson gson = this.getGson();
                ret = (RangerRoles)gson.fromJson(body, RangerRoles.class);
                this.checkAndResetRoleDownloadSessionCookie(response);
                if (!LOG.isDebugEnabled()) break;
                LOG.debug("Deserialized response to: " + ret);
                break;
            }
            case 304: {
                ret = null;
                this.checkAndResetRoleDownloadSessionCookie(response);
                LOG.debug("Got response: 304. Ok. Returning null");
                break;
            }
            case -1: {
                ret = null;
                this.roleDownloadSessionId = null;
                this.isValidRoleDownloadSessionCookie = false;
                LOG.warn("Unexpected: Null response from policy server while trying to get policies! Returning null!");
                break;
            }
            case 404: {
                ret = null;
                this.roleDownloadSessionId = null;
                this.isValidRoleDownloadSessionCookie = false;
                if (response.hasEntity() && StringUtils.isNotBlank((String)(body = (String)response.readEntity(String.class)))) {
                    RangerServiceNotFoundException.throwExceptionIfServiceNotFound((String)this._serviceName, (String)body);
                }
                LOG.warn("Received 404 error code with body:[" + body + "], Ignoring");
                break;
            }
            default: {
                ret = null;
                this.roleDownloadSessionId = null;
                this.isValidRoleDownloadSessionCookie = false;
                body = (String)response.readEntity(String.class);
                LOG.warn(String.format("Unexpected: Received status[%d] with body[%s] form url[%s]", httpResponseCode, body, this.getRelativeURLForRoleDownload(isSecureMode)));
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAdminJersey2RESTClient.getRangerRolesIfUpdatedWithCookie(" + lastKnownRoleVersion + ", " + lastActivationTimeInMillis + "): " + ret);
        }
        return ret;
    }

    private Response getRoleDownloadResponse(long lastKnownRoleVersion, long lastActivationTimeInMillis, UserGroupInformation user, boolean isSecureMode) throws Exception {
        Response ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAdminJersey2RESTClient.getRoleDownloadResponse(" + lastKnownRoleVersion + ", " + lastActivationTimeInMillis + ")");
        }
        final HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("lastKnownRoleVersion", Long.toString(lastKnownRoleVersion));
        queryParams.put("lastActivationTime", Long.toString(lastActivationTimeInMillis));
        queryParams.put("pluginId", this._pluginId);
        queryParams.put("clusterName", this._clusterName);
        final String relativeURL = this.getRelativeURLForRoleDownload(isSecureMode);
        if (isSecureMode) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Checking Roles if updated as user : " + user);
            }
            PrivilegedAction<Response> action = new PrivilegedAction<Response>(){

                @Override
                public Response run() {
                    return RangerAdminJersey2RESTClient.this.get(queryParams, relativeURL, RangerAdminJersey2RESTClient.this.roleDownloadSessionId);
                }
            };
            ret = (Response)user.doAs((PrivilegedAction)action);
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Checking Roles if updated with old api call");
            }
            ret = this.get(queryParams, relativeURL, this.roleDownloadSessionId);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAdminJersey2RESTClient.getRoleDownloadResponse(" + lastKnownRoleVersion + ", " + lastActivationTimeInMillis + "): " + ret);
        }
        return ret;
    }

    private String getRelativeURLForRoleDownload(boolean isSecureMode) {
        String ret = isSecureMode ? "/service/roles/secure/download/" + this._serviceName : "/service/roles/download/" + this._serviceName;
        return ret;
    }

    private void checkAndResetRoleDownloadSessionCookie(Response response) {
        Map cookieMap = response.getCookies();
        Set cookieNames = cookieMap.keySet();
        for (String cookieName : cookieNames) {
            if (!cookieName.equalsIgnoreCase(this.rangerAdminCookieName)) continue;
            this.roleDownloadSessionId = (Cookie)cookieMap.get(cookieName);
            this.isValidRoleDownloadSessionCookie = this.roleDownloadSessionId != null;
            break;
        }
    }

    private void setCookieReceivedFromRoleDownloadSession(Response response) {
        if (this.isRangerCookieEnabled) {
            Cookie sessionCookie = null;
            Map cookieMap = response.getCookies();
            Set cookieNames = cookieMap.keySet();
            for (String cookieName : cookieNames) {
                if (!cookieName.equalsIgnoreCase(this.rangerAdminCookieName)) continue;
                sessionCookie = (Cookie)cookieMap.get(cookieName);
                break;
            }
            this.roleDownloadSessionId = sessionCookie;
            this.isValidRoleDownloadSessionCookie = this.roleDownloadSessionId != null;
        }
    }

    protected boolean shouldRetry(String currentUrl, int index, int retryAttemptCount, ProcessingException ex) {
        boolean ret;
        LOG.warn("Failed to communicate with Ranger Admin. URL: " + currentUrl + ". Error: " + ex.getMessage());
        boolean isLastUrl = index == this.configURLs.size() - 1;
        boolean bl = ret = isLastUrl && retryAttemptCount < this._restClientMaxRetryAttempts;
        if (ret) {
            LOG.warn("Waiting for " + this._restClientRetryIntervalMs + "ms before retry attempt #" + (retryAttemptCount + 1));
            try {
                Thread.sleep(this._restClientRetryIntervalMs);
            }
            catch (InterruptedException excp) {
                LOG.error("Failed while waiting to retry", (Throwable)excp);
            }
        } else if (isLastUrl) {
            LOG.error("Failed to communicate with all Ranger Admin's URL's : [ " + this.configURLs + " ]");
            throw new ProcessingException("Failed to communicate with all Ranger Admin's URL : [ " + this.configURLs + " ]", (Throwable)ex);
        }
        return ret;
    }

    public static class GsonUnixDateDeserializer
    implements JsonDeserializer<Date> {
        public Date deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return new Date(json.getAsJsonPrimitive().getAsLong());
        }
    }
}

